// ------------------------------------------------------------------------
//
//                (C) COPYRIGHT 2011 - 2015 SYNOPSYS, INC.
//                          ALL RIGHTS RESERVED
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  version 2 as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, see <https://gnu.org/licenses/>.
//
// ------------------------------------------------------------------------

#include <elpspacc.h>

#define MIN(x, y) ( ((x)<(y)) ? (x) : (y) )

// prevent reading passed the end of the buffer
static void read_from(unsigned char *dst, unsigned char *src, int off, int n, int max)
{
	if (!dst)
	return;
	while (off < max && n) {
		*dst++ = src[off++];
		--n;
	}
}

int spacc_read_context (spacc_device * spacc, int job_idx, int op, unsigned char * key, int ksz, unsigned char * iv, int ivsz)
{
	int ret = CRYPTO_OK;
	spacc_ctx *ctx = NULL;
	spacc_job *job = NULL;
	unsigned char buf[300];
	int buflen;

	if (job_idx < 0 || job_idx > SPACC_MAX_JOBS) {
		return CRYPTO_INVALID_HANDLE;
	}

	job = &spacc->job[job_idx];
	ctx = context_lookup_by_job(spacc, job_idx);

	if (NULL == ctx) {
		ret = CRYPTO_FAILED;
	} else {
		switch (op) {
		case SPACC_CRYPTO_OPERATION:
			buflen = MIN(sizeof(buf),(unsigned)spacc->config.ciph_page_size);
			pdu_from_dev32_s(buf,  ctx->ciph_key, buflen>>2, spacc_endian);
			switch (job->enc_mode) {
			case CRYPTO_MODE_AES_CBC:
			case CRYPTO_MODE_AES_CTR:
			case CRYPTO_MODE_AES_GCM:
				read_from(key, buf, 0, ksz, buflen);
				read_from(iv, buf,  32, 16, buflen);
				break;
			case CRYPTO_MODE_AES_XTS:
				if (key) {
					read_from(key,            buf,  0, ksz>>1, buflen);
					read_from(key + (ksz>>1), buf, 48, ksz>>1, buflen);
				}
				read_from(iv, buf, 32, 16, buflen);
				break;

			case CRYPTO_MODE_NULL:
			default:
				break;
			}

			break;
		case SPACC_HASH_OPERATION:
			buflen = MIN(sizeof(buf),(unsigned)spacc->config.hash_page_size);
			pdu_from_dev32_s(buf, ctx->hash_key, buflen>>2, spacc_endian);
			read_from(key, buf, 0, ksz, buflen);
			break;
		default:
			ret = CRYPTO_INVALID_MODE;
			break;
		}
	}
	return ret;
}
