/*
 * Copyright (c) 2015 Elliptic Technologies Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <elpspacc.h>

int spacc_process_jb(spacc_device *spacc)
{
	// are there jobs in the buffer?
	while (spacc->jb_head != spacc->jb_tail) {
		int x, y;

		x = spacc->jb_tail;
		if (spacc->job_buffer[x].active) {
			y = spacc_packet_enqueue_ddt_ex(spacc, 0,
			spacc->job_buffer[x].job_idx,
			spacc->job_buffer[x].src,
			spacc->job_buffer[x].dst,
			spacc->job_buffer[x].proc_sz,
			spacc->job_buffer[x].aad_offset,
			spacc->job_buffer[x].pre_aad_sz,
			spacc->job_buffer[x].post_aad_sz,
			spacc->job_buffer[x].iv_offset,
			spacc->job_buffer[x].prio);

			if (y != CRYPTO_FIFO_FULL) {
				spacc->job_buffer[x].active = 0;
			} else {
				return -1;
			}
		}

		x = (x + 1);
		if (x == SPACC_MAX_JOB_BUFFERS) { x = 0; }
		spacc->jb_tail = x;
	}
	return 0;
}
