/* SPDX-License-Identifier: GPL-2.0 */
/* 2020-02-12: File changed by Sony Corporation */
/*
 *	Variables and functions used by the code in sleep.c
 */

#include <asm/realmode.h>

extern unsigned long saved_video_mode;
extern long saved_magic;

extern int wakeup_pmode_return;

extern u8 wake_sleep_flags;

extern unsigned long acpi_copy_wakeup_routine(unsigned long);
extern void wakeup_long64(void);

#ifdef CONFIG_SNSC_SSBOOT
extern void do_suspend_lowlevel_ssboot(void);
extern void do_suspend_lowlevel_acpi_s3(void);
#else
extern void do_suspend_lowlevel(void);
#endif

#ifdef CONFIG_SNSC_SSBOOT
extern int x86_acpi_suspend_lowlevel(bool is_ssboot);
#else
extern int x86_acpi_suspend_lowlevel(void);
#endif

acpi_status asmlinkage x86_acpi_enter_sleep_state(u8 state);
