/*
 * This file adds stack traces support for required levels on x86.
 * arch/x86/kernel/return_address.c
 *
 *  Copyright 2014 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <linux/export.h>
#include <linux/ftrace.h>

#if defined(CONFIG_FRAME_POINTER)
#include <linux/sched.h>
#include <asm/unwind.h>
#include <asm/stacktrace.h>

void *caller_address(unsigned int level)
{
	struct task_struct *task = current;
	unsigned long *stack = NULL;
	struct unwind_state state;
	struct pt_regs *regs = NULL;
	unsigned long addr = 0;

	level += 2;

	if (!level)
		return NULL;

	task = task ? : current;
	if (!stack && task == current)
		stack = get_stack_pointer(current, NULL);

	for (unwind_start(&state, task, regs, stack);
		!unwind_done(&state); unwind_next_frame(&state)) {
		addr = unwind_get_return_address(&state);
		if (!addr)
			break;
		if (!--level)
			break;
	}
	return (void *)addr;
}

#else /* if defined(CONFIG_FRAME_POINTER) */

void *caller_address(unsigned int level)
{
	return NULL;
}

#endif /* if defined(CONFIG_FRAME_POINTER) */
EXPORT_SYMBOL_GPL(caller_address);
