#include <linux/module.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/printk.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>

static int proc_show_timestamp(struct seq_file *m, void *v)
{
	seq_printf(m, snsc_build_timestamp);
	return 0;
}

static int proc_show_timestamp_sec(struct seq_file *m, void *v)
{
	seq_printf(m, snsc_build_timestamp_sec);
	return 0;
}

static int builtin_sec_proc_open(struct inode *inode, struct file *file)
{
	return single_open(file, proc_show_timestamp_sec, NULL);
}

static int builtin_time_proc_open(struct inode *inode, struct file *file)
{
	return single_open(file, proc_show_timestamp, NULL);
}

static const struct file_operations builtin_sec_proc_fops = {
	.open		= builtin_sec_proc_open,
	.read		= seq_read,
	.llseek		= seq_lseek,
	.release	= single_release,
};

static const struct file_operations builtin_time_proc_fops = {
	.open		= builtin_time_proc_open,
	.read		= seq_read,
	.llseek		= seq_lseek,
	.release	= single_release,
};

static int __init proc_builtin_time_init(void)
{
	proc_create("snsc_build_timestamp_s", 0, NULL, &builtin_sec_proc_fops);
	proc_create("snsc_build_timestamp", 0, NULL, &builtin_time_proc_fops);

	return 0;
}
module_init(proc_builtin_time_init);
