/*
 * ARM PL35X SMC Driver Header
 *
 * Copyright (C) 2012 Xilinx, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 */

#ifndef __LINUX_MEMORY_PL35X_SMC_H
#define __LINUX_MEMORY_PL35X_SMC_H

enum pl35x_smc_ecc_mode {
	PL35X_SMC_ECCMODE_BYPASS = 0,
	PL35X_SMC_ECCMODE_APB = 1,
	PL35X_SMC_ECCMODE_MEM = 2
};

enum pl35x_smc_mem_width {
	PL35X_SMC_MEM_WIDTH_8 = 0,
	PL35X_SMC_MEM_WIDTH_16 = 1
};

u32 pl35x_smc_get_ecc_val(int ecc_reg);
int pl35x_smc_ecc_is_busy(void);
int pl35x_smc_get_nand_int_status_raw(void);
void pl35x_smc_clr_nand_int(void);
int pl35x_smc_set_ecc_mode(enum pl35x_smc_ecc_mode mode);
int pl35x_smc_set_ecc_pg_size(unsigned int pg_sz);
int pl35x_smc_set_buswidth(unsigned int bw);

#endif
