#!/bin/bash

display_usage()
{
   echo "Usage: ./build-kernel-deb.sh [CONFIG_FILE] [OPTIONS...]"
   echo 
   echo "OPTIONS"
   echo "	-c,	run debian/rules clean"
   echo "        -b,     run debian/rules binary-indep and debian build (bindeb-pkg)"
   echo "        -d,     run debian/rules binary-indep and debian build (deb-pkg)"
   echo "        -p,     run debian build (bindeb-pkg) only"
   echo "        -i,     build kernel image as per --build-instruction in setup file"
   echo "        -k,     build kbuild headers (along with -b, -d, -p and -i option)"
   echo "        -y,     skip configuration confirm check"
}

parse_config()
{
   DATE=`date +%Y%m%d`
   SCEL_VER=`cat $CONFIG_FILE | grep SCEL_VER | cut -d "=" -f2`
   COMMENT=`cat $CONFIG_FILE | grep COMMENT | cut -d "=" -f2`
   REL=`cat $CONFIG_FILE | grep REL | cut -d "=" -f2`
   PLAT_SETUP=`cat $CONFIG_FILE | grep PLAT_SETUP | cut -d "=" -f2`
   CONFIG_MODIFIERS=`cat $CONFIG_FILE | grep CONFIG_MODIFIERS | cut -d "=" -f2-`
   email=`cat ~/.gitconfig | grep mail | cut -d ' ' -f 3`
   name=`cat ~/.gitconfig | grep name | cut -d ' ' -f 3`
   build_instruction="$(grep "build-instruction=" setup-${PLAT_SETUP} | \
                          sed 's/--build-instruction="\(.*\)" \(.*\)/\1/' | sed -e "s/^[ \t]*//g")"
   cross_compile=$(grep "cross-compile=" setup-${PLAT_SETUP} | sed 's/--cross-compile="\(.*\)" \(.*\)/\1/' | sed -e "s/[ \t]//g")
   [ -z "${CROSS_COMPILE}" ] && export CROSS_COMPILE=${cross_compile}
   hostcc=${CROSS_COMPILE}gcc
   arch=$(grep "arch-name=" setup-${PLAT_SETUP} | sed 's/--arch-name="\(.*\)" \(.*\)/\1/' | sed -e "s/[ \t]//g")
   export DEBEMAIL=$email
   export DEBFULLNAME=$name
   if [ "$1" = "-b" -o "$1" = "-p" ]; then
      MAKE_TARGET=bindeb-pkg
   elif [ "$1" = "-d" ]; then
      MAKE_TARGET=deb-pkg
   elif [ "$1" = "-k" ]; then
      echo "-k option is used along with -b, -d, -p and -i option"
      display_usage
      exit 1
   fi
   if [ "$1" = "-c" ]; then
      DEBIAN_COMMAND[0]="make clean"
      DEBIAN_COMMAND[1]="fakeroot debian/rules clean;"
      DEBIAN_COMMAND[2]="dch -v $DATE.$REL-$SCEL_VER -b \"$COMMENT\""
      MAKE_COMMAND[0]=""
   elif [ "$1" = "-b" -o "$1" = "-d" -o "$1" = "-p" ]; then
      DEBIAN_COMMAND[0]=""
      if [ "$1" = "-b" -o "$1" = "-d" ]; then
         DEBIAN_COMMAND[0]="fakeroot debian/rules binary-indep full_build=true;"
         DEBIAN_COMMAND[1]="fakeroot debian/rules clean"
      fi
      MAKE_COMMAND[0]="./setup-$PLAT_SETUP $CONFIG_MODIFIERS;"
      MAKE_COMMAND[1]="make olddefconfig;"
      MAKE_COMMAND[2]="make -j$(nproc) $MAKE_TARGET KDEB_PKGVERSION=$DATE.$REL-$SCEL_VER;"
      if [ "$2" = "-k" ]; then
         MAKE_COMMAND[3]="make modules;"
         MAKE_COMMAND[4]="make kbuild_headers;"
      fi
   elif [ "$1" = "-i" ]; then
      DEBIAN_COMMAND[0]=""
      MAKE_COMMAND[0]="./setup-$PLAT_SETUP $CONFIG_MODIFIERS;"
      MAKE_COMMAND[1]="eval ${build_instruction};"
      if [ "$2" = "-k" ]; then
         MAKE_COMMAND[2]="make modules;"
         MAKE_COMMAND[3]="make kbuild_headers;"
      fi
   else
      echo "Invalid arguments"
      display_usage
      exit 1
   fi
}

print_config_values()
{
   echo "#"
   echo "# $(date)"
   echo "#"
   echo "# $(uname -a)"
   echo "#"
   echo "# $(${hostcc} --version | sed -n -e 1p)"
   echo "#"
   echo "# ${DEBIAN_COMMAND[@]}"
   echo "# ${MAKE_COMMAND[@]}"
   echo "#"
   echo "SCEL_VER="$SCEL_VER
   echo "COMMENT="$COMMENT
   echo "REL="$REL
   echo "PLAT_SETUP="$PLAT_SETUP
   echo "CONFIG_MODIFIERS=$CONFIG_MODIFIERS"
   echo "KCFLAGS=$KCFLAGS"
   echo "email="$email
   echo "name="$name
}

build_kernel()
{
   if [ "$arch" == "arm" ]; then
      export $(dpkg-architecture -aarmhf)
   elif [ "$arch" == "arm64" ]; then
      export $(dpkg-architecture -aarm64)
   fi
   [ -z "${ARCH}" ] && export ARCH=${arch}
   for command in "${DEBIAN_COMMAND[@]}"
   do
      if [[ -n "$command" ]]; then
         eval $command
         if [ $? -ne 0 ]; then
            echo "$command Failed"
            exit 1
         fi
      fi
   done
   for command in "${MAKE_COMMAND[@]}"
   do
      if [[ -n "$command" ]]; then
         eval $command
         if [ $? -ne 0 ]; then
            echo "$command Failed"
            exit 1
         fi
      fi
   done
}

configuration_confirm_check()
{
   if [ "$1" != "-y" ]; then
      read -r -p "Do you want to continue? [Y/n] " response
      response=${response,,}
      if [[ "$response" =~ ^(yes|y)$ ]]; then
         build_kernel
      else
         exit 1
      fi
   else
      build_kernel
   fi
}

###debains build script starts here
DATE=`date +%Y%m%d`
if [ "$1" = "" -o "$2" = "" ]; then
   display_usage
   exit 1
fi
CONFIG_FILE=$1
##check for config file exists or not
if [ -f $CONFIG_FILE ]; then
   parse_config $2 $3
   print_config_values
else
   echo "config file not found"
   display_usage
   exit 1
fi
if [ "$4" = "" ]; then
   configuration_confirm_check $3
else
   configuration_confirm_check $4
fi
