/*
 * drivers/udif/mach-cxd900xx/timestamp.c
 *
 * Copyright 2018,2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#include <linux/module.h>
#include <clocksource/arm_arch_timer.h>
#include <mach/udif/timer.h>
#include <linux/tmonitor.h>

#ifdef CONFIG_ARCH_CXD900XX_FPGA
# define TIMER_FREQ (CONFIG_ARCH_CXD900XX_FPGACLK/8)
#endif

unsigned long long notrace
udif_cycles_to_usecs(unsigned long long cnt)
{
#ifdef CONFIG_ARCH_CXD900XX_FPGA
	cnt *= 1000000;
	do_div(cnt, TIMER_FREQ);
	return cnt;
#else /* Freq. == 2MHz */
	return (cnt + 1) >> 1;
#endif /* CONFIG_ARCH_CXD900XX_FPGA */
}
EXPORT_SYMBOL(udif_cycles_to_usecs);

unsigned long long notrace
udif_usecs_to_cycles(unsigned long long usec)
{
#ifdef CONFIG_ARCH_CXD900XX_FPGA
	return (usec * TIMER_FREQ / 1000000);
#else /* Freq. == 2MHz */
	return usec << 1;
#endif /* CONFIG_ARCH_CXD900XX_FPGA */
}
EXPORT_SYMBOL(udif_usecs_to_cycles);

#if 0
unsigned long long notrace
boot_time_cpu_clock(int cpu)
{
	return get_cycles();
}

unsigned long long notrace
boot_time_count_to_usec(unsigned long long count)
{
	return udif_cycles_to_usecs(count);
}
#endif


unsigned long long notrace tmonitor_ts(void)
{
	return get_cycles();
}

unsigned long long notrace
tmonitor_ts_to_us(unsigned long long ts)
{
	return udif_cycles_to_usecs(ts);
}
