
#include <linux/kernel.h>
#include <linux/export.h>
#include <linux/notifier.h>
#include <linux/usb.h>
#include <linux/mutex.h>
#include "../core/usb.h"
#include <linux/usb/gadget.h>

static BLOCKING_NOTIFIER_HEAD(usb_notifier_list_gadget);

void usb_gadget_register_notify(struct notifier_block *nb)
{
	blocking_notifier_chain_register(&usb_notifier_list_gadget, nb);
}
EXPORT_SYMBOL_GPL(usb_gadget_register_notify);

void usb_gadget_unregister_notify(struct notifier_block *nb)
{
	blocking_notifier_chain_unregister(&usb_notifier_list_gadget, nb);
}
EXPORT_SYMBOL_GPL(usb_gadget_unregister_notify);


void usb_gadget_notify_add_host(struct usb_gadget *gadget)
{
	blocking_notifier_call_chain(&usb_notifier_list_gadget, USB_HOST_ADD, gadget);
}

void usb_gadget_notify_remove_host(struct usb_gadget *gadget)
{
	blocking_notifier_call_chain(&usb_notifier_list_gadget,
			USB_HOST_REMOVE, gadget);
}

