/*
 * Copyright 2009 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __UAPI_SB_SERIAL_H__
#define __UAPI_SB_SERIAL_H__


/* BackupSerialǂݏoTCY */
#define MODEL_NUM_SIZE	    5
#define SERIAL_NUM_SIZE	    4
/* USBVAԍ̃TCY */
#define USB_SERIAL_SIZE	    6
#define USB_SERIAL_A_SIZE	12

/* G[R[h */
typedef enum {
    SERIAL_RES_OK = 0,      /* OK */
    SERIAL_RES_NOTIMPL,     /*    */
    SERIAL_RES_BACKUP,      /* obNAbvReadG[   */
    SERIAL_RES_LENGTH,      /* i[z񒷃G[     */
    SERIAL_RES_PTR,         /* |C^֘A             */
    SERIAL_RES_PARAM,       /* p[^֘A           */
} SERIAL_RES;

/* OQƊ֐ */
#ifdef __cplusplus
extern "C"{
#endif
extern SERIAL_RES getUsbSerialNumAscii( unsigned char* usbSerialNum, int usbSerialNumLen);
extern unsigned char getBCDProductNum( unsigned char* BCDProductNum );
extern unsigned char getBCDProductSerial( unsigned char* BCDProductSerial );
extern SERIAL_RES getASCIIProductNum( unsigned char* ProductNum, int ProductNumLen );
extern SERIAL_RES getASCIIProductSerial( unsigned char* Serial, int SerialLen );
#ifdef __cplusplus
} /* closing brace for extern "C"	*/
#endif

#endif /* __UAPI_SB_SERIAL_H__ */
