#!/bin/sh
#
# scripts/cutdown.sh
#
# Slim down source tree
#
# Copyright 2018 Sony Corporation
#
#  This program is free software; you can redistribute  it and/or modify it
#  under  the terms of  the GNU General  Public License as published by the
#  Free Software Foundation;  version 2 of the  License.
#
#  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
#  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
#  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
#  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
#  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
#  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
#  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  You should have received a copy of the  GNU General Public License along
#  with this program; if not, write  to the Free Software Foundation, Inc.,
#  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
#

# Wildcard matching is affected by LANG.
export LANG=C

# Delete tree except Kbuild, Kconfig and Makefile.
function cutdown
{
    if [ ! -e $1 ]; then
	return;
    fi
    /usr/bin/find $1 -type f -and ! \( -name "Kbuild" -o -name "Kconfig*" -o -name "Makefile*" \) -exec /bin/rm -f {} \;
    if [ ! -e $1 ]; then
	return;
    fi
    /usr/bin/find $1 -depth -type d -exec /bin/rmdir --ignore-fail-on-non-empty {} \;
}

(cd Documentation && \
    for i in IPMI* SM501* blackfin cdrom cris dcd* dell* eisa* frv ia64 ide infini* is* j* ko_KR laptops logo* m68k metag mips mn* nios2 par* powerpc s390 sgi* sh svga* video* x86 xtensa z*; \
    do
        cutdown $i; \
    done)
(cd Documentation/filesystems && \
    for i in 9* a[a-t]* b* cifs* coda* [g-h]* jfs* ncpfs* nilfs* ntfs* o* spu* sysv* ufs*; \
    do
        cutdown $i; \
    done)

(cd arch && rm -rf alpha arc avr32 [b-t]* unicore32 xtensa) #exclude x86,um
(cd arch && \
    for i in um; \
    do \
        cutdown $i; \
    done)
(cd arch/x86 && \
    for i in [a-d]* events [f-z]*; \
    do \
        cutdown $i; \
    done) # exclude entry
(cd arch/x86/entry && \
    for i in [a-r]* syscall_* [t-z]*; \
    do \
        cutdown $i; \
    done) # exclude syscalls

(cd drivers && \
    for i in accessibility acpi atm bcma dio edac eisa firewire infiniband isdn macintosh message nubus parisc parport pcmcia pnp ps3 rapidio s390 sbus sh sn tc zorro; \
    do \
        cutdown $i; \
    done)

(cd drivers/char && \
    for i in agp applicom* ip2 mspec* mwave pcmcia snsc.* snsc_event.* sonypi* toshiba.c tpm; \
    do \
        cutdown $i; \
    done)

(cd drivers/gpu && \
    for i in drm; \
    do \
        cutdown $i; \
    done)

(cd drivers/net && \
    for i in appletalk arcnet hamradio irda sun*; \
    do \
        cutdown $i; \
    done)

(cd drivers/scsi && \
    for i in [0-9]* [A-J]* [N-Z]* [a-b]* d* esp* g* ibm* in* j* libsas lpfc [m-q]* sgi* sim* smart* sni* sun* sym53* w* z*; \
    do \
        cutdown $i; \
    done)

(cd drivers/tty/serial && \
    for i in cpm_uart cris* dz* icom* ioc* ip* jsm* m32* mcf* mpsc* pmac* pnx* \;
    do \
        cutdown $i; \
    done)

(cd firmware && \
    for i in *; \
    do \
        cutdown $i; \
    done)

(cd fs && \
    for i in 9p adfs affs afs befs bfs btrfs ceph cifs coda efs freevxfs gfs2 hfs hfsplus hostfs hpfs jfs minix ncpfs ntfs ocfs2 orangefs qnx* reiserfs ubifs ufs; \
    do \
        cutdown $i; \
    done) #exclude xfs

(cd fs/nls && \
    for i in nls_cp9*; \
    do \
        cutdown $i; \
    done)

#(cd sound && \
#    for i in aoa atmel drivers firewire hda i2c isa mips parisc pci pcmcia ppc sh soc sparc synth; \
#    do \
#        cutdown $i; \
#    done)
#(cd sound/oss && \
#    for i in ad* aedp* msnd* opl* pas* pss* sb* swarm* trix* waveartist*; \
#    do \
#        cutdown $i; \
#    done)

(cd tools/testing/selftests && rm -rf ia64 intel_pstate powerpc x86)

/bin/rm -f setup-amd-*
