/*
 *  config.h
 *
 *  Copyright 2018 Sony Corporation.
 *  Copyright 2019,2020 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __PCIEDMA_CONFIG_H__
#define __PCIEDMA_CONFIG_H__

#include "version.h"

#define DRV_NAME "pcidma"

#define PCIDMA_TIMEOUT 30 /* sec */
#define CB_TIMEOUT   10000UL /* usec */

#undef PCIEDMA_DEBUG

#define ER9001359142 /* enable ERRATA workaround */

#ifndef CONFIG_PCIEDMA_IRQ_THREAD
# if defined(CONFIG_EJ_USE_FPSIMD) && !defined(CONFIG_EJ_USE_FPSIMD_SUBSYSTEM)
#  define FPU_SAVE
#  include <asm/fpsimd.h>
# endif
#endif /* !CONFIG_PCIEDMA_IRQ_THREAD */

#endif /* __PCIEDMA_CONFIG_H__ */
