/*
 *  module.c
 *
 *  Copyright 2018 Sony Corporation.
 *  Copyright 2019,2020 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include "pcie_dma.h"

#include <linux/udif/module.h>
#include <mach/pcie_export.h>
#include <mach/noncache.h>
#include "regs.h"

#if 0
static uint32_t pcidma_ch_mask = 0x00;
module_param_named(mask, pcidma_ch_mask, uint, S_IRUSR);
#endif

static UDIF_ERR UDIF_INIT pcidma_init(UDIF_VP data)
{
	int pci;
	struct pci_info_t *p;

	pcidma_latency_mon_init();

#ifdef CONFIG_PROC_FS
	//pcidma_proc_dir_create();
#endif /* CONFIG_PROC_FS */
	printk(KERN_INFO "pciedma: %p(0x%llx)\n", pcie_dmacs, VA_TO_PHYS((uintptr_t)pcie_dmacs));
	for (pci = 0, p = pcie_dmacs; pci < PCIDMA_PCIE_MAX; pci++, p++) {
		int ch;
		struct dma_info_t *chan;
#ifdef ER9001359142
		int ret;
#endif

		if (!p->dmac)
			continue;
		p->id = pci;
		udif_spin_lock_init(&p->lock);
		p->state = 0;
		udif_spin_lock_init(&p->_lock);
		log_init(&p->log);
#ifdef ER9001359142
		ret = aspmctl_init(p);
		if (ret) {
			return ret;
		}
#endif /* ER9001359142 */
		for (ch=0, chan=p->dma_info; ch < PCIDMA_CH_MAX; ch++, chan++) {
			chan->id = ch;
			chan->pci_info = p;
			udif_spin_lock_init(&chan->_lock);
			chan->state = 0;
#ifdef ER9001359142
			aspmctl_chan_init(chan);
#endif
			chan->cur = NULL;
			INIT_LIST_HEAD(&chan->pending_list);
			dma_stat_init(&chan->stat);
			chan->dmawr.pwr = p->dmac + DMAWR_PWR(ch);
			chan->dmawr.ctl = p->dmac + DMAWR_CH(ch);
			chan->dmawr.doorbell = p->dmac + DMAWR_DOORBELL;
			chan->dmard.pwr = p->dmac + DMARD_PWR(ch);
			chan->dmard.ctl = p->dmac + DMARD_CH(ch);
			chan->dmard.doorbell = p->dmac + DMARD_DOORBELL;
			log_init(&chan->log);
		}
		pcidma_irq_setup(p);

#ifdef CONFIG_PROC_FS
		pcidma_proc_create(p);
#endif /* CONFIG_PROC_FS */
	}
#ifdef CONFIG_PCIEDMA_ER3425265
	stallmon_init();
#endif

	pcidma_cdev_init();
	pcie_host_register_cb(pcidma_host_cb);

	return UDIF_ERR_OK;
}

static UDIF_ERR UDIF_EXIT pcidma_exit(UDIF_VP data)
{
	int pci;
	struct pci_info_t *p;

	pcie_host_unregister_cb();
	pcidma_cdev_exit();

	for (pci = 0, p = pcie_dmacs; pci < PCIDMA_PCIE_MAX; pci++, p++) {
 #ifdef CONFIG_PROC_FS
		pcidma_proc_remove(p);
 #endif /* CONFIG_PROC_FS */
		if (!p->dmac)
			continue;
		pcidma_irq_remove(p);
		pcidma_shutdown(p);
#ifdef ER9001359142
		aspmctl_exit(p);
#endif
	}
#ifdef CONFIG_PCIEDMA_ER3425265
	stallmon_exit();
#endif
#ifdef CONFIG_PROC_FS
	//pcidma_proc_dir_remove();
#endif /* CONFIG_PROC_FS */
	return UDIF_ERR_OK;
}

static UDIF_ERR pcidma_suspend(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	return UDIF_ERR_OK;
}

static UDIF_ERR pcidma_resume(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	return UDIF_ERR_OK;
}

static UDIF_DRIVER_OPS pcidma_ops = {
	.init		= pcidma_init,
	.exit		= pcidma_exit,
#ifdef CONFIG_PM
	.suspend	= pcidma_suspend,
	.resume		= pcidma_resume,
#endif /* CONFIG_PM */
};

UDIF_IDS(pcidma_ids) = {};
UDIF_DEPS(pcidma_deps) = {};
static UDIF_DECLARE_DRIVER(pcidma, DRV_NAME, DRV_VER, &pcidma_ops, pcidma_ids, pcidma_deps, NULL);

static int __init __udif_init_pcidma(void)
{
	UDIF_DRIVER *drv = &pcidma;
	return udif_driver_register(&drv, 1);
}
late_initcall(__udif_init_pcidma);

MODULE_AUTHOR("Sony Corporation");
MODULE_DESCRIPTION("PCIe DMAC driver");
MODULE_LICENSE("GPL");
