/*
 * mach-cxd900xx/include/mach/regs-srst.h
 *
 * CXD90057 software reset registers
 *
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __REGS_SRST_H
#define __REGS_SRST_H

#include <mach/regs-scu.h>
#define SRST_DATA	SCU_DATA
#define SRST_SET	SCU_SET
#define SRST_CLR	SCU_CLR

/* channels */
#define SRST_MEDIA	0
#define SRST_PCI	1
# define SRST_PCI0	 0
# define SRST_PCI1	 8
# define SRST_PCI2	 4
# define SRST_PCI3	 12
# define SRST_PCI4	 16
# define SRST_PCI_PWR	 0
# define SRST_PCI_BTN	 1
# define SRST_PCI_PE	 2
# define SRST_PCI_APB	 3
#define SRST_MEM	2
# define SRST_DDR_ALL	0xFFFFF
#define SRST_DMAC	3
#define SRST_TIMER	4
#define SRST_SERIAL	5
#define SRST_MISC	6
#define SRST_LOGIC	7

#endif /* __REGS_SRST_H */
