/*
 * drivers/usb/f_usb/usb_dwc3_regs.h
 *
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _USB_DWC3_REGS_H_
#define _USB_DWC3_REGS_H_

#include <../drivers/usb/dwc3/core.h>   /* FIXME */
#include <../drivers/usb/host/xhci.h>   /* FIXME */

struct fusb_controller_regs_t {
	void __iomem *otg_regs;
	void __iomem *host_regs;
	void __iomem *gadget_regs;
	void __iomem *global_regs;
};

#ifdef CONFIG_USB_FUSB_DWC3_REGS
void fusb_get_controller_regs(struct fusb_controller_regs_t *p, void __iomem *base);
void fusb_setup_controller_name(struct device *dev);
#else
static inline void fusb_get_controller_regs(struct fusb_controller_regs_t *p, void __iomem *base) {}
static inline void fusb_setup_controller_name(struct device *dev) {}
#endif

#endif  /* _USB_DWC3_REGS_H_ */
