/*
 * (C) Copyright 2016 Sony Corporation
 */

#ifndef _BOOT_TIME_H_
#define _BOOT_TIME_H_

#include <linux/types.h>

#if (CONFIG_BOOT_TIME_MAX_COMMENT & 3)
#error CONFIG_BOOT_TIME_MAX_COMMENT should be 4 bytes aligned value.
#endif

#ifdef CONFIG_BOOT_TIME_MAX_COMMENT
#define MAX_COMMENT	CONFIG_BOOT_TIME_MAX_COMMENT
#else
#define MAX_COMMENT	24
#endif

#define BOOT_TIME_MAGIC_BASE 0x4E554355
#define BOOT_TIME_VERSION	2
#define BOOT_TIME_MAGIC (BOOT_TIME_MAGIC_BASE + BOOT_TIME_VERSION)

struct boot_time_entry_t {
	u_int32_t	count_lo;
	u_int32_t	count_hi;
	char		comment[];
};

struct boot_time_t {
	u_int32_t	magic;
	u_int32_t	offHead;
	u_int32_t	offNext;
	u_int32_t	offMax;
	u_int32_t	max_comment;
	u_int32_t	numWritten;
	struct boot_time_entry_t  first_entry;
};

void boot_time_add(char *comment);
void boot_time_init(void);
int shell_boottime(int argc, char *const argv[]);

#ifdef CONFIG_BOOT_TIME
#define BOOT_TIME_ADD(s)	boot_time_add(s)
#else
#define BOOT_TIME_ADD(s)	do { } while (0)
#endif

#endif /* _BOOT_TIME_H_ */
