/*
 * Configuration for Xilinx ZynqMP Flash utility
 *
 * (C) Copyright 2014 - 2015 Xilinx, Inc.
 * Michal Simek <michal.simek@xilinx.com>
 * Siva Durga Prasad Paladugu <sivadur@xilinx.com>
 *
 * Based on Configuration for Versatile Express
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef __CONFIG_ZYNQMP_MINI_H
#define __CONFIG_ZYNQMP_MINI_H

/* #define CONFIG_SYS_DCACHE_OFF */
#define CONFIG_SYS_ICACHE_OFF

#define CONFIG_SYS_MEMTEST_SCRATCH     0xfffc0000

#include <configs/xilinx_zynqmp.h>

/* Undef unneeded configs */
#undef CONFIG_EXTRA_ENV_SETTINGS
#undef CONFIG_BOARD_LATE_INIT
#undef CONFIG_SYS_HUSH_PARSER
#undef CONFIG_SYS_PROMPT_HUSH_PS2
#undef CONFIG_PREBOOT
#undef CONFIG_SYS_MALLOC_LEN
#undef CONFIG_ENV_SIZE
#undef CONFIG_CMDLINE_EDITING
#undef CONFIG_AUTO_COMPLETE
#undef CONFIG_ZLIB
#undef CONFIG_GZIP
#undef CONFIG_CMD_SPL
#undef CONFIG_CMD_ENV
#undef CONFIG_SYS_INIT_SP_ADDR
#undef CONFIG_SYS_LONGHELP
#undef CONFIG_CMD_SF_TEST
#undef CONFIG_FIT_VERBOSE
#undef CONFIG_CMD_UBI
#undef CONFIG_RBTREE
#undef CONFIG_CMD_UBIFS
#undef CONFIG_LZO
#undef CONFIG_CMD_MTDPARTS
#undef CONFIG_MTD_DEVICE
#undef CONFIG_MTD_PARTITIONS
#undef CONFIG_MTD_UBI_WL_THRESHOLD
#undef CONFIG_MTD_UBI_BEB_LIMIT
#undef CONFIG_SPI_FLASH_MTD
#undef CONFIG_BOOTM_NETBSD
#undef CONFIG_BOOTM_VXWORKS
#undef CONFIG_BOOTM_LINUX
#undef CONFIG_PARTITION_UUIDS
#undef CONFIG_PARTITIONS
#undef CONFIG_CMD_PART
#undef CONFIG_CMD_CLK
#undef CONFIG_ISO_PARTITION

/* BOOTP options */
#undef CONFIG_BOOTP_BOOTFILESIZE
#undef CONFIG_BOOTP_BOOTPATH
#undef CONFIG_BOOTP_GATEWAY
#undef CONFIG_BOOTP_HOSTNAME
#undef CONFIG_BOOTP_MAY_FAIL
#undef CONFIG_BOOTP_PXE
#undef CONFIG_CMD_UNZIP

/* PXE */
#undef CONFIG_CMD_PXE
#undef CONFIG_MENU

#undef CONFIG_NR_DRAM_BANKS
#define CONFIG_NR_DRAM_BANKS	1

#if defined(CONFIG_MINI_QSPI)
# define CONFIG_SYS_SDRAM_SIZE		(256 * 1024)
# define CONFIG_SYS_SDRAM_BASE		0xFFFC0000
# define CONFIG_ENV_SIZE		1400
# define CONFIG_SYS_INIT_SP_ADDR	(CONFIG_SYS_SDRAM_BASE + 0x20000)
# define CONFIG_SYS_MALLOC_LEN		0x2000

#elif defined(CONFIG_MINI_NAND)
# define CONFIG_SYS_SDRAM_SIZE		0x1000000
# define CONFIG_SYS_SDRAM_BASE		0
# define CONFIG_ENV_SIZE		0x10000
# define CONFIG_SYS_INIT_SP_ADDR	(CONFIG_SYS_SDRAM_BASE + 0x40000)
# define CONFIG_SYS_MALLOC_LEN		0x800000

#elif defined(CONFIG_MINI_EMMC)
# define CONFIG_ENV_SIZE		0x10000
# define CONFIG_SYS_INIT_SP_ADDR	CONFIG_SYS_TEXT_BASE
# define CONFIG_SYS_MALLOC_LEN		0x800000
# define CONFIG_PARTITIONS
# define CONFIG_SYS_LONGHELP
# undef CONFIG_ENV_IS_IN_FAT
# undef FAT_ENV_DEVICE_AND_PART
# undef FAT_ENV_FILE
# undef FAT_ENV_INTERFACE
#endif

#endif /* __CONFIG_ZYNQMP_MINI_H */
