/*
 *  Copyright (C) 2011 Sony Corporation.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA
 */

#ifndef __EV1_2D_H__
#define __EV1_2D_H__

/*****EV1 DEFINE*****/
#if 0
#define EV1_ENABLE_FILLRECTANGLE
#endif

#define EV1_SUPPORTED_DRAWINGFLAGS (DSDRAW_NOFX)
#define EV1_SUPPORTED_DRAWINGFUNCTIONS (DFXL_FILLRECTANGLE)
#define EV1_SUPPORTED_BLITTINGFLAGS (DSBLIT_NOFX | DSBLIT_BLEND_COLORALPHA | DSBLIT_COLORIZE)
#define EV1_SUPPORTED_BLITTINGFUNCTIONS (DFXL_BLIT |DFXL_STRETCHBLIT)

/*****EV1 GRAPHICS FUNCTION*****/
void      ev1CheckState   ( void                *drv,
                            void                *dev,
                            CardState           *state,
                            DFBAccelerationMask  accel );

void      ev1SetState     ( void                *drv,
                            void                *dev,
                            GraphicsDeviceFuncs *funcs,
                            CardState           *state,
                            DFBAccelerationMask  accel );

bool      ev1FillRectangle( void                *drv,
                            void                *dev,
                            DFBRectangle        *rect );

bool      ev1Blit         ( void                *drv,
                            void                *dev,
                            DFBRectangle        *srect,
                            int                  dx,
                            int                  dy );

bool      ev1StretchBlit  ( void                *drv,
                            void                *dev,
                            DFBRectangle        *srect,
                           DFBRectangle        *drect );

#if defined(EV1_DEBUG)
void debugPrintFormat(DFBSurfacePixelFormat format);
void debugPrintState(CardState* state);
#endif // EV1_DEBUG

#endif // __EV1_2D_H__

