/*
 *  Copyright (C) 2011 Sony Corporation.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA
 */

#ifndef __EV1_GFXDRIVER_H__
#define __EV1_GFXDRIVER_H__

/*****DEBUG*****/
#if 0
#define EV1_DEBUG
#endif

#if defined(EV1_DEBUG)
#define EV1_DEBUG_FUNC
#define EV1_DEBUG_PRINT
#define EV1_DEBUG_STATE
#endif

#if defined(EV1_DEBUG_FUNC)
#define FUNCTION_ENTER() \
    do{ \
        fprintf(stderr, "%s[%d]:[ENTER] %s\n", __FILE__, __LINE__, __FUNCTION__); \
    }while(0)
#else
#define FUNCTION_ENTER() \
    ;
#endif

#if defined(EV1_DEBUG_FUNC)
#define FUNCTION_EXIT() \
    do{ \
        fprintf(stderr, "%s[%d]:[EXIT] %s\n", __FILE__, __LINE__, __FUNCTION__); \
    }while(0)
#else
#define FUNCTION_EXIT() \
    ;
#endif

#if defined(EV1_DEBUG_PRINT)
#define DEBUG_PRINT(fmt, arg...)\
    do{ \
        fprintf(stderr, "%s[%d]: " fmt, __FUNCTION__, __LINE__, ##arg); \
    }while(0)
#else
#define DEBUG_PRINT(fmt, arg...) \
    ;
#endif

/*****EV1 DEFINE*****/
typedef struct _EV1DriverData {
	int fd;
	int base_addr;
	int reserved;
} EV1DriverData;

typedef struct _EV1DeviceData {
	uint32_t src_addr;
	uint32_t src_pitch;
	DFBSurfacePixelFormat src_format;
	uint32_t src_depth;
	uint32_t src_colorkey;
	int src_width;
	int src_height;
	int clip_x1, clip_x2, clip_y1, clip_y2;
        void *src_map_addr;

	uint32_t dst_addr;
	uint32_t dst_pitch;
	DFBSurfacePixelFormat dst_format;
	uint32_t dst_depth;
	int dst_width;
	int dst_height;
        void *dst_map_addr;

	uint32_t color_pixel;
        s32 matrix[9];
        DFBBoolean affine_matrix;
        DFBSurfaceRenderOptions render_options;
	
	DFBSurfaceDrawingFlags  drawingflags;
	DFBSurfaceBlittingFlags blittingflags;

	uint32_t v_flags;
	int reserved;
} EV1DeviceData;

#endif //__EV1_GFXDRIVER_H__
