/*
 *  arch/arm/include/asm/smp.h
 *
 *  Copyright (C) 2004-2005 ARM Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef __ASM_ARM_SMP_H
#define __ASM_ARM_SMP_H

#include <linux/threads.h>
#include <linux/cpumask.h>
#include <linux/thread_info.h>

#include <mach/smp.h>

#ifndef CONFIG_SMP
# error "<asm/smp.h> included in non-SMP build"
#endif

#ifndef CONFIG_SNSC_USE_MPIDR_FOR_SMP_PROCESSOR_ID
#define raw_smp_processor_id() (current_thread_info()->cpu)
#else
static inline int __pure
raw_smp_processor_id(void)
{
	register int cpu_id, *sp asm ("sp");

	asm ( "mrc p15, 0, %0, c0, c0, 5" : "=r"(cpu_id) : "m"(*sp) );
#ifdef CONFIG_SNSC_USE_MPIDR_DIRECT
	/*
	 * If the Cluster ID field in the CPU ID Register is set to zero
	 * on the ARM11 MPCore processor, use the CPU ID Register
	 * directly as the smp_processor_id().
	 */
#else
	cpu_id &= 0x0f;
#endif
	return cpu_id;
}
#endif

/*
 * at the moment, there's not a big penalty for changing CPUs
 * (the >big< penalty is running SMP in the first place)
 */
#define PROC_CHANGE_PENALTY		15

struct seq_file;

/*
 * generate IPI list text
 */
extern void show_ipi_list(struct seq_file *p);

/*
 * Called from assembly code, this handles an IPI.
 */
#ifdef CONFIG_SNSC_IRQ_OVERHEAD_ONCE
           void do_IPI(struct pt_regs *regs);
#else
asmlinkage void do_IPI(struct pt_regs *regs);
#endif

/*
 * Setup the SMP cpu_possible_map
 */
extern void smp_init_cpus(void);

/*
 * Move global data into per-processor storage.
 */
extern void smp_store_cpu_info(unsigned int cpuid);

/*
 * Raise an IPI cross call on CPUs in callmap.
 */
extern void smp_cross_call(cpumask_t callmap);

/*
 * Broadcast a timer interrupt to the other CPUs.
 */
extern void smp_send_timer(void);

/*
 * Broadcast a clock event to other CPUs.
 */
extern void smp_timer_broadcast(cpumask_t mask);

/*
 * Boot a secondary CPU, and assign it the specified idle task.
 * This also gives us the initial stack to use for this CPU.
 */
extern int boot_secondary(unsigned int cpu, struct task_struct *);

/*
 * Called from platform specific assembly code, this is the
 * secondary CPU entry point.
 */
asmlinkage void secondary_start_kernel(void);

/*
 * Perform platform specific initialisation of the specified CPU.
 */
extern void platform_secondary_init(unsigned int cpu);

/*
 * Initial data for bringing up a secondary CPU.
 */
struct secondary_data {
	unsigned long pgdir;
	void *stack;
};
extern struct secondary_data secondary_data;

extern int __cpu_disable(void);
extern int mach_cpu_disable(unsigned int cpu);

extern void __cpu_die(unsigned int cpu);
extern void cpu_die(void);

extern void platform_cpu_die(unsigned int cpu);
extern int platform_cpu_kill(unsigned int cpu);
extern void platform_cpu_enable(unsigned int cpu);

extern void arch_send_call_function_single_ipi(int cpu);
extern void arch_send_call_function_ipi(cpumask_t mask);

/*
 * Local timer interrupt handling function (can be IPI'ed).
 */
extern void local_timer_interrupt(void);

#ifdef CONFIG_LOCAL_TIMERS

/*
 * Stop a local timer interrupt.
 */
extern void local_timer_stop(void);

/*
 * Platform provides this to acknowledge a local timer IRQ
 */
extern int local_timer_ack(void);

#else

static inline void local_timer_stop(void)
{
}

#endif

/*
 * Setup a local timer interrupt for a CPU.
 */
extern void local_timer_setup(void);

/*
 * show local interrupt info
 */
extern void show_local_irqs(struct seq_file *);

/*
 * Called from assembly, this is the local timer IRQ handler
 */
asmlinkage void do_local_timer(struct pt_regs *);

#endif /* ifndef __ASM_ARM_SMP_H */
