#include <linux/module.h>
#include <linux/sched.h>

#include <asm/stacktrace.h>

struct return_address_data {
	unsigned int level;
	void *addr;
};

static int save_return_addr(struct stackframe *frame, void *d)
{
	struct return_address_data *data = d;

	if (!data->level) {
		/*
		 * walk_stackframe() sets the frame->pc rather than
		 * frame->lr, so frame->pc should be used here.
		 */
		data->addr = (void *)frame->pc;

		return 1;
	} else {
		--data->level;
		return 0;
	}
}

void *return_address(unsigned int level)
{
	struct stackframe frame;
	struct return_address_data data;
	register unsigned long current_sp asm ("sp");
	unsigned long fp;

	/*
	 * We are using frame->pc instead of frame->lr to
	 * do backtrace, thus the trace level is 1 more than
	 * using frame->lr.
	 */
	data.level = level + 2;

	asm("mov %0, fp" : "=r" (fp));
	frame.fp = fp;
	frame.sp = current_sp;
	frame.lr = (unsigned long)__builtin_return_address(0);
	frame.pc = (unsigned long)return_address;

	walk_stackframe(&frame, save_return_addr, &data);

	if (!data.level)
		return data.addr;
	else
		return NULL;
}
EXPORT_SYMBOL_GPL(return_address);
