﻿/*
 *  arch/arm/mach-emxx/csi/csi_Ctrl.h
 *  CSI_CONCTRL interface
 *
 *  Copyright 2011 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */

#ifndef __CSICTRL_H_
#define __CSICTRL_H_

#ifdef __KERNEL__
#include<linux/types.h>
#else
#include<stdint.h>
#include<sys/ioctl.h>
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#define CSI_CTRL_NAME       "csi_nod"
#define CSILIB_SEND_DATA_SIZE      4   /* 4Byte = record the send data size */

#define CSI_CTRL_PACKET_DATA_SIZE 380   /* 380Byte = send and receive data size in the packet */
#define CSI_CTRL_CIRC_BUFF_SIZE     8192  /* 3MByte = 8192*384Byte, reserve one packet for circle buffer handler */
#define CSI_CTRL_MMAP_SBUFF_SIZE     (3*1024*1024 + 4*1024)    /* Sender buffer (3MB) + Safe Reserve (2KB) */
#define CSI_CTRL_MMAP_RBUFF_SIZE     (3*1024*1024 + 4*1024)    /* Sender buffer (3MB) + Safe Reserve (2KB) */

#define CSI_CTRL_SEND_BUFF_MGR_OFFSET   (0)   /* send buffer manager offset 0KB */
#define CSI_CTRL_SEND_BUFF_OFFSET   (3*1024)  /* send buffer base address offset 1KB */
#define CSI_CTRL_SEND_BUFF_SIZE     (3*1024*1024+1*1024)  /* Range of send buffer 3MB+1KB */
#define CSI_CTRL_RECEIVE_BUFF_MGR_OFFSET   (0)   /* send buffer manager offset 0KB */
#define CSI_CTRL_RECEIVE_BUFF_OFFSET  (3*1024)  /* receive buffer base address offset 1KB */
#define CSI_CTRL_RECEIVE_BUFF_SIZE  (3*1024*1024+1*1024)  /* Range of send buffer 3MB+1KB */

/*
 * @brief Struct of CSI message
*/
typedef struct CSI_MSG_DATA_t {
    unsigned long       data_addr;    /*address of the data*/
    unsigned long       packet_count; /*the count of the packet*/
} CSI_MSG_DATA;

/*
 * @brief Struct of CSI packet
*/
typedef struct CSI_PACKET_t {
    unsigned short  seqNo;    /*sequence NO.*/
    unsigned short  reverse;  /*reserved*/
    unsigned char   Data[CSI_CTRL_PACKET_DATA_SIZE]; /*data*/
} CSI_PACKET;

/*
 * @brief Struct of CSI buffer conctrol
*/
typedef struct CSI_CIRC_BUFF_t {
    CSI_PACKET* buf;   /*pointer of packet*/
    int buff_dummy[7]; /*reserved*/
    int write;   /*the write pointer of the buffer*/
    int write_dummy[7]; /*reserved*/
    int read;    /*the read pointer of the buffer*/
    int read_dummy[7]; /*reserved*/
} CSI_CIRC_BUFF;

#define CSI_CTRL_IO_MAGIC                           'C'

#define CSI_CTRL_SEND_DATA          _IOWR ( CSI_CTRL_IO_MAGIC,  0, unsigned long )
#define CSI_CTRL_RECEIVE_DATA           _IOWR ( CSI_CTRL_IO_MAGIC,  1, CSI_MSG_DATA )
#define CSI_CTRL_GET_SBUFF_PHY_ADDR   _IOWR ( CSI_CTRL_IO_MAGIC,  2, unsigned long )
#define CSI_CTRL_GET_BUFF_SIZE            _IOWR ( CSI_CTRL_IO_MAGIC,  3, unsigned long )
#define CSI_CTRL_GET_RBUFF_PHY_ADDR   _IOWR ( CSI_CTRL_IO_MAGIC,  4, unsigned long )
#define CSI_CTRL_RECEIVER_CANCEL       _IOWR ( CSI_CTRL_IO_MAGIC,  5, unsigned long )
#define CSI_CTRL_DRV_INIT            _IOWR ( CSI_CTRL_IO_MAGIC,  6, unsigned long )
#define CSI_CTRL_MAX_NR                                         7

/* Return a mod b */
#define CSI_MOD(a, b)   ((a)&(b))

/* Return count in buffer.  */
#define CSI_CIRC_CNT(write,read,size) (CSI_MOD(((write) - (read)), ((size)-1)))

/* Return space available, 0..size-1.  We always leave one free cell
   as a completely full buffer has write == read, which is the same as
   empty.  */
#define CSI_CIRC_SPACE(write,read,size) CSI_CIRC_CNT((read),((write)+1),(size))

/* Return count up to the end of the buffer.  Carefully avoid
   accessing head and tail more than once, so they can change
   underneath us without returning inconsistent results.  */
#define CSI_CIRC_CNT_TO_END(write,read,size) \
    ({int end = (size) - (read); \
        int n = CSI_MOD(((write) + end), ((size)-1)); \
        n < end ? n : end;})

/* Return space available up to the end of the buffer.  */
#define CSI_CIRC_SPACE_TO_END(write,read,size) \
    ({int end = (size) - 1 - (write); \
        int n = CSI_MOD((end + (read)), ((size)-1)); \
        n <= end ? n : end+1;})
#endif  /* CSICTRL_H */

