﻿/*
 *  arch/arm/mach-emxx/csi/csi_datalink.h
 *  CSI_DATALINK interface
 *
 *  Copyright 2011 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */

#ifndef __PHYADR_DRV_H_
#define __PHYADR_DRV_H_

#define CSI_DL_SENDPACKETCOMPLETE 0
#define CSI_DL_SENDPACKETFAIL     1

#ifdef CONFIG_SNSC_HSS
#define CSI_DL_E_HSS_NODE_NAME          "csi_dl_e_hss_node_name"
#define CSI_DL_E_HSS_NODE_NAME_PARENT   NULL    /* parent is spi and gpio, registered in LDM */
#endif /* #ifdef CONFIG_SNSC_HSS */

int csi_dl_init(void* pfuncdmairq, void* pfuncpenirq, unsigned long dma_dummy_send_p, unsigned long dma_receive_p);
int csi_dl_send_packet(unsigned long dma_send_p, unsigned int number);
void csi_dl_enable_pen(void);
void csi_dl_disable_pen(void);

void csi_lowlevel_callback(void);
void csi_drv_rdyflag_init(void);


#endif
