﻿/*
 *  File Name	    : arch/arm/mach-emxx/dma.h
 *  Function	    : dmac
 *  Release Version : Ver 1.01
 *  Release Date    : 2010/06/22
 *
 *  Copyright (C) 2010 Renesas Electronics Corporation
 *
 *  This program is free software;you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by Free
 *  Softwere Foundation; either version 2 of License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY;
 *  without even the implied warrnty of MERCHANTABILITY or FITNESS FOR A
 *  PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program;
 *  If not, write to the Free Software Foundation, Inc., 59 Temple Place -
 *  Suite 330, Boston,
 *  MA 02111-1307, USA.
 *
 */

#ifndef __ARCH_MACH_EMXX_DMA_H
#define __ARCH_MACH_EMXX_DMA_H


#define EMXX_DMAC_M2P_CONF		0x0010
#define EMXX_DMAC_M2P_CONF_TRANS	8

/****  Macro definition  ****/

#define EMXX_DMAC_MASK_CHNO	0x000000ff
#define	EMXX_DMAC_MASK_OWNER	0x03000000
#define EMXX_DMAC_MASK_BLKSIZE 	0x0000ffff
#define EMXX_DMAC_MASK_LENGTH	0x00ffffff
#define EMXX_DMAC_MASK_INT	(EMXX_DMAC_INT_TIME_EN \
				| EMXX_DMAC_INT_ERROR_EN \
				| EMXX_DMAC_INT_BLOCK_EN \
				| EMXX_DMAC_INT_LENG_EN)
#define	EMXX_DMAC_SIZE_BLKSIZEL	0x00001000
#define	EMXX_DMAC_SIZE_BLKSIZES	0x00000080
#define	EMXX_DMAC_SIZE_BLKSIZEMIN	0x00000001

#define EMXX_DMAC_P0_MAX_L_CHANNELS	8
#define EMXX_DMAC_P1_MAX_L_CHANNELS	8
#define EMXX_DMAC_P2_MAX_L_CHANNELS	EMXX_DMAC_P1_MAX_L_CHANNELS

#define EMXX_DMAC_MASK_BASE	0xffff0000


/****  Macro function  ****/

#define EMXX_DMAC_PCHNO(x)        (((x) & 0xe0) >> 5)
#define EMXX_DMAC_DEVICENO(x)     ((x) & 0x1f)
#define EMXX_DMAC_PARBASE2LCHNO(x) ((((long)(x)) >> 8) & 0xf)
#define EMXX_DMAC_OWNER(x)        (((x) & EMXX_DMAC_MASK_OWNER) >> 24)


/****  Structure definition  ****/

/*
 * EMXX DMAC register arrangement
 */
#define reg_volatile	volatile

/* DMA 制御レジスタ */
struct cntsts_t {
    reg_volatile u_int32_t start;	/* +0x00 DMA スタートレジスタ */
    reg_volatile u_int32_t status;	/* +0x04 DMA 状態レジスタ */
    reg_volatile u_int32_t stop;	/* +0x08 DMA ストップレジスタ */
};

/*
 * 割込み関連レジスタ
 */
struct intparm_t {
    reg_volatile u_int32_t stat;	/* +0x00 割込み状態レジスタ */
    reg_volatile u_int32_t raw_stat;	/* +0x04 ロウ割込み状態レジスタ */
    reg_volatile u_int32_t enable; 	/* +0x08 割込みenable */
    reg_volatile u_int32_t disable;	/* +0x0c 割込みdisable */
    reg_volatile u_int32_t clear;	/* +0x10 割込みクリア */
    reg_volatile u_int32_t rsv[3];	/* +0x14,0x18,0x1c 保留ビット */
};

/*
 * DMAロジックチャンネル関連データ管理
 */
struct emxx_dmal_t {
    const char      *name;	/* ロジックチャンネル名. */
    dma_callback_t   callback;	/* 割込みコールバック関数. */
    void            *data;	/* コールバック関数の引数. */
    u_int32_t        defmode;	/* デフォルト転送モード. */
    u_int8_t         in_use;	/* DMA使用フラグ. */
    u_int8_t         owner;	/* ロジックチャンネルの所持者(ACPU/CCPU/DSP) */
    u_int8_t         irq;	/* 割込み号 */
    u_int8_t         device;	/* ロジックチャンネルのデバイス号 */
};

/* for `in_use' setting */
#define DMA_NO_USE	0
#define DMA_USE 	1

/*
 * DMA物理チャンネル関連データ管理
 */
struct emxx_dmap_t {
	struct cntsts_t    *control; /* 制御と状態レジスタ. */
	struct intparm_t   *intstat; /* 割込み制御レジスタ. */
	struct dma_regs    *parbase; /* DMA引数レジスタのベースアドレス. */
	struct emxx_dmal_t *lch;     /* ロジックチャンネル管理の構造体. */
	u_int32_t	lchno;	     /* ロジックチャンネル号. */
	u_int32_t	not_int;     /* マスクの割込みビット */
	int (*setup_dma)(dma_regs_t *, dma_addr_t, u_int,
			dma_addr_t, u_int32_t);	/* チャンネル設定ポインタ */
};

#endif /* __ARCH_MACH_EMXX_DMA_H */
