﻿/*
 *  arch/arm/mach-emxx/emif/ab0.h
 *  EMMA mobile1 AB0 header
 *
 *  Copyright 2011 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */

#ifndef __AB0_H_
#define __AB0_H_


#define     AB0_BASE_ADDR           0x2FFF0000
#define     AB0_SIZE                0x400

/// System Control Register

#define AB0_FLASHCOMSET     (0x2FFF0000)    ///<  W  0000_0000H  Flash コマンドスタート?レジスタ
#define AB0_FLASHCOMLATCH   (0x2FFF0004)    ///<  R  0000_0000H  Flash 読み込みデータラッチレジスタ
#define AB0_FLASHCOMADD0    (0x2FFF0010)    ///< R/W 0000_0000H  Flash コマンド(ADD0)設定レジスタ
#define AB0_FLASHCOMDATA0   (0x2FFF0014)    ///< R/W 0000_0000H  Flash コマンド(DATA0)設定レジスタ
#define AB0_FLASHCOMADD1    (0x2FFF0018)    ///< R/W 0000_0000H  Flash コマンド(ADD1)設定レジスタ
#define AB0_FLASHCOMDATA1   (0x2FFF001C)    ///< R/W 0000_0000H  Flash コマンド(DATA1)設定レジスタ
#define AB0_FLASHCLKCTRL    (0x2FFF0080)    ///< R/W 0000_0001H  Flash クロック制御レジスタ
#define AB0_FLA_RCLK_DLY    (0x2FFF0084)    ///< R/W 0000_1000H  Flash リードクロックの遅延調整レジスタ
#define AB0_WAIT_STATUS     (0x2FFF0090)    ///<  R      -       ウエイト端子のステータスレジスタ
#define AB0_CS0BASEADD      (0x2FFF0100)    ///< R/W 0000_0000H  CS0 用ベースアドレスレジスタ
#define AB0_CS0BITCOMP      (0x2FFF0104)    ///< R/W F000_0000H  CS0 用ビットコンペア用レジスタ
#define AB0_CS1BASEADD      (0x2FFF0110)    ///< R/W 3FFF_0000H  CS1 用ベースアドレス
#define AB0_CS1BITCOMP      (0x2FFF0114)    ///< R/W FFFF_0000H  CS1 用ビットコンペア用レジスタ
#define AB0_CS2BASEADD      (0x2FFF0120)    ///< R/W 3FFF_0000H  CS2 用ベースアドレス
#define AB0_CS2BITCOMP      (0x2FFF0124)    ///< R/W FFFF_0000H  CS2 用ビットコンペア用レジスタ
#define AB0_CS3BASEADD      (0x2FFF0130)    ///< R/W 3FFF_0000H  CS3 用ベースアドレス
#define AB0_CS3BITCOMP      (0x2FFF0134)    ///< R/W FFFF_0000H  CS3 用ビットコンペア用レジスタ

/// Parameter Register

#define     AB0_CS0WAITCTRL     (0x2FFF0200)    ///< R/W 000F_1F0FH  CS0 用ウエイト制御レジスタ
#define     AB0_CS0WAITCTRL_W   (0x2FFF0204)    ///< R/W 000F_1F0FH  CS0 用ライトウエイト制御レジスタ
#define     AB0_CS0READCTRL     (0x2FFF0208)    ///< R/W 0000_0000H  CS0 用リードモードレジスタ
#define     AB0_CS0WAIT_MASK    (0x2FFF020C)    ///< R/W 0000_0000H  CS0 用ウエイトマスクレジスタ
#define     AB0_CS0CONTROL      (0x2FFF0210)    ///< R/W 0001_0100H  CS0 用制御レジスタ
#define     AB0_CS0FLASHRCR     (0x2FFF0214)    ///< R/W 0000_D503H  CS0 用リードコンフィギュレーションレジスタ
#define     AB0_CS0FLASHWCR     (0x2FFF0218)    ///< R/W 0000_0001H  CS0 用ライトコンフィギュレーションレジスタ
#define     AB0_CS1WAITCTRL     (0x2FFF0220)    ///< R/W 000F_1F0FH  CS1 用ウエイト制御レジスタ
#define     AB0_CS1WAITCTRL_W   (0x2FFF0224)    ///< R/W 000F_1F0FH  CS1 用ライトウエイト制御レジスタ
#define     AB0_CS1READCTRL     (0x2FFF0228)    ///< R/W 0000_0000H  CS1 用リードモードレジスタ
#define     AB0_CS1WAIT_MASK    (0x2FFF022C)    ///< R/W 0000_0000H  CS1 用ウエイトマスクレジスタ
#define     AB0_CS1CONTROL      (0x2FFF0230)    ///< R/W 0001_0100H  CS1 用制御レジスタ
#define AB0_CS1FLASHRCR     (0x2FFF0234)    ///< R/W 0000_D503H  CS1 用リードコンフィギュレーションレジスタ
#define AB0_CS1FLASHWCR     (0x2FFF0238)    ///< R/W 0000_0001H  CS1 用ライトコンフィギュレーションレジスタ
#define AB0_CS2WAITCTRL     (0x2FFF0240)    ///< R/W 000F_1F0FH  CS2 用ウエイト制御レジスタ
#define AB0_CS2WAITCTRL_W   (0x2FFF0244)    ///< R/W 000F_1F0FH  CS2 用ライトウエイト制御レジスタ
#define AB0_CS2READCTRL     (0x2FFF0248)    ///< R/W 0000_0000H  CS2 用リードモードレジスタ
#define AB0_CS2WAIT_MASK    (0x2FFF024C)    ///< R/W 0000_0000H  CS2 用ウエイトマスクレジスタ
#define AB0_CS2CONTROL      (0x2FFF0250)    ///< R/W 0001_0100H  CS2 用制御レジスタ
#define AB0_CS2FLASHRCR     (0x2FFF0254)    ///< R/W 0000_D503H  CS2 用リードコンフィギュレーションレジスタ
#define AB0_CS2FLASHWCR     (0x2FFF0258)    ///< R/W 0000_0001H  CS2 用ライトコンフィギュレーションレジスタ
#define AB0_CS3WAITCTRL     (0x2FFF0260)    ///< R/W 000F_1F0FH  CS3 用ウエイト制御レジスタ
#define AB0_CS3WAITCTRL_W   (0x2FFF0264)    ///< R/W 000F_1F0FH  CS3 用ライトウエイト制御レジスタ
#define AB0_CS3READCTRL     (0x2FFF0268)    ///< R/W 0000_0000H  CS3 用リードモードレジスタ
#define AB0_CS3WAIT_MASK    (0x2FFF026C)    ///< R/W 0000_0000H  CS3 用ウエイトマスクレジスタ
#define AB0_CS3CONTROL      (0x2FFF0270)    ///< R/W 0001_0100H  CS3 用制御用レジスタ
#define AB0_CS3FLASHRCR     (0x2FFF0274)    ///< R/W 0000_D503H  CS3 用リードコンフィギュレーションレジスタ
#define AB0_CS3FLASHWCR     (0x2FFF0278)    ///< R/W 0000_0001H  CS3 用ライトコンフィギュレーションレジスタ

/// Parameter hold Register

#define AB0_CS0WAITCTRL2    (0x2FFF0300)    ///<  R  000F_1F0FH  CS0 用ウエイト制御レジスタ
#define AB0_CS0WAITCTRL_W2  (0x2FFF0304)    ///<  R  000F_1F0FH  CS0 用ライトウエイト制御レジスタ
#define AB0_CS0READCTRL2    (0x2FFF0308)    ///<  R  0000_0000H  CS0 用リードモードレジスタ
#define AB0_CS0WAIT_MASK2   (0x2FFF030C)    ///<  R  0000_0000H  CS0 用ウエイトマスクレジスタ
#define AB0_CS0CONTROL2     (0x2FFF0310)    ///<  R  0001_0100H  CS0 用制御レジスタ
#define AB0_CS0FLASHRCR2    (0x2FFF0314)    ///<  R  0000_D503H  CS0 用リードコンフィギュレーションレジスタ
#define AB0_CS0FLASHWCR2    (0x2FFF0318)    ///<  R  0000_0001H  CS0 用ライトコンフィギュレーションレジスタ
#define AB0_CS1WAITCTRL2    (0x2FFF0320)    ///<  R  000F_1F0FH  CS1 用ウエイト制御レジスタ
#define AB0_CS1WAITCTRL_W2  (0x2FFF0324)    ///<  R  000F_1F0FH  CS1 用ライトウエイト制御レジスタ
#define AB0_CS1READCTRL2    (0x2FFF0328)    ///<  R  0000_0000H  CS1 用リードモードレジスタ
#define AB0_CS1WAIT_MASK2   (0x2FFF032C)    ///<  R  0000_0000H  CS1 用ウエイトマスクレジスタ
#define AB0_CS1CONTROL2     (0x2FFF0330)    ///<  R  0001_0100H  CS1 用制御レジスタ
#define AB0_CS1FLASHRCR2    (0x2FFF0334)    ///<  R  0000_D503H  CS1 用リードコンフィギュレーションレジスタ
#define AB0_CS1FLASHWCR2    (0x2FFF0338)    ///<  R  0000_0001H  CS1 用ライトコンフィギュレーションレジスタ
#define AB0_CS2WAITCTRL2    (0x2FFF0340)    ///<  R  000F_1F0FH  CS2 用ウエイト制御レジスタ
#define AB0_CS2WAITCTRL_W2  (0x2FFF0344)    ///<  R  000F_1F0FH  CS2 用ライト ウエイト制御レジスタ
#define AB0_CS2READCTRL2    (0x2FFF0348)    ///<  R  0000_0000H  CS2 用リードモードレジスタ
#define AB0_CS2WAIT_MASK2   (0x2FFF034C)    ///<  R  0000_0000H  CS2 用ウエイトマスクレジスタ
#define AB0_CS2CONTROL2     (0x2FFF0350)    ///<  R  0001_0100H  CS2 用制御レジスタ
#define AB0_CS2FLASHRCR2    (0x2FFF0354)    ///<  R  0000_D503H  CS2 用リードコンフィギュレーションレジスタ
#define AB0_CS2FLASHWCR2    (0x2FFF0358)    ///<  R  0000_0001H  CS2 用ライトコンフィギュレーションレジスタ
#define AB0_CS3WAITCTRL2    (0x2FFF0360)    ///<  R  000F_1F0FH  CS3 用ウエイト制御レジスタ
#define AB0_CS3WAITCTRL_W2  (0x2FFF0364)    ///<  R  000F_1F0FH  CS3 用ライトウエイト制御レジスタ
#define AB0_CS3READCTRL2    (0x2FFF0368)    ///<  R  0000_0000H  CS3 用リードモードレジスタ
#define AB0_CS3WAIT_MASK2   (0x2FFF036C)    ///<  R  0000_0000H  CS3 用ウエイトマスクレジスタ
#define AB0_CS3CONTROL2     (0x2FFF0370)    ///<  R  0001_0100H  CS3 用制御用レジスタ
#define AB0_CS3FLASHRCR2    (0x2FFF0374)    ///<  R  0000_D503H  CS3 用リードコンフィギュレーションレジスタ
#define AB0_CS3FLASHWCR2    (0x2FFF0378)    ///<  R  0000_0001H  CS3 用ライトコンフィギュレーションレジスタ

#endif // __AB0_H_
