﻿/*
 *  arch/arm/mach-emxx/emif/emif_ctrl.h
 *  EMIF_CTRL control datalink and some interfaces for syscall
 *
 *  Copyright 2011 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */

#ifndef __EMIFCTRL_H_
#define __EMIFCTRL_H_

#ifdef __KERNEL__
#include<linux/types.h>
#else
#include<stdint.h>
#include<sys/ioctl.h>
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#define EMIF_CTRL_NAME      "emif_nod"
#define EMIFLIB_SEND_DATA_SIZE      4   /* 4Byte = record the send data size */

#define EMIF_CTRL_PACKET_DATA_SIZE  508   /* 380Byte = send and receive data size in the packet */
#define EMIF_CTRL_CIRC_BUFF_SIZE     6144  /* 3MByte = 6144*512Byte, reserve one packet for circle buffer handler */
#define EMIF_CTRL_MMAP_SBUFF_SIZE     (3*1024*1024 + 4*1024)    /* Sender buffer (3MB) + Safe Reserve (2KB) */
#define EMIF_CTRL_MMAP_RBUFF_SIZE     (3*1024*1024 + 4*1024)    /* Sender buffer (3MB) + Safe Reserve (2KB) */

#define EMIF_CTRL_SEND_BUFF_MGR_OFFSET   (0)   /* send buffer manager offset 0KB */
#define EMIF_CTRL_SEND_BUFF_OFFSET   (3*1024)  /* send buffer base address offset 1KB */
#define EMIF_CTRL_SEND_BUFF_SIZE     (3*1024*1024+1*1024)  /* Range of send buffer 3MB+1KB */
#define EMIF_CTRL_RECEIVE_BUFF_MGR_OFFSET   (0)   /* send buffer manager offset 0KB */
#define EMIF_CTRL_RECEIVE_BUFF_OFFSET  (3*1024)  /* receive buffer base address offset 1KB */
#define EMIF_CTRL_RECEIVE_BUFF_SIZE  (3*1024*1024+1*1024)  /* Range of send buffer 3MB+1KB */



/*
 * @brief Emif access spi register
 */
typedef struct EMIF_ACCESS_SPI_t {
    unsigned long       spi_addr;
    unsigned long       spi_value;
} EMIF_ACCESS_SPI;

/*
 * @brief Emif msg data struct
 */
typedef struct EMIF_MSG_DATA_t {
    unsigned long       data_addr;
    unsigned long       packet_count;
} EMIF_MSG_DATA;


/*
 * @brief Emif packet struct
 */
typedef struct EMIF_PACKET_t {
    unsigned short  seqNo;
    unsigned short  reverse;
    unsigned char   Data[EMIF_CTRL_PACKET_DATA_SIZE];
} EMIF_PACKET;

/*
 * @brief Emif buffer circ struct
 */
typedef struct EMIF_CIRC_BUFF_t {
    EMIF_PACKET* buf;
    int buff_dummy[7];
    int write;
    int write_dummy[7];
    int read;
    int read_dummy[7];
} EMIF_CIRC_BUFF;

#define EMIF_CTRL_IO_MAGIC                          'C'

#define EMIF_CTRL_SEND_DATA         _IOWR ( EMIF_CTRL_IO_MAGIC,  0, unsigned long )
#define EMIF_CTRL_RECEIVE_DATA          _IOWR ( EMIF_CTRL_IO_MAGIC,  1, EMIF_MSG_DATA )
#define EMIF_CTRL_GET_SBUFF_PHY_ADDR   _IOWR ( EMIF_CTRL_IO_MAGIC,  2, unsigned long )
#define EMIF_CTRL_GET_BUFF_SIZE            _IOWR ( EMIF_CTRL_IO_MAGIC,  3, unsigned long )
#define EMIF_CTRL_GET_RBUFF_PHY_ADDR   _IOWR ( EMIF_CTRL_IO_MAGIC,  4, unsigned long )
#define EMIF_CTRL_RECEIVER_CANCEL       _IOWR ( EMIF_CTRL_IO_MAGIC,  5, unsigned long )
#define EMIF_CTRL_GET_PKTS_CNT             _IOWR ( EMIF_CTRL_IO_MAGIC,  6, unsigned long )
#define EMIF_CTRL_DRV_INIT      _IOWR ( EMIF_CTRL_IO_MAGIC,  7, unsigned long )
#define EMIF_CTRL_SPI_WRITE      _IOWR ( EMIF_CTRL_IO_MAGIC,  8, unsigned long )
#define EMIF_CTRL_SPI_READ      _IOWR ( EMIF_CTRL_IO_MAGIC,  9, unsigned long )
#define EMIF_CTRL_MAX_NR        _IOWR ( EMIF_CTRL_IO_MAGIC,  10, unsigned long )

/* Return a mod b */
#define EMIF_MOD(a, b)   (((a)+(b))%(b))

/* Return count in buffer.  */
#define EMIF_CIRC_CNT(write,read,size) (EMIF_MOD(((write) - (read)), ((size)-1)))

/* Return space available, 0..size-1.  We always leave one free cell
   as a completely full buffer has write == read, which is the same as
   empty.  */
#define EMIF_CIRC_SPACE(write,read,size) EMIF_CIRC_CNT((read),((write)+1),(size))

/* Return count up to the end of the buffer.  Carefully avoid
   accessing head and tail more than once, so they can change
   underneath us without returning inconsistent results.  */
#define EMIF_CIRC_CNT_TO_END(write,read,size) \
    ({int end = (size) - (read); \
        int n = EMIF_MOD(((write) + end), ((size)-1)); \
        n < end ? n : end;})

/* Return space available up to the end of the buffer.  */
#define EMIF_CIRC_SPACE_TO_END(write,read,size) \
    ({int end = (size) - 1 - (write); \
        int n = EMIF_MOD((end + (read)), ((size)-1)); \
        n <= end ? n : end+1;})


#endif  /* __EMIFCTRL_H_ */

