﻿/*
 *  arch/arm/mach-emxx/emif/emif_datalink.h
 *  emif datalink interface
 *
 *  Copyright 2011 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */

#ifndef __EMIF_DATALINK_H_
#define __EMIF_DATALINK_H_

/* request mode */
#define EMIF_WRITE_REQUEST       1
#define EMIF_READ_REQUEST       2
#define EMIF_BOTH_READ_WRITE_REQUEST  3

/* status for dma or gpio interrupt */
#define NO_INTERRUPT      0
#define DMA_INTERRUPT     1
#define GPIO_INTERRUPT    2
#define IOCTL_SEND	  3

/*status foe request*/
#define NO_REQUEST  0
#define DMA_REQUEST     1

/* HSS releated */
#ifdef CONFIG_SNSC_HSS
#define EMIF_DL_E_HSS_NODE_NAME     "emif_dl_e_hss_node_name"
#define EMIF_DL_E_HSS_NODE_PARENT   NULL    /* parent is dma, registered in LDM */
#endif  /* #ifdef CONFIG_SNSC_HSS */

/*
 * @brief Emif datalink status
 */
typedef enum {
    EMIF_DL_STATUS_NONE = 0,
    EMIF_DL_STATUS_SET_WRITE,
    EMIF_DL_STATUS_SET_READ,
    EMIF_DL_STATUS_WRITE,
    EMIF_DL_STATUS_READ,
    EMIF_DL_STATUS_IDLE,
    EMIF_DL_STATUS_MAX
} EMIF_DL_DMA_STATUS;


/**
 * @brief get current buffer read or write request
 * @param[IN] none
 * @return request mode
 * @pre none
 * @post none
 * @attention  none
 */
short int emif_dl_get_request_mode(void);

/**
 * @brief set call back func pointer
 * @param[OUT] None
 * @param[IN]  <<pfunc_send_packet>> the func point of send packet
 * @param[IN]  <<pfunc_recv_packet>> the func point of send packet
 * @return status of the emif_dl_init
 * @pre this module has been installed
 * @post None
 * @attention pFunc pointer can not be NULL
 */
int emif_dl_init(void* pfunc_dma_complete_callback, void* pfunc_gpio_callback,void* pfunc_ioctl_send);

/**
 * @brief set DMA pointers and trans one packet
 * @param[OUT] None
 * @param[IN] DMA_send_p DMA transfer send head pointer
 * @return status of this process
 * @pre
 * @post None
 * @attention slave want transfer packet as sponsor whatever master status now
 */
int emif_dl_send_packet(unsigned long dma_send_p);

/**
 * @brief set DMA pointers and trans one packet
 * @param[OUT] None
 * @param[IN] DMA_recv_p DMA transfer receive head pointer
 * @return status of this process
 * @pre
 * @post None
 * @attention slave want transfer packet as sponsor whatever master status now
 */
int emif_dl_recv_packet(unsigned long dma_recv_p);

/**
 * @brief enable GPIO interrupt
 * @param[OUT] None
 * @param[IN] None
 * @return normal
 * @pre
 * @post None
 * @attention None
 */
void emif_dl_enable_gpio(void);

/**
 * @brief disable GPIO interrupt
 * @param[OUT] None
 * @param[IN] None
 * @return normal
 * @pre
 * @post None
 * @attention None
 */
void emif_dl_disable_gpio(void);

/**
 * @brief get the interrupt type
 * @param[OUT] interrupt_type
 * @param[IN] None
 * @return normal
 * @pre
 * @post None
 * @attention None
 */
int emif_dl_get_communication_status(void);


/**
 * @brief disable GPIO interrupt
 * @param[OUT] None
 * @param[IN] None
 * @return normal
 * @pre
 * @post None
 * @attention None
 */
int emif_dl_start_workqueue(void);

/**
 * @brief cs2 async write
 * @param[in] <<async_addr>>   write addr
 * @param[in] <<async_value>>  write value
 * @return   sucess or failed
 * @pre
 * @post None
 * @attention None
 */
int emif_dl_async_write(unsigned long async_addr, unsigned long async_value);


/**
 * @brief cs2 async read
 * @param[in] <<async_addr>>   write addr
 * @return   the value of the input address
 * @pre
 * @post None
 * @attention None
 */
unsigned long emif_dl_async_read(unsigned long async_addr);

/**
 * @brief  set ab0 async mode
 * @param[in] none
 * @return set async sucess or failed
 * @pre ab0 has been inited
 * @post    none
 * @attention
 */
int emif_dl_ab0_set_async_mode(void);

#endif
