/*
 *  Copyright 2011 Sony Corporation.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/usb.h>
#include <linux/platform_device.h>

#include <mach/usbhc.h>

#if defined(CONFIG_USB_EHCI_HCD_EMXX) || defined(CONFIG_USB_EHCI_HCD_EMXX_MODULE)
#define __CONFIG_EVSY_EHCI
#endif

#if defined(CONFIG_USB_OHCI_HCD_EMXX) || defined(CONFIG_USB_OHCI_HCD_EMXX_MODULE)
#define __CONFIG_EVSY_OHCI
#endif

static void evsy_usbhc_nop_release(struct device *dev)
{
	/* nothing to do */
}

#if defined(__CONFIG_EVSY_EHCI) || defined(__CONFIG_EVSY_OHCI)
struct emxx_usbhc_platform_data evsy_hcd_config = {
	.usbhc_pre_clr_dpd		= NULL,
	.usbhc_post_set_dpd		= NULL,
	.usbhc_gpio_init		= NULL,
	.usbhc_gpio_exit		= NULL,
	.usbhc_probe			= NULL,
	.usbhc_remove			= NULL,
	.usbhc_vbus_on			= NULL,
	.usbhc_vbus_off			= NULL,
	.usbhc_over_current_check	= NULL,
	.usbhc_enable_oci		= NULL,
	.usbhc_disable_oci		= NULL,
};
#endif /* #CONFIG_USB_EHCI_HCD_EMXX || CONFIG_USB_OHCI_HCD_EMXX */

#ifdef __CONFIG_EVSY_EHCI
static struct platform_device evsy_ehci_device = {
	.name = "emxx-ehci-driver",
	.id = -1,
	.dev = {
		.dma_mask = (void *)0xffffffff,
		.coherent_dma_mask = 0xffffffff,
		.platform_data = &evsy_hcd_config,
		.release = evsy_usbhc_nop_release,
	},
};
#endif

#ifdef __CONFIG_EVSY_OHCI
static struct platform_device evsy_ohci_device = {
	.name = "emxx-ohci-driver",
	.id = -1,
	.dev = {
		.dma_mask = (void *)0xffffffff,
		.coherent_dma_mask = 0xffffffff,
		.platform_data = &evsy_hcd_config,
		.release = evsy_usbhc_nop_release,
	},
};
#endif

static struct platform_device *evsy_usbhc_devs[] = {
#ifdef __CONFIG_EVSY_EHCI
	&evsy_ehci_device,
#endif
#ifdef __CONFIG_EVSY_OHCI
	&evsy_ohci_device,
#endif
};

static int __init evsy_usbhc_init(void)
{
	return platform_add_devices(evsy_usbhc_devs,
				    ARRAY_SIZE(evsy_usbhc_devs));
}

static void __exit evsy_usbhc_exit(void)
{
	int i;

	for (i = 0; i < ARRAY_SIZE(evsy_usbhc_devs); i++ )
		platform_device_unregister(evsy_usbhc_devs[i]);
}

arch_initcall(evsy_usbhc_init);
module_exit(evsy_usbhc_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Sony Corporation");
