/*
 *  Copyright 2010 Sony Corporation.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <linux/platform_device.h>
#include <linux/gpio.h>
#include <linux/irq.h>
#include <linux/mmc/mmc.h>
#include <linux/mmc/host.h>
#include <linux/mmc/sd.h>
#include <linux/mmc/core.h>
#include <linux/mmc/card.h>

#include <mach/hardware.h>
#include <mach/sdio.h>

#include "../../../drivers/mmc/host/emxx_sdio.h"

/* SDIO1: Micro SD */
static int evsy_sdio_microsd_is_media_present(struct mmc_host *mmc)
{
	struct emxx_mmc_host *host;

	host = mmc_priv(mmc);

	if (gpio_get_value(host->detect_gpio))
		return 0; /* empty */
	else
		return 1; /* Card detected */
}

static irqreturn_t evsy_sdio_microsd_detect_irq(int irq, void *dev_id)
{
	struct emxx_mmc_host *host;
	struct mmc_host *mmc;

	host = (struct emxx_mmc_host *)dev_id;
	mmc = host->mmc;

	if (evsy_sdio_microsd_is_media_present(mmc))
		host->connect = 1;
	else
		host->connect = 0;

	mmc_detect_change(host->mmc, msecs_to_jiffies(100));

	return IRQ_HANDLED;
}

int evsy_sdio_microsd_probe(struct platform_device *pdev, struct mmc_host *mmc)
{

	struct emxx_mmc_host *host;
	int ret = 0;

	host = mmc_priv(mmc);

	host->detect_gpio = EVSY_GPIO_SD1_CD;

	if (evsy_sdio_microsd_is_media_present(mmc))
		host->connect = 1;
	else
		host->connect = 0;

// PFXPT-2832 暫定的に割り込み関数登録を無効化
// PFXPT-3341 本コードはBS開発部から購入した時に入っていたコードであり、そもそも不要なコードなので影響はなし
/*
	host->detect_irq = EVSY_INT_SD1_CD;
	set_irq_type(host->detect_irq, IRQ_TYPE_EDGE_BOTH);
	ret = request_irq(host->detect_irq, evsy_sdio_microsd_detect_irq,
			  IRQF_DISABLED, pdev->name, host);

	if (ret) {
		pr_err("%s: failed to register card detect irq(%d)\n",
		       __func__, host->detect_irq);
		host->connect = 0;
		host->detect_irq = 0;
	}
*/
	return ret;
}

void evsy_sdio_microsd_remove(struct platform_device *pdev)
{
	struct emxx_mmc_host *host;

	host = platform_get_drvdata(pdev);

	platform_set_drvdata(pdev, NULL);

	if (host)
		free_irq(host->detect_irq, host);
	else
		dev_err(&pdev->dev, "%s: emxx_mmc_host already freed\n", __func__);

	return;
}

static void evsy_sdio_nop_release(struct device *dev)
{
	/* nothing to be released */
}

#ifdef CONFIG_PM
int evsy_sdio_microsd_suspend(struct platform_device *pdev, pm_message_t state)
{
	return 0;
}

int evsy_sdio_microsd_resume(struct platform_device *pdev)
{
	return 0;
}
#endif

/* SDIO1: microSD */
static struct emxx_sdio_platform_data evsy_sdio_microsd_platform_data = {
	.sdio_probe = evsy_sdio_microsd_probe,
	.sdio_remove = evsy_sdio_microsd_remove,
#ifdef CONFIG_PM
	.sdio_suspend = evsy_sdio_microsd_suspend,
	.sdio_resume = evsy_sdio_microsd_resume,
#endif
};


/* micro SD */
static struct platform_device evsy_sdio1_device = {
	.name = "emxx_sdio1",
	.id = 1,
	.dev = {
		.platform_data = &evsy_sdio_microsd_platform_data,
		.release = evsy_sdio_nop_release,
	},
};

static int __init evsy_sdio_init(void)
{
	return platform_device_register(&evsy_sdio1_device);
}

static void __exit evsy_sdio_exit(void)
{
	platform_device_unregister(&evsy_sdio1_device);
}

arch_initcall(evsy_sdio_init);
module_exit(evsy_sdio_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Sony Corporation");


