/*
 * arch/arm/mach-emxx/include/mach/debug-macro.S
 *
 * Debugging macro include header
 *
 *  Copyright (C) NEC Electronics Corporation 2010
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

	.macro	addruart,rx
	mov	\rx, #0xe1000000	@ physical & virtual base
	orr	\rx, \rx, #0x00020000	@ UART0
	.endm

#define UART_SHIFT	2
#include <linux/serial_reg.h>

		.macro	senduart,rd,rx
		strb	\rd, [\rx, #UART_TX << UART_SHIFT]
		.endm

		.macro	busyuart,rd,rx
1002:		ldr	\rd, [\rx, #UART_LSR << UART_SHIFT]
		and	\rd, \rd, #UART_LSR_TEMT | UART_LSR_THRE
		teq	\rd, #UART_LSR_TEMT | UART_LSR_THRE
		bne	1002b
		.endm

		.macro	waituart,rd,rx
		.endm
