/*
 *  File Name       : arch/arm/mach-emxx/include/mach/emxx_mem.h
 *  Function        : memory map difinition
 *  Release Version : Ver 1.11
 *  Release Date    : 2010/06/17
 *
 *  Copyright (C) Renesus Electronics Corporation 2010
 *
 *
 *  This program is free software;you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by Free
 *  Softwere Foundation; either version 2 of License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warrnty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; If not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __EMEV_MEM_H
#define __EMEV_MEM_H

/******* SDRAM ********/

#define EMXX_DUMMY_BASE		EMXX_SDRAM_BASE

/* SubLCD(12MB) */
#define V4L2_ROT_BUFFER_ADDR		0x4BE00000	/* 4BE0:0000 - 4C9F:FFFF */
#define V4L2_ROT_BUFFER_SIZE		0x00C00000

/* reserved(24MB) */
#define EMXX_RESERVED_ADDR		0x4CA00000	/* 4CA0:0000 - 4E1F:FFFF */
#define EMXX_RESERVED_SIZE		0x01800000

/* MindLog(3MB) */
#define EMXX_MINDLOG_ADDR		0x4E200000	/* 4E20:0000 - 4E4F:FFFF */
#define EMXX_MINDLOG_SIZE		0x00300000

/* kolg(1MB) */
#define EMXX_KLOG_ADDR		0x4E500000	/* 4E50:0000 - 4E5F:FFFF */
#define EMXX_KLOG_SIZE		0x00100000

/* Log Buffer(10MB) */
#define LOG_BUFFER_ADDR		0x4E600000	/* 4E60:0000 - 4EFF:FFFF */
#define LOG_BUFFER_SIZE		0x00A00000

/* Camera frame buffer(2MB) */
#define CAMERA_FRAME_BASE	EMXX_DUMMY_BASE	/* empty */
#define CAMERA_FRAME_SIZE	0x00200000

/* FB frame buffer(25MB) */
#define FB_FRAME_BUFFER_ADDR	0x4E600000	/* 4E60:0000 - 4FEF:FFFF */
#define FB_FRAME_BUFFER_SIZE	0x01900000

/* Direct Path frame buffer(6MB) */
#define LCD_FRAME_BUFFER_ADDR	EMXX_DUMMY_BASE	/* empty */
#define LCD_FRAME_BUFFER_SIZE	0x00600000

/* NTSC frame buffer(2MB) */
#define NTSC_FRAME_BUFFER_ADDR	EMXX_DUMMY_BASE	/* empty */
#define NTSC_FRAME_BUFFER_SIZE	0x00200000

/* InterDSP DSP-FW downlaod range */
#define INTERDSP_DL_TOP_ADDR	EMXX_DUMMY_BASE	/* empty */
#define INTERDSP_DL_BOTTOM_ADDR	EMXX_DUMMY_BASE

/* CPU<->DSP command buffer(128K) */
#define INTERDSP_SHARED_ADDR	EMXX_DUMMY_BASE	/* empty */
#define INTERDSP_SHARED_SIZE	0x00020000

#define SHARED_MEM_ADDRESS 	INTERDSP_SHARED_ADDR
#define SHARED_MEM_SIZE 	INTERDSP_SHARED_SIZE
#define DOWNLOAD_RANGE_START 	INTERDSP_DL_TOP_ADDR
#define DOWNLOAD_RANGE_END 	INTERDSP_DL_BOTTOM_ADDR

#endif /* __EMEV_MEM_H */
