﻿/*
 *  Copyright 2011 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __ARCH_EMXX_EVSY_BOARD_H
#define __ARCH_EMXX_EVSY_BOARD_H

/*
 * define _EVSY_SD_GPIO_TEST to assign DIPSW #4 to the primary SD
 * card insertion detection
 * #define _EVSY_SD_GPIO_TEST
 */
#undef _EVSY_SD_GPIO_TEST

/* GPIO number */
#define EVSY_GPIO_LAN_RESET_L		GPIO_P0
#define EVSY_GPIO_LAN_INT		GPIO_P1
/* #define EVSY_GPIO_USB_GPIO		GPIO_P4 */
#define EVSY_GPIO_SD1_CD		GPIO_P4 /* Not used */
#define EVSY_GPIO_MS_ACS_LED		GPIO_P5
#define EVSY_GPIO_MS_INS_LED		GPIO_P6
#define EVSY_GPIO_SDWPZ			GPIO_P8
#define EVSY_GPIO_MS_INS		GPIO_P9

#define EVSY_GPIO_AT_COM_IRQ		GPIO_P11
#define EVSY_GPIO_FPGA_RECONFIG		GPIO_P12
#define EVSY_GPIO_FPGA_CONF_DONE	GPIO_P13
#define EVSY_GPIO_SY_PLD_RESET		GPIO_P14
#define EVSY_GPIO_EXT_IO_IRQ_L		GPIO_P15
#define EVSY_GPIO_MC_POWER_OFF_L	GPIO_P16
#define EVSY_GPIO_CAM_SU_IRQ_L		GPIO_P17
#define EVSY_GPIO_700P_INTB_L		GPIO_P19

#define EVSY_GPIO_700P_INTA_L		GPIO_P24
#define EVSY_GPIO_RTC_INTA_L		GPIO_P25
#define EVSY_GPIO_RTC_INTB_L		GPIO_P26

#define EVSY_GPIO_BOOTMODE_0		GPIO_P28
#define EVSY_GPIO_BOOTMODE_1		GPIO_P29
#define EVSY_GPIO_BOOTMODE_2		GPIO_P30
#define EVSY_GPIO_BOOTMODE_3		GPIO_P31

#ifdef _EVSY_SD_GPIO_TEST
#define EVSY_GPIO_SD_INS		GPIO_P31
#else
#define EVSY_GPIO_SD_INS		GPIO_P49
#endif

#define EVSY_GPIO_CN_IRQ		GPIO_P97
#define EVSY_GPIO_CN_GPIO		GPIO_P98

#define EVSY_GPIO_AT_SY_IT_INT		GPIO_P103
#define EVSY_GPIO_SY_AT_IT_INT		GPIO_P104

#define EVSY_GPIO_SD1_SDIO_CD		GPIO_P122
#define EVSY_GPIO_SD1_SDIO_WP		GPIO_P123
#define EVSY_GPIO_FPGA_IO_B		GPIO_P124
#define EVSY_GPIO_FPGA_IO_A		GPIO_P125

#define EVSY_GPIO_SW1			GPIO_P127
#define EVSY_GPIO_SW2			GPIO_P128
#define EVSY_GPIO_SW3			GPIO_P129
#define EVSY_GPIO_FPGA_UPDATE_SEL	GPIO_P130
#define EVSY_GPIO_VBUS			GPIO_P153

/* GPIO interrupt */
#define EVSY_INT_LAN_INT		INT_GPIO_1
#define EVSY_INT_SD1_CD			INT_GPIO_4
#define EVSY_INT_SDPWZ			INT_GPIO_8
#define EVSY_INT_MS_INS			INT_GPIO_9

#define EVSY_INT_AT_COM_IRQ		INT_GPIO_11
#define EVSY_INT_FPGA_CONF_DONE		INT_GPIO_13
#define EVSY_INT_EXT_IO_IRQ_L		INT_GPIO_15
#define EVSY_INT_CAM_SU_IRQ_L		INT_GPIO_17
#define EVSY_INT_700P_INTB_L		INT_GPIO_19

#define EVSY_INT_700P_INTA_L		INT_GPIO_24
#define EVSY_INT_RTC_INTA_L		INT_GPIO_25
#define EVSY_INT_RTC_INTB_L		INT_GPIO_26

#define EVSY_INT_BOOTMODE_0		INT_GPIO_28
#define EVSY_INT_BOOTMODE_1		INT_GPIO_29
#define EVSY_INT_BOOTMODE_2		INT_GPIO_30
#define EVSY_INT_BOOTMODE_3		INT_GPIO_31

#ifdef _EVSY_SD_GPIO_TEST
#define EVSY_INT_SD_INS			INT_GPIO_31
#else
#define EVSY_INT_SD_INS			INT_GPIO_49
#endif

#define EVSY_INT_CN_IRQ			INT_GPIO_97
#define EVSY_INT_CN_GPIO		INT_GPIO_98

#define EVSY_INT_AT_SY_IT_INT		INT_GPIO_103
#define EVSY_INT_SY_AT_IT_INT		INT_GPIO_104

#define EVSY_INT_SD1_SDIO_CD		INT_GPIO_122
#define EVSY_INT_SD1_SDIO_WP		INT_GPIO_123
#define EVSY_INT_FPGA_IO_B		INT_GPIO_124
#define EVSY_INT_FPGA_IO_A		INT_GPIO_125

#define EVSY_INT_SW1			INT_GPIO_127
#define EVSY_INT_SW2			INT_GPIO_128
#define EVSY_INT_SW3			INT_GPIO_129
#define EVSY_INT_FPGA_UPDATE_SEL	INT_GPIO_130

#define EVSY_INT_VBUS			INT_GPIO_153

#define INT_USB_OCI
/* AB0 */
/* CS0: FRAM: 256kbit * 2 = 64MB */
#define EVSY_FRAM_OFFSET	0x08000000
#define EVSY_FRAM_BASE		(EMXX_BANK1A_BASE + EVSY_FRAM_OFFSET)
#define EVSY_FRAM_SIZE		SZ_64M
/* CS1: Ether */
#define EVSY_ETHER_OFFSET	0x00000000
#define EVSY_ETHER_SIZE		SZ_256
#define EVSY_ETHER_BASE		(EMXX_BANK1A_BASE + EVSY_ETHER_OFFSET)
/* CS2: Unused */
#define EVSY_AB0_CS2_OFFSET	0x04000000
#define EVSY_AB0_CS2_SIZE	SZ_64M
#define EVSY_AB0_CS2_BASE	(EMXX_BANK1A_BASE + EVSY_AB0_CS2_OFFSET)
/* CS3: PLD */
#define EVSY_PLD_OFFSET		0x00000000
#define EVSY_PLD_SIZE		SZ_256M
#define EVSY_PLD_BASE		(EMXX_BANK0_BASE + EVSY_PLD_OFFSET)

#define EVSY_I2C_SLAVE_PCA9554_NAME "pca9554"
#define EVSY_I2C_SLAVE_PCA9554_ADDR 0x22

#endif /* __ARCH_EMXX_EVSY_BOARD_H */
