/*
 *  File Name       : arch/arm/mach-emxx/include/mach/memory.h
 *  Function        : memory
 *  Release Version : Ver 1.00
 *  Release Date    : 2010/02/05
 *
 *  Copyright (C) NEC Electronics Corporation 2010
 *
 *  This program is free software;you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by Free
 *  Softwere Foundation; either version 2 of License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warrnty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; If not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __ASM_ARCH_MEMORY_H
#define __ASM_ARCH_MEMORY_H

/*
 * Physical DRAM offset.
 */
#define PHYS_OFFSET	UL(0x40000000)

#ifdef CONFIG_SPARSEMEM
#define SECTION_SIZE_BITS	CONFIG_SNSC_SPARSE_SECTION_SHIFT
#define MAX_PHYSADDR_BITS	32
#define MAX_PHYSMEM_BITS	32
#endif

#ifdef CONFIG_MEMORY_HOTPLUG
/*
 * EMEV is able to install 512MB memory. But current memory map cannot handle it.
 * Please see "arch/arm/mach-emxx/include/mach/vmalloc.h"
 */
#define MAX_HOTPLUG_MEM		(256 * 1024 * 1024)
#endif

#endif	/* __ASM_ARCH_MEMORY_H */
