/*
 *  File Name       : arch/arm/mach-emxx/include/mach/pm.h
 *  Function	    : Power Management
 *  Release Version : Ver 1.00
 *  Release Date    : 2010/02/05
 *
 *  Copyright (C) NEC Electronics Corporation 2010
 *
 *
 *  This program is free software;you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by Free
 *  Softwere Foundation; either version 2 of License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warrnty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; If not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifndef __ASM_ARCH_EMXX_PM_H
#define __ASM_ARCH_EMXX_PM_H

#include <linux/interrupt.h>

#define PM_SLEEP_MODE_S1		1
#define PM_SLEEP_MODE_S2		2
#define PM_SLEEP_MODE_S3		3

#define NORMAL_A	1
#define NORMAL_B	2
#define NORMAL_C	3
#define NORMAL_D	4

#define NORMAL_B_DIV	3

extern int emxx_sleep_while_idle;
extern int emxx_pm_sleep(unsigned int mode);
extern void pm_change_normalA(void);
extern void pm_change_normalB(void);
#ifdef CONFIG_PM
extern void emxx_pm_pdma_suspend_enable(void);
extern void emxx_pm_pdma_suspend_disable(void);
extern unsigned int emxx_pm_pdma_suspend_status(void);
#else
#define emxx_pm_pdma_suspend_enable()
#define emxx_pm_pdma_suspend_disable()
#define emxx_pm_pdma_suspend_status() 	0
#endif

#endif /* __ASM_ARCH_EMXX_PM_H */
