/*
 *  File Name	    : arch/arm/mach-emxx/include/mach/pwc.h
 *  Function        : pwc
 *  Release Version : Ver 1.00
 *  Release Date    : 2010/02/05
 *
 *  Copyright (C) NEC Electronics Corporation 2010
 *
 *
 *  This program is free software;you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by Free
 *  Softwere Foundation; either version 2 of License,
 *  or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY;
 *  without even the implied warrnty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this program;
 *  If not, write to the Free Software Foundation, Inc., 59 Temple
 *  Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifndef _ASM_ARCH_PWC_H_
#define _ASM_ARCH_PWC_H_

/* Power register */

/* System control and event registers */
#define DA9052_PAGECON0_REG		(0) /* read/write */
#define DA9052_STATUSA_REG		(1) /* read */
#define DA9052_STATUSB_REG		(2) /* read */
#define DA9052_STATUSC_REG		(3) /* read */
#define DA9052_STATUSD_REG		(4) /* read */
#define DA9052_EVENTA_REG		(5) /* read */
#define DA9052_EVENTB_REG		(6) /* read */
#define DA9052_EVENTC_REG		(7) /* read */
#define DA9052_EVENTD_REG		(8) /* read */
#define DA9052_FAULTLOG_REG		(9) /* read */
#define DA9052_IRQMASKA_REG		(10) /* read/write */
#define DA9052_IRQMASKB_REG		(11) /* read/write */
#define DA9052_IRQMASKC_REG		(12) /* read/write */
#define DA9052_IRQMASKD_REG		(13) /* read/write */
#define DA9052_CONTROLA_REG		(14) /* read/write */
#define DA9052_CONTROLB_REG		(15) /* read/write */
#define DA9052_CONTROLC_REG		(16) /* read/write */
#define DA9052_CONTROLD_REG		(17) /* read/write */
#define DA9052_PDDIS_REG		(18) /* read/write */
#define DA9052_INTERFACE_REG	(19) /* read */
#define DA9052_RESET_REG		(20) /* read/write */

/* GPIO control registers */
#define DA9052_GPIO0001_REG		(21) /* read/write */
#define DA9052_GPIO0203_REG		(22) /* read/write */
#define DA9052_GPIO0405_REG		(23) /* read/write */
#define DA9052_GPIO0607_REG		(24) /* read/write */
#define DA9052_GPIO0809_REG		(25) /* read/write */
#define DA9052_GPIO1011_REG		(26) /* read/write */
#define DA9052_GPIO1213_REG		(27) /* read/write */
#define DA9052_GPIO1415_REG		(28) /* read/write bit3 read only */

/* Power sequencer control registers */
#define DA9052_ID01_REG			(29) /* read/write */
#define DA9052_ID23_REG			(30) /* read/write */
#define DA9052_ID45_REG			(31) /* read/write */
#define DA9052_ID67_REG			(32) /* read/write */
#define DA9052_ID89_REG			(33) /* read/write */
#define DA9052_ID1011_REG		(34) /* read/write */
#define DA9052_ID1213_REG		(35) /* read/write */
#define DA9052_ID1415_REG		(36) /* read/write */
#define DA9052_ID1617_REG		(37) /* read/write */
#define DA9052_ID1819_REG		(38) /* read/write */
#define DA9052_ID2021_REG		(39) /* read/write */
#define DA9052_SEQSTATUS_REG	(40) /* read/write */
#define DA9052_SEQA_REG			(41) /* read/write */
#define DA9052_SEQB_REG			(42) /* read/write */
#define DA9052_SEQTIMER_REG		(43) /* read/write */

/* Power supply control registers */
#define DA9052_BUCKA_REG		(44) /* read/write */
#define DA9052_BUCKB_REG		(45) /* read/write */
#define DA9052_BUCKCORE_REG		(46) /* read/write */
#define DA9052_BUCKPRO_REG		(47) /* read/write */
#define DA9052_BUCKMEM_REG		(48) /* read/write */
#define DA9052_BUCKPERI_REG		(49) /* read/write bit6 read only*/
#define DA9052_LDO1_REG			(50) /* read/write bit5 read only*/
#define DA9052_LDO2_REG			(51) /* read/write */
#define DA9052_LDO3_REG			(52) /* read/write */
#define DA9052_LDO4_REG			(53) /* read/write */
#define DA9052_LDO5_REG			(54) /* read/write */
#define DA9052_LDO6_REG			(55) /* read/write */
#define DA9052_LFO7_REG			(56) /* read/write */
#define DA9052_LDO8_REG			(57) /* read/write */
#define DA9052_LDO9_REG			(58) /* read/write */
#define DA9052_LDO10_REG		(59) /* read/write */
#define DA9052_SUPPLY_REG		(60) /* read/write */
#define DA9052_PULLDOWN_REG		(61) /* read/write */

/* Charging control registers */
#define DA9052_CHGBUCK_REG		(62) /* read/write */
#define DA9052_WAITCONT_REG		(63) /* read/write */
#define DA9052_ISET_REG			(64) /* read/write */
#define DA9052_BATCHG_REG		(65) /* read/write */
#define DA9052_CHGCONT_REG		(66) /* read/write */
#define DA9052_INPUTCONT_REG	(67) /* read */
#define DA9052_CHGTIME_REG		(68) /* read/write */

/* Backup battery charging control registers */
#define DA9052_BBATCONT_REG		(69) /* read/write */

/* Boost and LED driver control registers */
#define DA9052_BOOST_REG		(70) /* read/write bit7 read only*/
#define DA9052_LEDCONT_REG		(71) /* read/write bit7 read only*/
#define DA9052_LEDMIN123_REG	(72) /* read/write */
#define DA9052_LED1CONF_REG		(73) /* read/write */
#define DA9052_LED2CONF_REG		(74) /* read/write */
#define DA9052_LED3CONF_REG		(75) /* read/write */
#define DA9052_LED1CONT_REG		(76) /* read/write */
#define DA9052_LED2CONT_REG		(77) /* read/write */
#define DA9052_LED3CONT_REG		(78) /* read/write */
#define DA9052_LED4CONT_REG		(79) /* read/write */
#define DA9052_LED5CONT_REG		(80) /* read/write */

/* GP-ADC control registers */
#define DA9052_ADCMAN_REG		(81) /* read/write bit7-5 read only*/
#define DA9052_ADCCONT_REG		(82) /* read/write */
#define DA9052_ADCRESL_REG		(83) /* read */
#define DA9052_ADCRESH_REG		(84) /* read */
#define DA9052_VDDRES_REG		(85) /* read */
#define DA9052_VDDMON_REG		(86) /* read/write */
#define DA9052_ICHGAV_REG		(87) /* read */
#define DA9052_ICHGTHD_REG		(88) /* read/write */
#define DA9052_ICHGEND_REG		(89) /* read/write */
#define DA9052_TBATRES_REG		(90) /* read */
#define DA9052_TBATHIGHP_REG		(91) /* read/write */
#define DA9052_TBATHIGHIN_REG		(92) /* read/write */
#define DA9052_TBATLOW_REG		(93) /* read/write */
#define DA9052_TOFFSET_REG		(94) /* read/write */
#define DA9052_ADCIN4RES_REG		(95) /* read */
#define DA9052_AUTO4HIGH_REG		(96) /* read/write */
#define DA9052_AUTO4LOW_REG		(97) /* read/write */
#define DA9052_ADCIN5RES_REG		(98) /* read */
#define DA9052_AUTO5HIGH_REG		(99) /* read/write */
#define DA9052_AUTO5LOW_REG		(100) /* read/write */
#define DA9052_ADCIN6RES_REG		(101) /* read */
#define DA9052_AUTO6HIGH_REG		(102) /* read/write */
#define DA9052_AUTO6LOW_REG		(103) /* read/write */
#define DA9052_TJUNCRES_REG		(104) /* read */

/* TSI control registers */
#define DA9052_TSICONTA_REG		(105) /* read/write */
#define DA9052_TSICONTB_REG		(106) /* read/write */
#define DA9052_TSIXMSB_REG		(107) /* read */
#define DA9052_TSIYMSB_REG		(108) /* read */
#define DA9052_TSILSB_REG		(109) /* read */
#define DA9052_TSIZMSB_REG		(110) /* read */

/* RTC calendar and alarm */
#define DA9052_COUNTS_REG		(111) /* read/write bit7 read only*/
#define DA9052_COUNTMI_REG		(112) /* read/write bit7-6 read only*/
#define DA9052_COUNTH_REG		(113) /* read/write bit7-5 read only*/
#define DA9052_COUNTD_REG		(114) /* read/write bit7-5 read only*/
#define DA9052_COUNTMO_REG		(115) /* read/write bit7-4 read only*/
#define DA9052_COUNTY_REG		(116) /* read/write */
#define DA9052_ALARMMI_REG		(117) /* read/write */
#define DA9052_ALARMH_REG		(118) /* read/write bit7-5 read only */
#define DA9052_ALARMD_REG		(119) /* read/write bit7-5 read only */
#define DA9052_ALARMMO_REG		(120) /* read/write bit7-4 read only */
#define DA9052_ALARMY_REG		(121) /* read/write */
#define DA9052_SECONDA_REG		(122) /* read */
#define DA9052_SECONDB_REG		(123) /* read */
#define DA9052_SECONDC_REG		(124) /* read */
#define DA9052_SECONDD_REG		(125) /* read */

#if 0
/* Customer OTP */
#define DA9052_PAGECON128_REG		(128) /* read/write */
#define DA9052_CHIPID_REG		(129) /* read */
#define DA9052_CONFIGID_REG		(130) /* read */
#define DA9052_OTPCONT_REG		(131) /* read/write bit5-4 read only */
#define DA9052_OSCTRIM_REG		(132) /* read/write */
#define DA9052_GPID0_REG		(133) /* read/write */
#define DA9052_GPID1_REG		(134) /* read/write */
#define DA9052_GPID2_REG		(135) /* read/write */
#define DA9052_GPID3_REG		(136) /* read/write */
#define DA9052_GPID4_REG		(137) /* read/write */
#define DA9052_GPID5_REG		(138) /* read/write */
#define DA9052_GPID6_REG		(139) /* read/write */
#define DA9052_GPID7_REG		(140) /* read/write */
#define DA9052_GPID8_REG		(141) /* read/write */
#define DA9052_GPID9_REG		(142) /* read/write */

#define DA9052_PAGE1_REG_START	(DA9052_CHIPID_REG)
#define DA9052_PAGE1_REG_END	(DA9052_GPID9_REG)
#endif

#define DA9052_PAGE0_REG_START	(DA9052_STATUSA_REG)
#define DA9052_PAGE0_REG_END	(DA9052_SECONDD_REG)

#define PWC_MAX			125

/* GPIO Output/Input select */
#define PWC_GPIO_OUTPUT	0
#define PWC_GPIO_INPUT	1

#ifdef CONFIG_EMXX_PWC
extern int  pwc_reg_read(unsigned char addr, unsigned char *data);
extern int  pwc_reg_write(unsigned char addr, unsigned char data);
extern int  pwc_read(unsigned short offset, unsigned int *data);
extern int  pwc_write(unsigned short offset,
			unsigned int data, unsigned int mask);
extern int  pwc_set_direction(unsigned gpio, int is_input);
extern int  pwc_get_value(unsigned int gpio);
extern void pwc_set_value(unsigned int gpio, int value);
extern int  pwc_get_output_value(unsigned int gpio);
#else
static inline int  pwc_reg_read(unsigned char addr, unsigned char *data)
	{ return 0; }
static inline  int  pwc_reg_write(unsigned char addr, unsigned char data)
	{ return 0; }
static inline  int  pwc_read(unsigned short offset, unsigned int *data)
	{ return 0; }
static inline  int  pwc_write(unsigned short offset,
			unsigned int data, unsigned int mask)
	{ return 0; }
static inline  int  pwc_set_direction(unsigned gpio, int is_input)
	{ return 0; }
static inline  int  pwc_get_value(unsigned int gpio)
	{ return 0; }
static inline  void pwc_set_value(unsigned int gpio, int value) { }
static inline  int  pwc_get_output_value(unsigned int gpio)
	{ return 0; }
#endif

#endif /* _ASM_ARCH_PWC_H_ */
