/*
 *  File Name       : arch/arm/mach-emxx/include/mach/smu.h
 *  Function	    : smu
 *  Release Version : Ver 1.00
 *  Release Date    : 2010/02/05
 *
 *  Copyright (C) NEC Electronics Corporation 2010
 *
 *  This program is free software;you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by Free
 *  Softwere Foundation; either version 2 of License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warrnty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; If not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __ASM_ARCH_SMU_H
#define __ASM_ARCH_SMU_H

#include <mach/hardware.h>

/* AB0 */
#define AB_FLASHCOMSET			(IO_ADDRESS(EMXX_AB_BASE) + 0x000)
#define AB_FLASHCOMLATCH		(IO_ADDRESS(EMXX_AB_BASE) + 0x004)
#define AB_FLASHCOMADD0			(IO_ADDRESS(EMXX_AB_BASE) + 0x010)
#define AB_FLASHCOMDATA0		(IO_ADDRESS(EMXX_AB_BASE) + 0x014)
#define AB_FLASHCOMADD1			(IO_ADDRESS(EMXX_AB_BASE) + 0x018)
#define AB_FLASHCOMDATA1		(IO_ADDRESS(EMXX_AB_BASE) + 0x01C)

#define AB_FLASHCLKCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x080)
#define AB_FLA_RCLK_DLY			(IO_ADDRESS(EMXX_AB_BASE) + 0x084)

#define AB_CS0BASEADD			(IO_ADDRESS(EMXX_AB_BASE) + 0x100)
#define AB_CS0BITCOMP			(IO_ADDRESS(EMXX_AB_BASE) + 0x104)
#define AB_CS1BASEADD			(IO_ADDRESS(EMXX_AB_BASE) + 0x110)
#define AB_CS1BITCOMP			(IO_ADDRESS(EMXX_AB_BASE) + 0x114)
#define AB_CS2BASEADD			(IO_ADDRESS(EMXX_AB_BASE) + 0x120)
#define AB_CS2BITCOMP			(IO_ADDRESS(EMXX_AB_BASE) + 0x124)
#define AB_CS3BASEADD			(IO_ADDRESS(EMXX_AB_BASE) + 0x130)
#define AB_CS3BITCOMP			(IO_ADDRESS(EMXX_AB_BASE) + 0x134)
#define AB_CS4BASEADD			(IO_ADDRESS(EMXX_AB_BASE) + 0x140)
#define AB_CS4BITCOMP			(IO_ADDRESS(EMXX_AB_BASE) + 0x144)
#define AB_CS5BASEADD			(IO_ADDRESS(EMXX_AB_BASE) + 0x150)
#define AB_CS5BITCOMP			(IO_ADDRESS(EMXX_AB_BASE) + 0x154)

#define AB_CS0WAITCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x200)
#define AB_CS0WAITCTRL_W		(IO_ADDRESS(EMXX_AB_BASE) + 0x204)
#define AB_CS0READCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x208)
#define AB_CS0WAIT_MASK			(IO_ADDRESS(EMXX_AB_BASE) + 0x20C)
#define AB_CS0CONTROL			(IO_ADDRESS(EMXX_AB_BASE) + 0x210)

#define AB_CS0FLASHRCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x214)
#define AB_CS0FLASHWCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x218)

#define AB_CS1WAITCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x220)
#define AB_CS1WAITCTRL_W		(IO_ADDRESS(EMXX_AB_BASE) + 0x224)
#define AB_CS1READCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x228)
#define AB_CS1WAIT_MASK			(IO_ADDRESS(EMXX_AB_BASE) + 0x22C)
#define AB_CS1CONTROL			(IO_ADDRESS(EMXX_AB_BASE) + 0x230)

#define AB_CS1FLASHRCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x234)
#define AB_CS1FLASHWCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x238)

#define AB_CS2WAITCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x240)
#define AB_CS2WAITCTRL_W		(IO_ADDRESS(EMXX_AB_BASE) + 0x244)
#define AB_CS2READCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x248)
#define AB_CS2WAIT_MASK			(IO_ADDRESS(EMXX_AB_BASE) + 0x24C)
#define AB_CS2CONTROL			(IO_ADDRESS(EMXX_AB_BASE) + 0x250)

#define AB_CS2FLASHRCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x254)
#define AB_CS2FLASHWCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x258)

#define AB_CS3WAITCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x260)
#define AB_CS3WAITCTRL_W		(IO_ADDRESS(EMXX_AB_BASE) + 0x264)
#define AB_CS3READCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x268)
#define AB_CS3WAIT_MASK			(IO_ADDRESS(EMXX_AB_BASE) + 0x26C)
#define AB_CS3CONTROL			(IO_ADDRESS(EMXX_AB_BASE) + 0x270)

#define AB_CS3FLASHRCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x274)
#define AB_CS3FLASHWCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x278)

#define AB_CS4WAITCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x280)
#define AB_CS4WAITCTRL_W		(IO_ADDRESS(EMXX_AB_BASE) + 0x284)
#define AB_CS4READCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x288)
#define AB_CS4WAIT_MASK			(IO_ADDRESS(EMXX_AB_BASE) + 0x28C)
#define AB_CS4CONTROL			(IO_ADDRESS(EMXX_AB_BASE) + 0x290)

#define AB_CS4FLASHRCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x294)
#define AB_CS4FLASHWCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x298)

#define AB_CS5WAITCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x2A0)
#define AB_CS5WAITCTRL_W		(IO_ADDRESS(EMXX_AB_BASE) + 0x2A4)
#define AB_CS5READCTRL			(IO_ADDRESS(EMXX_AB_BASE) + 0x2A8)
#define AB_CS5WAIT_MASK			(IO_ADDRESS(EMXX_AB_BASE) + 0x2AC)
#define AB_CS5CONTROL			(IO_ADDRESS(EMXX_AB_BASE) + 0x2B0)

#define AB_CS5FLASHRCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x2B4)
#define AB_CS5FLASHWCR			(IO_ADDRESS(EMXX_AB_BASE) + 0x2B8)


#define AB_CS0WAITCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x300)
#define AB_CS0WAITCTRL_W2		(IO_ADDRESS(EMXX_AB_BASE) + 0x304)
#define AB_CS0READCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x308)
#define AB_CS0WAIT_MASK2		(IO_ADDRESS(EMXX_AB_BASE) + 0x30C)
#define AB_CS0CONTROL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x310)

#define AB_CS0FLASHRCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x314)
#define AB_CS0FLASHWCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x318)

#define AB_CS1WAITCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x320)
#define AB_CS1WAITCTRL_W2		(IO_ADDRESS(EMXX_AB_BASE) + 0x324)
#define AB_CS1READCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x328)
#define AB_CS1WAIT_MASK2		(IO_ADDRESS(EMXX_AB_BASE) + 0x32C)
#define AB_CS1CONTROL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x330)

#define AB_CS1FLASHRCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x334)
#define AB_CS1FLASHWCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x338)

#define AB_CS2WAITCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x340)
#define AB_CS2WAITCTRL_W2		(IO_ADDRESS(EMXX_AB_BASE) + 0x344)
#define AB_CS2READCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x348)
#define AB_CS2WAIT_MASK2		(IO_ADDRESS(EMXX_AB_BASE) + 0x34C)
#define AB_CS2CONTROL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x350)

#define AB_CS2FLASHRCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x354)
#define AB_CS2FLASHWCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x358)

#define AB_CS3WAITCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x360)
#define AB_CS3WAITCTRL_W2		(IO_ADDRESS(EMXX_AB_BASE) + 0x364)
#define AB_CS3READCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x368)
#define AB_CS3WAIT_MASK2		(IO_ADDRESS(EMXX_AB_BASE) + 0x36C)
#define AB_CS3CONTROL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x370)

#define AB_CS3FLASHRCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x374)
#define AB_CS3FLASHWCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x378)

#define AB_CS4WAITCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x380)
#define AB_CS4WAITCTRL_W2		(IO_ADDRESS(EMXX_AB_BASE) + 0x384)
#define AB_CS4READCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x388)
#define AB_CS4WAIT_MASK2		(IO_ADDRESS(EMXX_AB_BASE) + 0x38C)
#define AB_CS4CONTROL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x390)

#define AB_CS4FLASHRCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x394)
#define AB_CS4FLASHWCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x398)

#define AB_CS5WAITCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x3A0)
#define AB_CS5WAITCTRL_W2		(IO_ADDRESS(EMXX_AB_BASE) + 0x3A4)
#define AB_CS5READCTRL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x3A8)
#define AB_CS5WAIT_MASK2		(IO_ADDRESS(EMXX_AB_BASE) + 0x3AC)
#define AB_CS5CONTROL2			(IO_ADDRESS(EMXX_AB_BASE) + 0x3B0)

#define AB_CS5FLASHRCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x3B4)
#define AB_CS5FLASHWCR2			(IO_ADDRESS(EMXX_AB_BASE) + 0x3B8)


/* SMU */
#define SMU_CPU_RSTCTRL0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0000)
#define SMU_CPU_RSTCTRL1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0004)
#define SMU_DSP_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0008)
#define SMU_GIO_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x000C)
#define SMU_INTA_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0010)
#define SMU_CHG_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0014)
#define SMU_CHG1_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0018)
#define SMU_BUS0_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x001C)
#define SMU_BUS1_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0020)
#define SMU_PBL0_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0024)
#define SMU_PBL1_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0028)
#define SMU_AHB_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x002C)
#define SMU_P2M_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0030)
#define SMU_M2P_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0034)
#define SMU_M2M_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0038)
#define SMU_PMU_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x003C)
#define SMU_SRC_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0040)
#define SMU_ROM_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0044)
#define SMU_AB0_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0048)
#define SMU_MEMC_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x004C)
#define SMU_LCD_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0050)
#define SMU_IMC_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0054)
#define SMU_IMCW_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0058)
#define SMU_SIZ_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x005C)
#define SMU_ROT_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0060)
#define SMU_AVE_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0068)
#define SMU_A3D_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x006C)
#define SMU_DTV_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0070)
#define SMU_NTS_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0074)
#define SMU_CAM_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0078)
#define SMU_IRR_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0084)
#define SMU_PWM_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0088)
#define SMU_USIAS0_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x008C)
#define SMU_USIAS1_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0090)
#define SMU_USIAU0_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0094)
#define SMU_USIBS2_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x009C)
#define SMU_USIBS3_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00A0)
#define SMU_USIBS4_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00A4)
#define SMU_USIBS5_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00A8)
#define SMU_USIBU1_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00AC)
#define SMU_USIBU2_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00B0)
#define SMU_USIBU3_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00B4)
#define SMU_SDIO0_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00BC)
#define SMU_SDIO1_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00C0)
#define SMU_SDIO2_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00C4)
#define SMU_SDC_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x00C8)
#define SMU_CFI_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x00D0)
#define SMU_MSP_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x00D4)
#define SMU_HSI_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x00D8)
#define SMU_IIC0_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00DC)
#define SMU_IIC1_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00E0)
#define SMU_USB0_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00E4)
#define SMU_USB1_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x00E8)
#define SMU_TI0_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x00EC)
#define SMU_TI1_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x00F0)
#define SMU_TI2_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x00F4)
#define SMU_TI3_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x00F8)
#define SMU_TW0_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x00FC)
#define SMU_TW1_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0100)
#define SMU_TW2_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0104)
#define SMU_TW3_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0108)
#define SMU_TG0_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x010C)
#define SMU_TG1_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0110)
#define SMU_TG2_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0114)
#define SMU_TG3_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0118)
#define SMU_TG4_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x011C)
#define SMU_TG5_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0120)
#define SMU_STI_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0124)
#define SMU_CRP_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0128)
#define SMU_AFS_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x012C)
#define SMU_MMM_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0130)
#define SMU_TW4_RSTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0140)
#define SMU_PDMA_RSTCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0148)

#define SMU_CPU_SAFE_RESET0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0154)
#define SMU_CPU_SAFE_RESET1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0158)
#define SMU_DSP_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x015C)
#define SMU_USB0_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0160)
#define SMU_USB1_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0164)
#define SMU_DTV_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0168)
#define SMU_CFI_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x016C)
#define SMU_SDC_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0170)
#define SMU_SDIO0_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0174)
#define SMU_SDIO1_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0178)
#define SMU_SDIO2_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x017C)
#define SMU_USIA_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0180)
#define SMU_USIB_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0184)
#define SMU_HSI_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0188)
#define SMU_CAM_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x018C)
#define SMU_AHB_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x019C)
#define SMU_A3D_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01A0)
#define SMU_AVE_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01A4)
#define SMU_SIZ_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01A8)
#define SMU_ROT_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01AC)
#define SMU_IMC_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01B0)
#define SMU_IMCW_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01B4)
#define SMU_M2M_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01B8)
#define SMU_M2P_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01BC)
#define SMU_P2M_SAFE_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01C0)
#define SMU_RSTZ_CLKREQ			(IO_ADDRESS(EMXX_SMU_BASE) + 0x01C8)
#define SMU_WDT_INT_RESET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01D0)

#define SMU_SFTWARE_INTGEN		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01DC)
#define SMU_INT_STATUS			(IO_ADDRESS(EMXX_SMU_BASE) + 0x01E0)
#define SMU_INT_RAW_STATUS		(IO_ADDRESS(EMXX_SMU_BASE) + 0x01E4)
#define SMU_INT_ENSET			(IO_ADDRESS(EMXX_SMU_BASE) + 0x01E8)
#define SMU_INT_ENCLR			(IO_ADDRESS(EMXX_SMU_BASE) + 0x01EC)
#define SMU_INT_CLEAR			(IO_ADDRESS(EMXX_SMU_BASE) + 0x01F0)

#define SMU_PLL1CTRL0			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0200)
#define SMU_PLL1CTRL1			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0204)
#define SMU_PLL2CTRL0			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0208)
#define SMU_PLL2CTRL1			(IO_ADDRESS(EMXX_SMU_BASE) + 0x020C)
#define SMU_PLL3CTRL0			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0210)
#define SMU_PLL3CTRL1			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0214)
#define SMU_PLL4CTRL0			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0218)
#define SMU_PLL4CTRL1			(IO_ADDRESS(EMXX_SMU_BASE) + 0x021C)
#define SMU_OSC0CTRL1			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0220)
#define SMU_OSC1CTRL1			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0224)
#define SMU_PLLLOCKTIME0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0228)
#define SMU_PLLLOCKTIME1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x022C)
#define SMU_OSCLOCKTIME			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0230)
#define SMU_PLL_STATUS			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0234)
#define SMU_ROSCCTRL1			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0238)

#define SMU_OSC_CX			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0248)

#define SMU_AUTO_PLL_STANDBY		(IO_ADDRESS(EMXX_SMU_BASE) + 0x02F0)
#define SMU_AUTO_MODE_EN		(IO_ADDRESS(EMXX_SMU_BASE) + 0x02F4)

#define SMU_CLK_MODE_SEL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0300)
#define SMU_MEMC_HAND_SHAKE_FAKE	(IO_ADDRESS(EMXX_SMU_BASE) + 0x0304)

#define SMU_LSBOOT_MASK			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0310)

#define SMU_CKMODE_PLLSEL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x031C)
#define SMU_NORMALA_DIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0320)
#define SMU_NORMALB_DIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0324)
#define SMU_NORMALC_DIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0328)
#define SMU_NORMALD_DIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x032C)
#define SMU_POWERON_DIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0330)
#define SMU_ECONOMY_DIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0334)
#define SMU_SLEEP_DIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0338)

#define SMU_MEMCCLK270_SEL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0350)

#define SMU_CPUCLK_SYNCSET		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0358)
#define SMU_CPUCLK_ASYNC_MODE		(IO_ADDRESS(EMXX_SMU_BASE) + 0x035C)
#define SMU_FLA_CLK_DLY			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0360)
#define SMU_FLASHCLK_CTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0364)
#define SMU_DSPCLK_ASYNC_MODE		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0368)

/* auto clock controll */
#define SMU_AHBCLKCTRL0			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0380)
#define SMU_AHBCLKCTRL1			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0384)
#define SMU_AHBCLKCTRL2			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0388)
#define SMU_AHBCLKCTRL3			(IO_ADDRESS(EMXX_SMU_BASE) + 0x038C)
#define SMU_APBCLKCTRL0			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0390)
#define SMU_APBCLKCTRL1			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0394)
#define SMU_APBCLKCTRL2			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0398)
#define SMU_CLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x039C)
#define SMU_AVECLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x03A0)

/* auto clock controll */
#define SMU_CPUGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0400)
#define SMU_DSPGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0404)
#define SMU_GIOGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0408)
#define SMU_INTAGCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x040C)
#define SMU_CHGGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0410)
#define SMU_BUS0GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0414)
#define SMU_BUS1GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0418)
#define SMU_PBL0GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x041C)
#define SMU_PBL1GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0420)
#define SMU_AHBGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0424)
#define SMU_P2MGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0428)
#define SMU_M2PGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x042C)
#define SMU_M2MGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0430)
#define SMU_PMUGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0434)
#define SMU_SRCGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0438)
#define SMU_ROMGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x043C)
#define SMU_ABGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0440)
#define SMU_FLAGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0444)
#define SMU_MEMCGCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0448)
#define SMU_LCDGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x044C)
#define SMU_IMCGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0450)
#define SMU_IMCWGCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0454)
#define SMU_SIZGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0458)
#define SMU_ROTGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x045C)
#define SMU_AVEGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0464)
#define SMU_A3DGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0468)
#define SMU_DTVGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x046C)
#define SMU_NTSGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0470)
#define SMU_CAMGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0474)
#define SMU_IRRGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0480)
#define SMU_PWMGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0484)
#define SMU_HSIGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0488)
#define SMU_IIC0GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x048C)
#define SMU_IIC1GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0490)
#define SMU_USBGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0494)
#define SMU_USIAS0GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0498)
#define SMU_USIAS1GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x049C)
#define SMU_USIAU0GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04A0)
#define SMU_USIBS2GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04A8)
#define SMU_USIBS3GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04AC)
#define SMU_USIBS4GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04B0)
#define SMU_USIBS5GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04B4)
#define SMU_USIBU1GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04B8)
#define SMU_USIBU2GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04BC)
#define SMU_USIBU3GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04C0)
#define SMU_SDIO0GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04C8)
#define SMU_SDIO1GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04CC)
#define SMU_SDIO2GCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x04D0)
#define SMU_SDCGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x04D4)
#define SMU_CFIGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x04DC)
#define SMU_MSPGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x04E8)
#define SMU_TI0GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x04EC)
#define SMU_TI1GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x04F0)
#define SMU_TI2GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x04F4)
#define SMU_TI3GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x04F8)
#define SMU_TG0GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x04FC)
#define SMU_TG1GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0500)
#define SMU_TG2GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0504)
#define SMU_TG3GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0508)
#define SMU_TG4GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x050C)
#define SMU_TG5GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0510)
#define SMU_TW0GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0514)
#define SMU_TW1GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0518)
#define SMU_TW2GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x051C)
#define SMU_TW3GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0520)
#define SMU_TIMGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0524)
#define SMU_STIGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0528)
#define SMU_CRPGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x052C)
#define SMU_AFSGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0530)
#define SMU_MMMGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0534)
#define SMU_REFGCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x053C)
#define SMU_TW4GCLKCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0540)
#define SMU_PDMAGCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0554)
#define SMU_INTDGCLKCTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0558)

#define SMU_TWI0TIN_SEL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0600)
#define SMU_TWI1TIN_SEL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0604)
#define SMU_TWI2TIN_SEL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0608)
#define SMU_TWI3TIN_SEL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x060C)
#define SMU_TGNTIN_SEL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0610)
#define SMU_TIMCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0614)
#define SMU_USIASCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0618)
#define SMU_USIAU0SCLKDIV		(IO_ADDRESS(EMXX_SMU_BASE) + 0x061C)
#define SMU_IICSCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0624)
#define SMU_USBSCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0628)
#define SMU_MEMCRCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x062C)
#define SMU_LCDLCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0630)
#define SMU_CFISCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x063C)
#define SMU_SDCSCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0644)
#define SMU_SDIO0SCLKDIV		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0648)
#define SMU_SDIO1SCLKDIV		(IO_ADDRESS(EMXX_SMU_BASE) + 0x064C)
#define SMU_SDIO2SCLKDIV		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0650)
#define SMU_USIB0SCLKDIV		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0654)
#define SMU_USIB1SCLKDIV		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0658)
#define SMU_USIB2SCLKDIV		(IO_ADDRESS(EMXX_SMU_BASE) + 0x065C)
#define SMU_USIB3SCLKDIV		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0660)
#define SMU_MSPSCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0664)
#define SMU_HSISCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0668)
#define SMU_PWMPWCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x066C)
#define SMU_CAMSCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0670)
#define SMU_A3DCORECLKDIV		(IO_ADDRESS(EMXX_SMU_BASE) + 0x067C)
#define SMU_AVECCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0680)
#define SMU_QRCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0684)
#define SMU_STI_CLKSEL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0688)
#define SMU_REFCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x068C)
#define SMU_ADVFSCLKDIV			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0694)
#define SMU_TW4TIN_SEL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0698)
#define SMU_INTA_CLKSEL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x069C)

#define SMU_CLK32_STATUS		(IO_ADDRESS(EMXX_SMU_BASE) + 0x06E0)
#define SMU_CLKSTOPSIG_ST		(IO_ADDRESS(EMXX_SMU_BASE) + 0x06F0)
#define SMU_CKRQMODE_MASK0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0700)
#define SMU_CKRQMODE_MASK1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0704)
#define SMU_CKRQ_MODE			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0708)
#define SMU_BUSCKRQ_MODE		(IO_ADDRESS(EMXX_SMU_BASE) + 0x070C)
#define SMU_DFS_FIFOMODE		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0710)
#define SMU_DFS_FIFO_REQMASK		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0714)
#define SMU_LCD_FIFOTHRESHOLD		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0718)
#define SMU_CAM_FIFOTHRESHOLD		(IO_ADDRESS(EMXX_SMU_BASE) + 0x071C)

#define SMU_GENERAL_REG0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x07C0)
#define SMU_GENERAL_REG1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x07C4)

#define SMU_LOWPWR			(IO_ADDRESS(EMXX_SMU_BASE) + 0x07F0)
#define SMU_PLLVDDWAIT			(IO_ADDRESS(EMXX_SMU_BASE) + 0x07F4)

#define SMU_P0_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0800)
#define SMU_PU_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0808)
#define SMU_PM_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x080C)
#define SMU_PL_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0810)
#define SMU_PD_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0814)
#define SMU_P1_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0818)
#define SMU_P2_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x081C)
#define SMU_PG_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0820)
#define SMU_PV_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0824)
#define SMU_PR_POWERSW			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0828)
#define SMU_POWER_STATUS		(IO_ADDRESS(EMXX_SMU_BASE) + 0x082C)
#define SMU_SEQ_BUSY			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0830)
#define SMU_P0_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0834)
#define SMU_PS_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0838)
#define SMU_PU_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x083C)
#define SMU_PM_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0840)
#define SMU_PL_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0844)
#define SMU_PD_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0848)
#define SMU_P1_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x084C)
#define SMU_P2_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0850)
#define SMU_PG_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0854)
#define SMU_PV_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0858)
#define SMU_PR_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x085C)
#define SMU_P0_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0860)
#define SMU_P0_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0864)
#define SMU_P0_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0868)

#define SMU_PU_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0878)
#define SMU_PU_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x087C)
#define SMU_PU_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0880)
#define SMU_PM_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0884)
#define SMU_PM_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0888)
#define SMU_PM_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x088C)
#define SMU_PL_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0890)
#define SMU_PL_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0894)
#define SMU_PL_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0898)
#define SMU_PD_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x089C)
#define SMU_PD_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08A0)
#define SMU_PD_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08A4)
#define SMU_P1_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08A8)
#define SMU_P1_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08AC)
#define SMU_P1_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08B0)
#define SMU_P2_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08B4)
#define SMU_P2_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08B8)
#define SMU_P2_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08BC)
#define SMU_PG_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08C0)
#define SMU_PG_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08C4)
#define SMU_PG_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08C8)
#define SMU_PV_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08CC)
#define SMU_PV_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08D0)
#define SMU_PV_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08D4)
#define SMU_PR_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08D8)
#define SMU_PR_RFF_PARA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08DC)
#define SMU_PR_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x08E0)
#define SMU_P0_SWENA			(IO_ADDRESS(EMXX_SMU_BASE) + 0x08E4)

#define SMU_CPU_PWSW_L2RAM		(IO_ADDRESS(EMXX_SMU_BASE) + 0x098C)
#define SMU_CPU_PWSW_LOGIC		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0990)
#define SMU_CPU_PWSW_L1RAM		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0994)
#define SMU_CPU_SRAM_PD			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0998)
#define SMU_CPU_PWSW_CTRL		(IO_ADDRESS(EMXX_SMU_BASE) + 0x099C)
#define SMU_CPU_POWER_STATUS		(IO_ADDRESS(EMXX_SMU_BASE) + 0x09A0)
#define SMU_CPU_SEQ_BUSY		(IO_ADDRESS(EMXX_SMU_BASE) + 0x09A4)

#define SMU_QR_WFE			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09B4)
#define SMU_QR_WFI			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09B8)

#define SMU_DS0_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09D0)
#define SMU_DS1_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09D4)
#define SMU_HM_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09D8)
#define SMU_PE0_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09DC)
#define SMU_PE1_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09E0)
#define SMU_NE0_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09E4)
#define SMU_NE1_SWON			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09E8)
#define SMU_PC_RFF_PARA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x09EC)
#define SMU_PC_PWSW_PARA		(IO_ADDRESS(EMXX_SMU_BASE) + 0x09F0)
#define SMU_QR_WAITCNT			(IO_ADDRESS(EMXX_SMU_BASE) + 0x09F4)

#define SMU_PMU_INTCTRL			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0A30)
#define SMU_PC_SWENA			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0A34)
#define SMU_CPU_CFGEND			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0A40)

#define SMU_CPU_ASSOCIATIVITY		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0A4C)
#define SMU_CPU_WAYSIZE			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0A50)

#define SMU_MACRODIS			(IO_ADDRESS(EMXX_SMU_BASE) + 0x0ADC)
#define SMU_ICEREG_DATA0		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0AE0)
#define SMU_ICEREG_DATA1		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0AE4)
#define SMU_ICEREG_DATA2		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0AE8)
#define SMU_ICEREG_DATA3		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0AEC)
#define SMU_ICEREG_DATA4		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0AF0)
#define SMU_ICEREG_DATA5		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0AF4)
#define SMU_ICEREG_DATA6		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0AF8)
#define SMU_ICEREG_DATA7		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0AFC)
#define SMU_R_CP15SDISABLE		(IO_ADDRESS(EMXX_SMU_BASE) + 0x0B00)

#define SMU_MEMCHSENA_AFRQ		(IO_ADDRESS(EMXX_SMU_BASE) + 0x1018)

#define SMU_CHIP_REVISION		(IO_ADDRESS(EMXX_SMU_BASE) + 0x2000)


/* DIV register PLL select value */
#define SMU_PLLSEL_PLL3	(0 << 8)
#define SMU_PLLSEL_PLL4	(1 << 8)
#define SMU_PLLSEL_OSC0	(2 << 8)
#define SMU_PLLSEL_OSC1	(3 << 8)
#define SMU_PLLSEL_MASK	(3 << 8)

#define SMU_DIV(x)	(x - 1)

/* TIN register PLL select value */
#define TINTIN_SEL_PLL3		0x00000000	/* TIxTIN */
#define TINTIN_SEL_32768	0x00000001
#define TINTIN_SEL_32K		0x00000002
#define MASK_TINTIN_SEL		0x00000003
#define	TWNTIN_SEL_PLL3		0x00000000	/* TWxTIN */
#define	TWNTIN_SEL_32768	0x00010000
#define	TWNTIN_SEL_32K		0x00020000
#define	MASK_TWNTIN_SEL		0x00030000
#define TGNTIN_SEL_PLL3		0x00000000
#define TGNTIN_SEL_32768	0x00111111
#define TGNTIN_SEL_32K		0x00222222

/*
 * CHG registers
 */
#define CHG_BOOT_MODE		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0000)
#define CHG_P1_LAT		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0004)

#define CHG_CTRL_SDINT		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0104)
#define CHG_CTRL_AB0_BOOT	(IO_ADDRESS(EMXX_CHG_BASE) + 0x0108)
#define CHG_LCD_ENABLE		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0110)

#define CHG_PINSEL_G000		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0200)
#define CHG_PINSEL_G032		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0204)
#define CHG_PINSEL_G064		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0208)
#define CHG_PINSEL_G096		(IO_ADDRESS(EMXX_CHG_BASE) + 0x020C)
#define CHG_PINSEL_G128		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0210)
#define CHG_GIOMASK000		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0220)
#define CHG_GIOMASK032		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0224)
#define CHG_GIOMASK064		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0228)
#define CHG_GIOMASK096		(IO_ADDRESS(EMXX_CHG_BASE) + 0x022C)
#define CHG_GIOMASK128		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0230)

#define CHG_PINSEL_LCD		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0280)
#define CHG_PINSEL_LCD3		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0284)
#define CHG_PINSEL_UART		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0288)
#define CHG_PINSEL_IIC		(IO_ADDRESS(EMXX_CHG_BASE) + 0x028C)
#define CHG_PINSEL_SD		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0290)
#define CHG_PINSEL_AB		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0294)
#define CHG_PINSEL_USI		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0298)
#define CHG_PINSEL_NTSC		(IO_ADDRESS(EMXX_CHG_BASE) + 0x029C)
#define CHG_PINSEL_CAM		(IO_ADDRESS(EMXX_CHG_BASE) + 0x02A0)
#define CHG_PINSEL_SYS		(IO_ADDRESS(EMXX_CHG_BASE) + 0x02A4)
#define CHG_PINSEL_HSI		(IO_ADDRESS(EMXX_CHG_BASE) + 0x02A8)

#define CHG_PULL0		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0300)
#define CHG_PULL1		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0304)
#define CHG_PULL2		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0308)
#define CHG_PULL3		(IO_ADDRESS(EMXX_CHG_BASE) + 0x030C)
#define CHG_PULL4		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0310)
#define CHG_PULL5		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0314)
#define CHG_PULL6		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0318)
#define CHG_PULL7		(IO_ADDRESS(EMXX_CHG_BASE) + 0x031C)
#define CHG_PULL8		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0320)
#define CHG_PULL9		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0324)
#define CHG_PULL10		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0328)
#define CHG_PULL11		(IO_ADDRESS(EMXX_CHG_BASE) + 0x032C)
#define CHG_PULL12		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0330)
#define CHG_PULL13		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0334)
#define CHG_PULL14		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0338)
#define CHG_PULL15		(IO_ADDRESS(EMXX_CHG_BASE) + 0x033C)
#define CHG_PULL16		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0340)
#define CHG_PULL17		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0344)
#define CHG_PULL18		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0348)
#define CHG_PULL19		(IO_ADDRESS(EMXX_CHG_BASE) + 0x034C)
#define CHG_PULL20		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0350)
#define CHG_PULL21		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0354)
#define CHG_PULL22		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0358)
#define CHG_PULL23		(IO_ADDRESS(EMXX_CHG_BASE) + 0x035C)
#define CHG_PULL24		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0360)
#define CHG_PULL25		(IO_ADDRESS(EMXX_CHG_BASE) + 0x0364)

#define CHG_DRIVE0              (IO_ADDRESS(EMXX_CHG_BASE) + 0x0400)
#define CHG_DRIVE1              (IO_ADDRESS(EMXX_CHG_BASE) + 0x0404)
#define CHG_DRIVE2              (IO_ADDRESS(EMXX_CHG_BASE) + 0x0408)
#define CHG_DRIVE3              (IO_ADDRESS(EMXX_CHG_BASE) + 0x040C)
#define CHG_DRIVE4              (IO_ADDRESS(EMXX_CHG_BASE) + 0x0410)
#define CHG_DRIVE5              (IO_ADDRESS(EMXX_CHG_BASE) + 0x0414)

#define CHG_BUSHOLD             (IO_ADDRESS(EMXX_CHG_BASE) + 0x0500)

#define CHG_FLASHCLK_SEL        (IO_ADDRESS(EMXX_CHG_BASE) + 0x0510)
#define CHG_SDIO_CNT_SET        (IO_ADDRESS(EMXX_CHG_BASE) + 0x0520)
#define CHG_CFI_WP_SET          (IO_ADDRESS(EMXX_CHG_BASE) + 0x0524)
#define CHG_USBP_PLLTHMODE_SET  (IO_ADDRESS(EMXX_CHG_BASE) + 0x0528)

#define CHG_DELAY_LCD33         (IO_ADDRESS(EMXX_CHG_BASE) + 0x0600)
#define CHG_DELAY_LCD18         (IO_ADDRESS(EMXX_CHG_BASE) + 0x0604)
#define CHG_DELAY_MSP           (IO_ADDRESS(EMXX_CHG_BASE) + 0x0608)
#define CHG_DELAY_AB            (IO_ADDRESS(EMXX_CHG_BASE) + 0x060C)
#define CHG_DELAY_HSI           (IO_ADDRESS(EMXX_CHG_BASE) + 0x0610)
#define CHG_DELAY_ICEA33        (IO_ADDRESS(EMXX_CHG_BASE) + 0x0618)
#define CHG_DELAY_ICEA18        (IO_ADDRESS(EMXX_CHG_BASE) + 0x061C)

#define CHG_MON_EN              (IO_ADDRESS(EMXX_CHG_BASE) + 0x0700)
#define CHG_MON_SEL0_3          (IO_ADDRESS(EMXX_CHG_BASE) + 0x0704)
#define CHG_MON_SEL4_7          (IO_ADDRESS(EMXX_CHG_BASE) + 0x0708)
#define CHG_MON_SEL8_11         (IO_ADDRESS(EMXX_CHG_BASE) + 0x070C)
#define CHG_MON_SEL12_15        (IO_ADDRESS(EMXX_CHG_BASE) + 0x0710)
#define CHG_MON_SEL16_19        (IO_ADDRESS(EMXX_CHG_BASE) + 0x0714)
#define CHG_MON_INT_SEL0_3      (IO_ADDRESS(EMXX_CHG_BASE) + 0x0718)
#define CHG_MON_INT_SEL4        (IO_ADDRESS(EMXX_CHG_BASE) + 0x071C)
#define CHG_MON_USIA_SEL        (IO_ADDRESS(EMXX_CHG_BASE) + 0x0720)
#define CHG_MON_USIB_SEL        (IO_ADDRESS(EMXX_CHG_BASE) + 0x0724)
#define CHG_MON_USB_SEL         (IO_ADDRESS(EMXX_CHG_BASE) + 0x0728)
#define CHG_MON_HSI_SEL         (IO_ADDRESS(EMXX_CHG_BASE) + 0x072C)
#define CHG_MON_OUTREG          (IO_ADDRESS(EMXX_CHG_BASE) + 0x0730)
#define CHG_MON_READ            (IO_ADDRESS(EMXX_CHG_BASE) + 0x0734)
#define CHG_MON_COMP            (IO_ADDRESS(EMXX_CHG_BASE) + 0x0738)
#define CHG_MON_STATUS          (IO_ADDRESS(EMXX_CHG_BASE) + 0x0740)
#define CHG_MON_RAW_STATUS      (IO_ADDRESS(EMXX_CHG_BASE) + 0x0744)
#define CHG_MON_ENSET           (IO_ADDRESS(EMXX_CHG_BASE) + 0x0748)
#define CHG_MON_ENCLR           (IO_ADDRESS(EMXX_CHG_BASE) + 0x074C)
#define CHG_MON_FFCLR           (IO_ADDRESS(EMXX_CHG_BASE) + 0x0750)
#define CHG_MON_CNT_CTRL        (IO_ADDRESS(EMXX_CHG_BASE) + 0x0760)
#define CHG_MON00_CNT           (IO_ADDRESS(EMXX_CHG_BASE) + 0x0764)
#define CHG_MON01_CNT           (IO_ADDRESS(EMXX_CHG_BASE) + 0x0768)
#define CHG_MON02_CNT           (IO_ADDRESS(EMXX_CHG_BASE) + 0x076C)
#define CHG_MON03_CNT           (IO_ADDRESS(EMXX_CHG_BASE) + 0x0770)

#define CHG_MON_PSWT_AND        (IO_ADDRESS(EMXX_CHG_BASE) + 0x0780)
#define CHG_MON_PSWT_OR         (IO_ADDRESS(EMXX_CHG_BASE) + 0x0784)

#define CHG_TEST                (IO_ADDRESS(EMXX_CHG_BASE) + 0x07C0)
#define CHG_RST_CTRL            (IO_ADDRESS(EMXX_CHG_BASE) + 0x07C4)
#define CHG_LOOPBACK            (IO_ADDRESS(EMXX_CHG_BASE) + 0x07D0)
#define CHG_BDS                 (IO_ADDRESS(EMXX_CHG_BASE) + 0x07D4)

#define CHG_RSV_REG0            (IO_ADDRESS(EMXX_CHG_BASE) + 0x0800)
#define CHG_RSV_REG1            (IO_ADDRESS(EMXX_CHG_BASE) + 0x0804)
#define CHG_RSV_REG2            (IO_ADDRESS(EMXX_CHG_BASE) + 0x0808)
#define CHG_RSV_REG3            (IO_ADDRESS(EMXX_CHG_BASE) + 0x080C)

#endif	/* __ASM_ARCH_SMU_H */
