/*
 * i2c-vup.h - interfaces internal to the I2C framework
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

typedef enum {
    VUP_TYPE_S1  =  0,					// cƏ}CR(S1)
    VUP_TYPE_S2,						// cƏ}CR(S2)
    VUP_TYPE_S3,						// cƏ}CR(S3)
    VUP_TYPE_VF,						// cƏ}CR(VF) VF͖荀ڂ̂ߗv

    VUP_TYPE_S1_BOOT  =  0x10,			// cƏ}CR(S1)u[g̈
    VUP_TYPE_S2_BOOT,					// cƏ}CR(S2)u[g̈
    VUP_TYPE_S3_BOOT,					// cƏ}CR(S3)u[g̈
    VUP_TYPE_VF_BOOT					// cƏ}CR(VF)u[g̈ VF͖荀ڂ̂ߗv
} switch_vup_type;

extern void if_init_switch_ver_up( void );
extern void if_switch_ver_up(unsigned char *data, unsigned short size, switch_vup_type type , void (*callback) (int status));


