/*
 *  File Name       : arch/arm/mach-emxx/include/mach/hardware.h
 *  Function        : system
 *  Release Version : Ver 1.00
 *  Release Date    : 2010/02/05
 *
 *  Copyright (C) NEC Electronics Corporation 2010
 *
 *  This program is free software;you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by Free
 *  Softwere Foundation; either version 2 of License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warrnty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; If not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __ASM_ARCH_SYSTEM_H
#define __ASM_ARCH_SYSTEM_H

#include <linux/io.h>
#include <mach/hardware.h>
#include <mach/pwc.h>

extern int emxx_set_reboot_alarm(void);
#ifdef CONFIG_PM
extern void emxx_pm_power_off(void);
#endif

static void arch_idle(void)
{
	cpu_do_idle();
}

static inline void arch_reset(char mode)
{
	printk(KERN_DEBUG "mode = '%c'\n", mode);
	if (mode == 'h') { /* HALT */
#ifdef CONFIG_EMXX_PWC
		pwc_write(DA9052_CONTROLB_REG, 0x80, 0x80);	/* shutdown */
#endif
	} else if (mode == 's') { /* Soft Reboot */
#ifdef CONFIG_RTC_DRV_EMXX
		emxx_set_reboot_alarm();
#endif
#ifdef CONFIG_PM
		emxx_pm_power_off();
#endif
	}
}

#endif	/* __ASM_ARCH_SYSTEM_H */
