/*
 * arch/arm/mach-emxx/include/mach/tmonitor.h
 *
 * Copyright 2011 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef __MACH_EMXX_INCLUDE_MACH_TMONITOR_H
#define __MACH_EMXX_INCLUDE_MACH_TMONITOR_H

#ifdef CONFIG_THREAD_MONITOR
extern int trace_cpu;
#define TMON_TRACE_ALL		0x7fffffff
extern int tmon_autostop;
#define TMON_AUTOSTOP_NONE	0
#define TMON_AUTOSTOP_STR	0x01
#define TMON_AUTOSTOP_DELAY	0x02
#define TMON_AUTOSTOP_DELAY2	0x04

extern void add_trace_entry(int cpu, struct task_struct *prev,
			    struct task_struct *next, int data);
extern void tmonitor_write(const char *buffer);
extern void tmonitor_stop(void);
extern void tmonitor_boot_time_notify(char *);
extern void tmonitor_timer_notify(void);

static inline void tmonitor_tick(void)
{
	if (unlikely(TMON_AUTOSTOP_DELAY & tmon_autostop)) {
		tmonitor_timer_notify();
	}
}

#else /* CONFIG_THREAD_MONITOR */

static inline void tmonitor_tick(void) { }
static inline void tmonitor_boot_time_notify(char *) { }

#endif /* CONFIG_THREAD_MONITOR */
#endif /* __MACH_EMXX_INCLUDE_MACH_TMONITOR_H */
