#!/bin/sh
if [ $# != 1 ]; then
	echo "Usage: ./load_module.sh <0/1/2>"
	exit
fi
DIR="test_driver"
echo "<<<<<<<<<<<<<<<<<<insmod gpiotest>>>>>>>>>>>>>>>>>>"
n=`lsmod | grep -c gpio_test_module`
if [ $n != 0 ]; then
	rmmod gpio_test_module
fi
insmod $DIR/gpio_test_module.ko
major=$(awk "\$2==\"gpio\" {print \$1}" /proc/devices)
rm -f /dev/gpio
mknod /dev/gpio c $major 0

echo "<<<<<<<<<<<<<<<<<<insmod dma_test>>>>>>>>>>>>>>>>>>"
n=`lsmod | grep -c dma_test`
if [ $n != 0 ]; then
	rmmod dma_test
fi
insmod $DIR/dma_test.ko
major=$(awk "\$2==\"dma_test\" {print \$1}" /proc/devices)
rm -f /dev/dma_test
mknod /dev/dma_test c $major 0

echo "<<<<<<<<<<<<<<<<<<insmod dma_test_single>>>>>>>>>>>"
n=`lsmod | grep -c dma_test_single`
if [ $n != 0 ]; then
	rmmod dma_test_single
fi
insmod $DIR/dma_test_single.ko
major=$(awk "\$2==\"dma_test_single\" {print \$1}" /proc/devices)
rm -f /dev/dma_test_single
mknod /dev/dma_test_single c $major 0

echo "<<<<<<<<<<<<<<<<<<mknod rtc>>>>>>>>>>>>>>>>>>>>>>>>"
n=`cat /proc/devices | grep -c rtc`
if [ $n == 0 ]; then
	echo "Error : Please boot from zImage with Epson 8259 rtc selected"
	exit
fi
major=$(awk "\$2==\"rtc\" {print \$1}" /proc/devices)
echo $major
rm -f /dev/rtc
mknod /dev/rtc c $major 0

echo "<<<<<<<<<<<<<<<<<<insmod spi>>>>>>>>>>>"
if [ $1 == 0 ]; then
	SPI0=TEST_SPI0_spi0_test_module
	SPI1=TEST_SPI0_spi1_test_module
	SPI0_MAJOR=spi0Wrapper
	SPI1_MAJOR=spi
elif [ $1 == 1 ]; then
	SPI0=TEST_SPI1_spi0_test_module
	SPI1=TEST_SPI1_spi1_test_module
	SPI0_MAJOR=spi0
	SPI1_MAJOR=spi1Wrapper
else 
	SPI0=TEST_SPI_MS_spi0_test_module
	SPI1=TEST_SPI_MS_spi1_test_module
	SPI0_MAJOR=spi0Wrapper
	SPI1_MAJOR=spi1Wrapper
fi
n=`lsmod | grep -c $SPI0`
if [ $n != 0 ]; then
	rmmod $SPI0
fi
n=`lsmod | grep -c $SPI1`
if [ $n != 0 ]; then
	rmmod $SPI1
fi
insmod $DIR/$SPI0.ko
insmod $DIR/$SPI1.ko
major=$(awk "\$2==\"$SPI0_MAJOR\" {print \$1}" /proc/devices)
rm -f /dev/spi0
mknod /dev/spi0 c $major 0
major=$(awk "\$2==\"$SPI1_MAJOR\" {print \$1}" /proc/devices)
rm -f /dev/spi1
mknod /dev/spi1 c $major 1
