﻿/*
 *  arch/arm/mach-emxx/phyadr/phyadr_drv.h
 *  phyadr_drv interface
 *
 *  Copyright 2011 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */

#ifndef __PHYADR_DRV_H
#define __PHYADR_DRV_H

#include <linux/ioctl.h>

#define PHYADR_NAME     "phyadr_drv"

#define PHYADR_IOCWRITE    _IO('k', 0)
#define PHYADR_IOCREAD     _IO('k', 1)
#define PHYADR_IOCDUMP     _IO('k', 2)
#define PHYADR_IOCMALLOC   _IO('k', 3)
#define PHYADR_IOCFREE     _IO('k', 4)

#ifdef CONFIG_SNSC_HSS
#define PHYADR_HSS_NODE_NAME "phyadr_hss_node_name"
#define PHYADR_HSS_NODE_PARENT NULL
#endif  /* #ifdef CONFIG_SNSC_HSS */

/*
 * @brief Phyadr driver commad struct
 */
struct stPhyadr_drv_cmd {
    unsigned long address;
    unsigned long value;
    unsigned long mask;
    unsigned long length;
    unsigned char* buf;
};

#define PHYADR_CMD_INFO struct stPhyadr_drv_cmd


#endif
