
/*
 *  File Name       : linux/arch/arm/mach-emxx/pm_pmu.c
 *  Function        : pm_pmu
 *  Release Version : Ver 1.00i
 *  Release Date    : 2010/08/20
 *
 *  Copyright (c) 2010 Renesas Electronics Corporation
 *
 *
 *  This program is free software;you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by Free
 *  Softwere Foundation; either version 2 of License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warrnty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; If not, write to the Free Software Foundation, Inc., 59
 *  Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

char const pmu_version[] =
		"PMU sequencer ver1.00i and Compiled "__DATE__" "__TIME__"";
#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/pm.h>
#include <linux/delay.h>
#include <linux/jiffies.h>

#include <linux/irq.h>
#include <mach/pmu.h>
#include <mach/pwc.h>
#include <mach/smu.h>
#include <mach/pm.h>
#include <mach/timer.h>
#include <asm/cacheflush.h>
#include <asm/hardware/gic.h>
#include <asm/hardware/cache-l2x0.h>

#include "pm_pmu.h"
#include "timer.h"

#include <mach/spi.h>

/* PM flags */
/*  if use Android userland then you *not* define "PM_USE_TIMER".
 *  if want to use rtc timer at standard linux userland then
 *  need *not* define "CONFIG_EMXX_ANDROID".
 */
#define PM_CONTROL_MODE	1	/* 1: lowpower, 0: SPI */
/* #define PM_USE_TIMER */

#ifdef PM_USE_TIMER
#define PM_RESUME_SEC	5	/* max : rtc<=59, ti2<=0x1ffff */
#endif


/* flag for debug */
/* #define IDLE_DEBUG_LOG */
/* #define IDLE_DEBUG_TW1_WAKEUP */
/* #define DEBUG_LED */
/* #define PM_DEBUG */


#if defined(IDLE_DEBUG_LOG) || defined(PM_DEBUG)
#define DPRINTK(format, args...) printk(KERN_INFO "PMU_DEBUG: " format, ##args)
#else
#define DPRINTK(format, args...)
#endif

#ifdef PM_DEBUG
static unsigned int pm_try_count;
static unsigned int pmu_count;
#endif

static int iLowPowerFlag;

#ifdef IDLE_DEBUG_TW1_WAKEUP
static void tw1_test_wakeup(void)
{
	disable_irq(INT_WDT1);

	/* enable GCLK for WDT1 */
	outl(0x00000001, SMU_TW0GCLKCTRL);
	/* WDT1 cancel reset */
	outl(0x00000001, SMU_TW0_RSTCTRL);

	/* WDT1:11.4688MHz (=PLL3(229.376MHz)/20) */
	outl(0x0000ffff, IO_ADDRESS(EMXX_WDT1_BASE) + 0x8);   /* 5sec */
	outl(7, IO_ADDRESS(EMXX_WDT1_BASE));	/* set TO_EN/TSTART/TM_EN */

	enable_irq(INT_WDT1);
	return;

}
#endif

static struct register_state_t reg_state;

static unsigned int wdt_op_reg;

#define WDT_OP IO_ADDRESS(EMXX_WDT0_BASE)

/*
 * INT mask and unmask
 *
 */
int pmu_int_mask(int mask)
{
	struct intc_state *state = &reg_state.intc;
	unsigned int max_irq, i;

	max_irq = (INT_LAST + 1);
	switch (mask) {
	case PMU_INT_MASK_SAVE_AND_MASK:
		DPRINTK("mask = PMU_INT_MASK_SAVE_AND_MASK\n");

		/* save all interrupt of INTA_DIST(32-) */
		state->dist_ien1 = readl(GIC_032_IEN);		/* 32-63 */
		state->dist_ien2 = readl(GIC_064_IEN);		/* 64-95 */
		state->dist_ien3 = readl(GIC_096_IEN);		/* 96-127 */
		state->dist_ien4 = readl(GIC_128_IEN);		/* 128-159 */
		state->dist_ien5 = readl(GIC_160_IEN);		/* 160-191 */

		/* disable all interrupts of INTA_DIST(32-) */
		for (i = 32; i < max_irq; i += 32)
			writel(MASK_INT_ALL, GIC_000_IDS + i * 4 / 32);

		if (emxx_sleep_while_idle) {
			/* enable resume int(GPIO0), PDMA
			   and PCM0(SIO1) bit */
			writel(PCM0_INT_BIT, GIC_032_IEN);
			writel(RESUME_INT_1|PDMA_INT_BIT, GIC_096_IEN);
		} else {
#ifndef IDLE_DEBUG_TW1_WAKEUP
			writel(RESUME_INT_1, GIC_096_IEN);
#else
			writel(TW1_INT_BIT, GIC_064_IEN);
			writel(RESUME_INT_1, GIC_096_IEN);
#endif
		}
		/* set sec int, include MEMC, ABx and AFS */
		writel(SEC_ERR_INT, GIC_160_IEN);

		break;
	case PMU_INT_MASK_RESTORE:
		/* disable all interrupts of INTA_DIST(from 32 to INT_LAST) */
		for (i = 32; i < max_irq; i += 32)
			writel(MASK_INT_ALL, GIC_000_IDS + i * 4 / 32);

		/* restore INTA_DIST(32-) */
		writel(state->dist_ien1, GIC_032_IEN);
		writel(state->dist_ien2, GIC_064_IEN);
		writel(state->dist_ien3, GIC_096_IEN);
		writel(state->dist_ien4, GIC_128_IEN);
		writel(state->dist_ien5, GIC_160_IEN);
		break;
	case PMU_INT_ALLMASK:
		/* Disable all interrupts. */
		for (i = 0; i < max_irq; i += 32)
			writel(MASK_INT_ALL, GIC_000_IDS + i * 4 / 32);

		break;
	default:
		return -EINVAL;
	}

	return 0;
}

/*
 * GPIO mask and unmask
 *
 */
static int pmu_gpio_mask(int flag)
{
	struct gpio_state *gpio = &reg_state.gpio;
	struct pwc_state *pwc = &reg_state.pwc;

	/* GPIO/PowerIC_GPIO Interrupt Enable/Disable */
	switch (flag) {
	case EMXX_PMU_CLK_FULLSPEED:
		/* mask all gpio interrupt */
		outl(MASK_GPIO_ALL, GIO_000_IDS);
		outl(MASK_GPIO_ALL, GIO_032_IDS);
		outl(MASK_GPIO_ALL, GIO_064_IDS);
		outl(MASK_GPIO_ALL, GIO_096_IDS);
		outl(MASK_GPIO_ALL, GIO_128_IDS);
		/* restore all gpio interrupt */
		outl(gpio->ien0, GIO_000_IEN);
		outl(gpio->ien1, GIO_032_IEN);
		outl(gpio->ien2, GIO_064_IEN);
		outl(gpio->ien3, GIO_096_IEN);
		outl(gpio->ien4, GIO_128_IEN);

		pwc_reg_write(DA9052_IRQMASKA_REG, pwc->mask_a);
		pwc_reg_write(DA9052_IRQMASKB_REG, pwc->mask_b);
		pwc_reg_write(DA9052_IRQMASKC_REG, pwc->mask_c);
		pwc_reg_write(DA9052_IRQMASKD_REG, pwc->mask_d);

		break;
	case EMXX_PMU_CLK_SLEEP:
	case EMXX_PMU_CLK_DEEPSLEEP:
		/* read all gpio interrupt */
		gpio->ien0 = inl(GIO_000_IIM);
		gpio->ien1 = inl(GIO_032_IIM);
		gpio->ien2 = inl(GIO_064_IIM);
		gpio->ien3 = inl(GIO_096_IIM);
		gpio->ien4 = inl(GIO_128_IIM);

		/* mask all gpio interrupt */
		outl(MASK_GPIO_ALL, GIO_000_IDS);
		outl(MASK_GPIO_ALL, GIO_032_IDS);
		outl(MASK_GPIO_ALL, GIO_064_IDS);
		outl(MASK_GPIO_ALL, GIO_096_IDS);
		outl(MASK_GPIO_ALL, GIO_128_IDS);

		/* unmask PMIC to GPIO interrupt(GPIO00) */
		outl(GPIO_INT_PWRIC, GIO_000_IEN);

		/* read pmic interrupt */
		pwc_reg_read(DA9052_IRQMASKA_REG, &pwc->mask_a);
		pwc_reg_read(DA9052_IRQMASKB_REG, &pwc->mask_b);
		pwc_reg_read(DA9052_IRQMASKC_REG, &pwc->mask_c);
		pwc_reg_read(DA9052_IRQMASKD_REG, &pwc->mask_d);
		/* mask all pmic interrupt */
		pwc_reg_write(DA9052_IRQMASKA_REG, 0xff);	/* 10 */
		pwc_reg_write(DA9052_IRQMASKB_REG, 0xff);	/* 11 */
		pwc_reg_write(DA9052_IRQMASKC_REG, 0xff);	/* 12 */
		pwc_reg_write(DA9052_IRQMASKD_REG, 0xff);	/* 13 */

		/* Clear all pmic interrupt flag */
		pwc_reg_write(DA9052_EVENTA_REG, 0xff);		/* 5 */
		pwc_reg_write(DA9052_EVENTB_REG, 0xff);		/* 6 */
		pwc_reg_write(DA9052_EVENTC_REG, 0xff);		/* 7 */
		pwc_reg_write(DA9052_EVENTD_REG, 0xff);

		break;
	case EMXX_PMU_CLK_POWEROFF:
		/* mask all gpio interrupt */
		outl(MASK_GPIO_ALL, GIO_000_IDS);
		outl(MASK_GPIO_ALL, GIO_032_IDS);
		outl(MASK_GPIO_ALL, GIO_064_IDS);
		outl(MASK_GPIO_ALL, GIO_096_IDS);
		outl(MASK_GPIO_ALL, GIO_128_IDS);

		/* mask all pmic interrupt */
		pwc_write(DA9052_IRQMASKA_REG, 0xff, 0xff);
		pwc_write(DA9052_IRQMASKB_REG, 0xff, 0xff);
		pwc_write(DA9052_IRQMASKC_REG, 0xff, 0xff);
		pwc_write(DA9052_IRQMASKD_REG, 0xff, 0xff);
		break;
	default:
		return -EINVAL;
	}
	return 0;
}

/*
 * Set PMU Command Sequence
 *  - lowpwer_flag
 *    1: lowpoer, 0: SPI
 */
static void pmu_set_command_sequence(unsigned int sleep_flag, int lowpower_flag)
{
	unsigned tmp_pc;
	unsigned int *pmu_cmd_adr;
	int l2_off_flag = 1;	/* 1:exec OFF/ON, 0: not exec */
	unsigned int spi0_back_addr;
	unsigned int vdd_back_addr;

	unsigned int value;

	if (!((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_DEEPSLEEP))
		l2_off_flag = 0;

	/*********************************************************************/
	/* PMU_PC_MAIN(Normal to Economy)                                    */
	/*********************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_MAIN);

/* 1000 */	PCMD_INT_MASK(PMU_INT_MASK);
		if (l2_off_flag) {
			/* 1004 */
			PCMD_SUBROUTINE_START(PMU_PC_SUB_L2OFF); /* L2RAM OFF */
		} else {
			/* 1004 */
			PCMD_NOP();
		}
		/* 0x1008: here is return position */
/* 1008 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_POWER_STATUS, PMU_REGB);
/* 100C */	PCMD_REG_WRITE2(PMU_MACRO, PMU_RAM_SMU_POWERSTATUS, PMU_REGB);
/* 1010 */	PCMD_SUBROUTINE_START(PMU_PC_SUB_SWOFF0); /* PowerSW OFF #0 */
/* 1014 */	PCMD_SUBROUTINE_START(PMU_PC_SUB_SWOFF1); /* PowerSw OFF #1 */
		/* Economy Mode */
/* 1018 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_CLK_MODE_SEL, 0x0005);
/* 1020 */	PCMD_NOP();
/* 1024 */	PCMD_SMU_READY_WAIT(PMU_HIGH_LEVEL);

	/* jump to Economy/Sleep/DeepSleep */
	switch (sleep_flag & EMXX_PMU_CLK_MASK) {
	case EMXX_PMU_CLK_ECONOMY:
		PCMD_AJUMP(PMU_PC_ECONOMY);
		break;
	case EMXX_PMU_CLK_SLEEP:
		PCMD_AJUMP(PMU_PC_SLEEP);
		break;
	case EMXX_PMU_CLK_DEEPSLEEP:
		PCMD_AJUMP(PMU_PC_DEEP);
		break;
#if 0
	case EMXX_PMU_CLK_POWEROFF:
		PCMD_AJUMP(PMU_PC_POWEROFF);
		break;
#endif
	default:
		PCMD_AJUMP(PMU_PC_ON1);
		break;
	}

	/****************************************************************/
	/* PMU_PC_ECONOMY						*/
	/* Use mode: Economy.						*/
	/****************************************************************/
	if ((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_ECONOMY) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_ECONOMY);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL1CTRL1, 0x00FF);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL2CTRL1, 0x00FF);
		PCMD_WDT_STOP();
		PCMD_TRIG_WAIT(1, PMU_TRIG_INT | PMU_TRIG_P1WAKEUP_HIGH);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL1CTRL1, 0x0000);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL2CTRL1, 0x0000);
		PCMD_WDT_RESTART();
		PCMD_AJUMP(PMU_PC_ON1);
	}

	/****************************************************************/
	/* PMU_PC_SLEEP							*/
	/* Use mode: Sleep						*/
	/****************************************************************/
	if ((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_SLEEP) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SLEEP);

		PCMD_TRIG_WAIT(1, PMU_TRIG_INT
		 | PMU_TRIG_P1WAKEUP_LOW | PMU_TRIG_P1WAKEUP_HIGH);
		PCMD_AND(0x00000038, PMU_REGA);
		PCMD_CMP2(0x00000008, PMU_REGA);
		PCMD_BRANCH(PMU_PC_ON1, PMU_BNE);		/* 0x1200 */
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL1CTRL1, 0x00FF);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL2CTRL1, 0x00FF);
		PCMD_SUBROUTINE_START(PMU_PC_SUB_SWOFF2);	/* 0x1400 */
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_CLK_MODE_SEL, 0x00000007);
								/* SleepMode */
		PCMD_NOP();
		PCMD_SMU_READY_WAIT(PMU_HIGH_LEVEL);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL3CTRL1, 0x000000FF);
		PCMD_WDT_STOP();
		PCMD_TRIG_WAIT(1, PMU_TRIG_INT | PMU_TRIG_P1WAKEUP_HIGH);
		PCMD_WDT_RESTART();
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL3CTRL1, 0x00000000);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_CLK_MODE_SEL, 0x00000005);
								/* EcoMode */
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL1CTRL1, 0x0000);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL2CTRL1, 0x0000);
		PCMD_SMU_READY_WAIT(PMU_HIGH_LEVEL);
		PCMD_AJUMP(PMU_PC_ON1);
	}

	/****************************************************************/
	/* PMU_PC_DEEP							*/
	/* Use mode: DeepSleep						*/
	/****************************************************************/
	if ((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_DEEPSLEEP) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_DEEP);

/* 1100 */	PCMD_TRIG_WAIT(1, PMU_TRIG_INT
		 | PMU_TRIG_P1WAKEUP_LOW | PMU_TRIG_P1WAKEUP_HIGH);
/* 1104 */	PCMD_AND(0x00000038, PMU_REGA);
/* 110C */	PCMD_CMP2(0x00000008, PMU_REGA);
/* 1114 */	PCMD_BRANCH(PMU_PC_ON1, PMU_BNE);		/* to 0x1200 */
/* 1118 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL1CTRL1, 0x00FF);
/* 1120 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL2CTRL1, 0x00FF);
		/* PowerDown by SPI. if setting is LOWPWR then change to "NOP"*/
		vdd_back_addr = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_AJUMP_SIZE;
		if (lowpower_flag) {
			/* to 0x2400 */
/* 1128 */		PCMD_AJUMP(PMU_PC_SUB_VDD_LPW);
		} else {
			/* to 0x1F00 */
/* 1128 */		PCMD_AJUMP(PMU_PC_SUB_VDD_SPI);
		}
/* 112C */	PCMD_SUBROUTINE_START(PMU_PC_SUB_SWOFF2);	/* to 0x1400 */
/* 1130 */	PCMD_SUBROUTINE_START(PMU_PC_SUB_SWOFF3);	/* to 0x14A0 */
/* 1134 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_AUTO_MODE_EN, 0x00000021);
/* 113C */	PCMD_WDT_STOP();
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 1140 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 1144 */	PCMD_AND(0x00000FFF, PMU_REGB);
/* 114C */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 1154 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x1140 */
/* 1158 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_CLK_MODE_SEL, 0x00000008);
/* 1160 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_OSC0CTRL1, 0x000000FF);
/* 1168 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_OSC1CTRL1, 0x000000FF);
		if (lowpower_flag) {
			/* case lowpower */
/* 1170 */		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_INTAGCLKCTRL,
			 0x00000000);
		} else {
			/* case spi */
/* 1170 */		PCMD_NOP();
		}
/* 1178 */	PCMD_SMU_READY_WAIT(PMU_HIGH_LEVEL);
/* 117C */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL3CTRL1, 0x000000FF);
/* 1184 */	PCMD_AJUMP(PMU_PC_PWRCNT);
	}

	/****************************************************************/
	/* PMU_PC_PWRCNT						*/
	/* Use mode: DeepSleep						*/
	/****************************************************************/
	if ((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_DEEPSLEEP) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_PWRCNT);
		if (lowpower_flag) {
			/* case lowpower */
/* 0100 */		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_LOWPWR, 0x00000001);
/* 0108 */		PCMD_CYCLE_WAIT(0x0F, PMU_WAIT_INT_CONTINUE);
/* 010C */		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_INTAGCLKCTRL,
			 0x00000007);
		} else {
			/* case SPI power down. */
/* 0100 */		PCMD_NOP();
/* 0104 */		PCMD_NOP();
/* 0108 */		PCMD_NOP();
/* 010C */		PCMD_NOP();
/* 0110 */		PCMD_NOP();
		}
/* 0114 */	PCMD_TRIG_WAIT(1, PMU_TRIG_INT | PMU_TRIG_P1WAKEUP_HIGH
		 | PMU_INT_MASK);
/* 0118 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_AUTO_MODE_EN, 0x00000001);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_OSC1CTRL1, 0x0000);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL2CTRL1, 0x0000);
		PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PLL1CTRL1, 0x0000);
		PCMD_SMU_READY_WAIT(PMU_HIGH_LEVEL);
		PCMD_AJUMP(PMU_PC_PWRCNT2);
	}

	/****************************************************************/
	/* PMU_PC_PWRCNT2						*/
	/* Use mode: DeepSleep						*/
	/****************************************************************/
	if ((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_DEEPSLEEP) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_PWRCNT2);
		PCMD_WDT_RESTART();
		PCMD_AJUMP(PMU_PC_ON1);
	}


	/****************************************************************/
	/* PMU_PC_ON1							*/
	/* Use mode: All						*/
	/****************************************************************/
	/* 1200 */
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_ON1);
	tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
	PCMD_AND(0x00000FFF, PMU_REGB);
	PCMD_CMP2(0x00000000, PMU_REGB);
	PCMD_BRANCH(tmp_pc, PMU_BNE);		/* to 0x1200 */
	PCMD_SUBROUTINE_START(PMU_PC_SUB_SETPARA);	/* to 0x1A00 */
	if (l2_off_flag) {
		PCMD_SUBROUTINE_START(PMU_PC_SUB_L2ON);	/* to 0x1D70 */
	} else {
		/* macro use "{}"*/
		PCMD_NOP();
	}
	if (((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_DEEPSLEEP)) {
		PCMD_SUBROUTINE_START(PMU_PC_SUB_SWON3);/* to 0x1800 */
	} else {
		/* economy, sleep */
		PCMD_NOP();
	}
	if (((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_ECONOMY)) {
		/* economy */
		PCMD_NOP();
	} else {
		PCMD_SUBROUTINE_START(PMU_PC_SUB_SWON2);	/* to 0x1750 */
	}
	PCMD_SUBROUTINE_START(PMU_PC_SUB_SWON1);	/* to 0x1700 */
	PCMD_SUBROUTINE_START(PMU_PC_SUB_SWON0);	/* to 0x1500 */
	if ((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_DEEPSLEEP) {
		/* to 0x1850 */
		spi0_back_addr = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_AJUMP_SIZE;
		PCMD_AJUMP(PMU_PC_SUB_SPI0);
	} else {
		/* macro use "{}"*/
		PCMD_NOP();
	}
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_MEMC_HAND_SHAKE_FAKE, 0x00000000);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_CLK_MODE_SEL, 0x00000001);
	PCMD_NOP();
	PCMD_SMU_READY_WAIT(PMU_HIGH_LEVEL);
	PCMD_WDT_STOP();
	PCMD_TRIG_WAIT(1, PMU_TRIG_INT | PMU_TRIG_P1WAKEUP_LOW);
	PCMD_WDT_RESTART();
	PCMD_AND(0x00000038, PMU_REGA);
	PCMD_CMP2(0x00000008, PMU_REGA);
	PCMD_BRANCH(0x1004, PMU_BEQ);	/* 0x1004@PMU_PC_MAIN*/

	/* [BIT0] 0: async, 1: sync */
	if (!(readl(SMU_CPUCLK_SYNCSET) & 0x01)) {
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
		PCMD_REG_READ(SMU_MACRO, SMU_CMD_PLL_STATUS, PMU_REGB);
		PCMD_AND(0x00000001, PMU_REGB)
		PCMD_CMP2(0x00000001, PMU_REGB);
		PCMD_BRANCH(tmp_pc, PMU_BNE);
	}
	PCMD_AJUMP(PMU_PC_ON2);		/* to 0x12C0 */

	/****************************************************************/
	/* PMU_PC_ON2							*/
	/* Use mode: All						*/
	/****************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_ON2);

/* 12C0 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PMU_INTCTRL, 0x00000001);
/* 12C8 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PMU_INTCTRL, 0x00000000);
/* 12D0 */	PCMD_PMU_END();

	/****************************************************************/
	/* PMU_PC_SUB_SWOFF0						*/
	/* Use mode: All						*/
	/****************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SWOFF0);
#if 0
/* 1300 */	PCMD_RMW(SMU_MACRO, SMU_CMD_PD_SWON, 0x00000000, 0x00000001);
#else
		PCMD_NOP();
		PCMD_NOP();
		PCMD_NOP();
#endif
/* 130C */	PCMD_RMW(SMU_MACRO, SMU_CMD_PV_SWON, 0x00000000, 0x00000001);
/* 1318 */	PCMD_RMW(SMU_MACRO, SMU_CMD_PR_SWON, 0x00000000, 0x00000001);
/* 1324 */	PCMD_RMW(SMU_MACRO, SMU_CMD_PG_SWON, 0x00000000, 0x00000001);
/* 1330 */	PCMD_RMW(SMU_MACRO, SMU_CMD_P2_SWON, 0x00000000, 0x00000001);
/* 133C */	PCMD_RMW(SMU_MACRO, SMU_CMD_PU_SWON, 0x00000000, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 1348 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 134C */	PCMD_AND(0x000007E0, PMU_REGB);
/* 1354 */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 135C */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x1348 */
/* 1360 */	PCMD_RFS();


	/****************************************************************/
	/* PMU_PC_SUB_SWOFF1						*/
	/* Use mode: All						*/
	/****************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SWOFF1);

/* 13A0 */	PCMD_RMW(SMU_MACRO, SMU_CMD_P1_SWON, 0x00000000, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 13AC */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 13B0 */	PCMD_AND(0x00000010, PMU_REGB);
/* 13B8 */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 13C0 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x13AC */
/* 13C4 */	PCMD_RFS();


	/****************************************************************/
	/* PMU_PC_SUB_SWOFF2						*/
	/* Use mode: Sleep, DeepSleep					*/
	/****************************************************************/
	if (!((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_ECONOMY)) {

		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SWOFF2);
/* 1400 */	PCMD_REG_READ(MEMC_MACRO, MEMC_CMD_DDR_STATE8, PMU_REGB);
/* 1404 */	PCMD_AND(0x00000003, PMU_REGB);
/* 140C */	PCMD_CMP2(0x00000003, PMU_REGB);
/* 1414 */	PCMD_BRANCH(PMU_PC_SUB_SWOFF2, PMU_BNE);	/* to 0x1400 */
/* 1418 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_PM_SWON, PMU_REGB);
/* 141C */	PCMD_AND(0x00000100, PMU_REGB);
/* 1424 */	PCMD_CMP2(0x00000100, PMU_REGB);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_BRANCH_SIZE
			+ PCMD_AJUMP_SIZE;
/* 142C */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x1434 */
/* 1430 */	PCMD_NOP();
/* 1434 */	PCMD_RMW(SMU_MACRO, SMU_CMD_PM_SWON, 0x00000000, 0x00000001);
/* 1440 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_MEMC_HAND_SHAKE_FAKE,
		 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 1448 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 144C */	PCMD_AND(0x00000004, PMU_REGB);
/* 1454 */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 145C */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x1448 */
/* 1460 */	PCMD_RMW(SMU_MACRO, SMU_CMD_PL_SWON, 0x00000000, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 146C */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 1470 */	PCMD_AND(0x00000008, PMU_REGB);
/* 1478 */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 1480 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x146C */
/* 1484 */	PCMD_RFS();
	}


	/****************************************************************/
	/* PMU_PC_SUB_SWOFF3						*/
	/* Use mode: Sleep, DeepSleep					*/
	/****************************************************************/
	if (!((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_ECONOMY)) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SWOFF3);

		PCMD_RMW(SMU_MACRO, SMU_CMD_P0_SWON, 0x00000000, 0x00000001);
		PCMD_RFS();
	}

	/****************************************************************/
	/* PMU_PC_SUB_SWON0						*/
	/* Use mode: All						*/
	/****************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SWON0);

/* 1500 */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_SMU_POWERSTATUS, PMU_REGB);
/* 1504 */	PCMD_AND(0x00003000, PMU_REGB);
/* 150C */	PCMD_CMP2(0x00000000, PMU_REGB);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_BRANCH_SIZE
			+ PCMD_RMW_SIZE
			+ PCMD_REG_READ_SIZE
			+ PCMD_AND_SIZE
			+ PCMD_CMP2_SIZE
			+ PCMD_BRANCH_SIZE;
/* 1514 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x153C */
/* 1518 */	PCMD_RMW(SMU_MACRO, SMU_CMD_PU_SWON, 0x00000001, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 1524 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 1528 */	PCMD_AND(0x00000040, PMU_REGB);
/* 1530 */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 1538 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x1524 */
/* 153C */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_SMU_POWERSTATUS, PMU_REGB);
/* 1540 */	PCMD_AND(0x0000C000, PMU_REGB);
/* 1548 */	PCMD_CMP2(0x00000000, PMU_REGB);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_BRANCH_SIZE
			+ PCMD_RMW_SIZE
			+ PCMD_REG_READ_SIZE
			+ PCMD_AND_SIZE
			+ PCMD_CMP2_SIZE
			+ PCMD_BRANCH_SIZE;
/* 1550 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x1578 */
/* 1554 */	PCMD_RMW(SMU_MACRO, SMU_CMD_P2_SWON, 0x00000001, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 1560 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 1564 */	PCMD_AND(0x00000080, PMU_REGB);
/* 156C */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 1574 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x1560 */
/* 1578 */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_SMU_POWERSTATUS, PMU_REGB);
/* 157C */	PCMD_AND(0x00030000, PMU_REGB);
/* 1584 */	PCMD_CMP2(0x00000000, PMU_REGB);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_BRANCH_SIZE
			+ PCMD_RMW_SIZE
			+ PCMD_REG_READ_SIZE
			+ PCMD_AND_SIZE
			+ PCMD_CMP2_SIZE
			+ PCMD_BRANCH_SIZE;
/* 158C */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x15B4 */
/* 1590 */	PCMD_RMW(SMU_MACRO, SMU_CMD_PG_SWON, 0x00000001, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 159C */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 15A0 */	PCMD_AND(0x00000100, PMU_REGB);
/* 15A8 */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 15B0 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x159C */
/* 15B4 */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_SMU_POWERSTATUS, PMU_REGB);
/* 15B8 */	PCMD_AND(0x00300000, PMU_REGB);
/* 15C0 */	PCMD_CMP2(0x00000000, PMU_REGB);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_BRANCH_SIZE
			+ PCMD_RMW_SIZE
			+ PCMD_REG_READ_SIZE
			+ PCMD_AND_SIZE
			+ PCMD_CMP2_SIZE
			+ PCMD_BRANCH_SIZE;
/* 15C8 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x15F0 */
/* 15CC */	PCMD_RMW(SMU_MACRO, SMU_CMD_PR_SWON, 0x00000001, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 15D8 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 15DC */	PCMD_AND(0x00000400, PMU_REGB);
/* 15E4 */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 15EC */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x15D8 */
/* 15F0 */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_SMU_POWERSTATUS, PMU_REGB);
/* 15F4 */	PCMD_AND(0x000C0000, PMU_REGB);
/* 15FC */	PCMD_CMP2(0x00000000, PMU_REGB);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_BRANCH_SIZE
			+ PCMD_RMW_SIZE
			+ PCMD_REG_READ_SIZE
			+ PCMD_AND_SIZE
			+ PCMD_CMP2_SIZE
			+ PCMD_BRANCH_SIZE;
/* 1604 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x162C */
/* 1608 */	PCMD_RMW(SMU_MACRO, SMU_CMD_PV_SWON, 0x00000001, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 1614 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 1618 */	PCMD_AND(0x00000200, PMU_REGB);
/* 1620 */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 1628 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x1614 */
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 162C */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_PLL_STATUS, PMU_REGB);
/* 1630 */	PCMD_AND(0x00000001, PMU_REGB);
/* 1638 */	PCMD_CMP2(0x00000001, PMU_REGB);
/* 1640 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x162C */

#if 0		/* for DSP */
/* 1644 */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_SMU_POWERSTATUS, PMU_REGB);
/* 1648 */	PCMD_AND(0x00000C00, PMU_REGB);
/* 1650 */	PCMD_CMP2(0x00000000, PMU_REGB);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_BRANCH_SIZE
			+ PCMD_RMW_SIZE
			+ PCMD_REG_READ_SIZE
			+ PCMD_AND_SIZE
			+ PCMD_CMP2_SIZE
			+ PCMD_BRANCH_SIZE;
/* 1658 */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x1680 */
/* 165C */	PCMD_RMW(SMU_MACRO, SMU_CMD_PD_SWON, 0x00000001, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
/* 1668 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
/* 166C */	PCMD_AND(0x00000020, PMU_REGB);
/* 1674 */	PCMD_CMP2(0x00000000, PMU_REGB);
/* 167C */	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* to 0x165C */
/* 1680 */	PCMD_RFS();
#else
/* 1644 */	PCMD_RFS();
#endif


	/****************************************************************/
	/* PMU_PC_SUB_SWON1						*/
	/* Use mode: All						*/
	/****************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SWON1);

	PCMD_RMW(SMU_MACRO, SMU_CMD_P1_SWON, 0x00000001, 0x00000001);
	tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
	PCMD_AND(0x00000010, PMU_REGB);
	PCMD_CMP2(0x00000000, PMU_REGB);
	PCMD_BRANCH(tmp_pc, PMU_BNE);	/* 0x170C@PMU_PC_SUB_SWON1 */
	PCMD_RFS();


	/****************************************************************/
	/* PMU_PC_SUB_SWON2						*/
	/* Use mode: All						*/
	/****************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SWON2);

	PCMD_RMW(SMU_MACRO, SMU_CMD_PL_SWON, 0x00000001, 0x00000001);
	tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
	PCMD_AND(0x00000008, PMU_REGB);
	PCMD_CMP2(0x00000000, PMU_REGB);
	PCMD_BRANCH(tmp_pc, PMU_BNE);		/* to 0x175C */
	PCMD_RMW(SMU_MACRO, SMU_CMD_PM_SWON, 0x00000001, 0x00000001);
	tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
	PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
	PCMD_AND(0x00000004, PMU_REGB);
	PCMD_CMP2(0x00000000, PMU_REGB);
	PCMD_BRANCH(tmp_pc, PMU_BNE);		/* to 0x1780 */
	PCMD_RFS();

	/****************************************************************/
	/* PMU_PC_SUB_SWON3						*/
	/* Use mode : Sleep, DeepSleep					*/
	/****************************************************************/
	if (!((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_ECONOMY)) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SWON3);

		PCMD_RMW(SMU_MACRO, SMU_CMD_P0_SWON, 0x00000001, 0x00000001);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr);
		PCMD_REG_READ(SMU_MACRO, SMU_CMD_SEQ_BUSY, PMU_REGB);
		PCMD_AND(0x00000001, PMU_REGB);
		PCMD_CMP2(0x00000000, PMU_REGB);
		PCMD_BRANCH(tmp_pc, PMU_BNE);		/* 0x180C */
		PCMD_RFS();
	}

	/****************************************************************/
	/* PMU_PC_SUB_SPI0						*/
	/* Use mode : All						*/
	/****************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SPI0);

/* 1850 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_P0_SWON, PMU_REGB);
/* 1854 */	PCMD_AND(0x00000100, PMU_REGB);
/* 185C */	PCMD_CMP2(0x00000100, PMU_REGB);
		tmp_pc = PMU_VIRADDR_TO_PC((unsigned int)pmu_cmd_adr)
			+ PCMD_BRANCH_SIZE
			+ PCMD_REG_WRITE_SIZE;
/* 1864 */	PCMD_BRANCH(tmp_pc, PMU_BNE);			/* to 0x1870 */
/* 1868 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_USAIS0_RSTCTRL, 0x00000003);
/* 1870 */	PCMD_SUBROUTINE_START(PMU_PC_SUB_SPI1);		/* to 0x1940 */
/* 1874 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_TX_DATA, 0x000058AA);
/* 187C */	PCMD_SP0_WRITE(SIO_CMD_SP0_CONTROL, 0x00000009);
/* 1884 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
		/* R64 : ex)1300mA : 0xF8 */
/* 188C */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_PWIC_ISET, PMU_REGB);
/* 1894 */	PCMD_EXOR(0x00008000, PMU_REGB);
/* 189C */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_TX_DATA, PMU_REGB);
/* 18A4 */	PCMD_SP0_WRITE(SIO_CMD_SP0_CONTROL, 0x00000009);
/* 18AC */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
		/* R62 : ex)1300mA : 0xDF */
/* 18B4 */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_PWIC_CHGBUCK, PMU_REGB);
/* 18BC */	PCMD_EXOR(0x00007C00, PMU_REGB);
/* 18C4 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_TX_DATA, PMU_REGB);
/* 18CC */	PCMD_SP0_WRITE(SIO_CMD_SP0_CONTROL, 0x00000009);
/* 18D4 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
		/* R46 : ex)1.3V : 0x60 */
/* 18DC */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_PWIC_BUCKCORE, PMU_REGB);
/* 18E4 */	PCMD_EXOR(0x00005C00, PMU_REGB);
/* 18EC */	PCMD_REG_WRITE2(SIO0_MACRO, SIO_CMD_SP0_TX_DATA, PMU_REGB);
/* 18F0 */	PCMD_SP0_WRITE(SIO_CMD_SP0_CONTROL, 0x00000009);
/* 18F8 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
		/* wait for change R44 */
/* 1900 */	PCMD_CYCLE_WAIT(0x35F, PMU_WAIT_INT_CONTINUE);
/* 1904 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_TX_DATA, 0x00007801);
/* 190C */	PCMD_SP0_WRITE(SIO_CMD_SP0_CONTROL, 0x00000009);
/* 1914 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
/* 191C */	PCMD_REG_WRITE(PMU_MACRO, PMU_RAM_RUNCHECK, 0x00000001);
/* 1924 */	PCMD_SUBROUTINE_START(PMU_PC_SUB_SPI2);		/* 0x1980 */
/* 1928 */	PCMD_TIMERWAIT(1, PMU_WAIT_INT_CONTINUE);
/* 192C */	PCMD_AJUMP(spi0_back_addr);	/* return to 0x1234(@F_ON) */

	/****************************************************************/
	/* PMU_PC_SUB_SPI1						*/
	/* Use mode : All						*/
	/****************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SPI1);

/* 1940 */	PCMD_REG_READ(SMU_MACRO, SMU_CMD_USIAS0GCLKCTRL, PMU_REGB);
/* 1944 */	PCMD_REG_WRITE2(PMU_MACRO, PMU_RAM_SMU_USIAS0GCLKCTRL,
		 PMU_REGB);
/* 1948 */	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_USIAS0GCLKCTRL, 0x00000007);
/* 1950 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
/* 1958 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_ENSET, 0x000000FF);
/* 1960 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_POL, 0x00007004);
/* 1968 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_MODE, 0x00000F04);
/* 1970 */	PCMD_RFS();

	/****************************************************************/
	/* PMU_PC_SUB_SPI2						*/
	/* Use mode : All						*/
	/****************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SPI2);

/* 1980 */	PCMD_REG_READ(PMU_MACRO, PMU_RAM_SMU_USIAS0GCLKCTRL,
		 PMU_REGB);
/* 1984 */	PCMD_REG_WRITE2(SMU_MACRO, SMU_CMD_USIAS0GCLKCTRL, PMU_REGB);
/* 1988 */	PCMD_RFS();

	/*********************************************************************/
	/* PMU_PC_SUB_SETPARA */
	/*********************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_SETPARA);

	value = 0x00000085;

	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_P0_PWSW_PARA, value);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PM_PWSW_PARA, value);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PL_PWSW_PARA, value);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_P1_PWSW_PARA, value);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PD_PWSW_PARA, value);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PU_PWSW_PARA, value);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_P2_PWSW_PARA, value);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PG_PWSW_PARA, value);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PR_PWSW_PARA, value);
	PCMD_REG_WRITE(SMU_MACRO, SMU_CMD_PV_PWSW_PARA, value);
	PCMD_RFS();

	/*********************************************************************/
	/* PMU_PC_SUB_L2OFF */
	/*********************************************************************/
	if (l2_off_flag) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_L2OFF);

	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_CTRL, 0x00000000, 0x00000004);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000080, 0x00000080);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000040, 0x00000040);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000020, 0x00000020);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000010, 0x00000010);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000008, 0x00000008);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000004, 0x00000004);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000002, 0x00000002);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000001, 0x00000001);
	    PCMD_RFS();
	}

	/*********************************************************************/
	/* PMU_PC_SUB_L2ON */
	/*********************************************************************/
	if (l2_off_flag) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_L2ON);

/* 1D70 */  PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000000, 0x00000001);
	    PCMD_CYCLE_WAIT(0x10, PMU_WAIT_INT_END);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000000, 0x00000002);
	    PCMD_CYCLE_WAIT(0x10, PMU_WAIT_INT_END);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000000, 0x00000004);
	    PCMD_CYCLE_WAIT(0x10, PMU_WAIT_INT_END);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000000, 0x00000008);
	    PCMD_CYCLE_WAIT(0x10, PMU_WAIT_INT_END);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000000, 0x00000010);
	    PCMD_CYCLE_WAIT(0x10, PMU_WAIT_INT_END);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000000, 0x00000020);
	    PCMD_CYCLE_WAIT(0x10, PMU_WAIT_INT_END);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000000, 0x00000040);
	    PCMD_CYCLE_WAIT(0x10, PMU_WAIT_INT_END);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_L2RAM, 0x00000000, 0x00000080);
	    PCMD_RMW(SMU_MACRO, SMU_CMD_CPU_PWSW_CTRL, 0x00000004, 0x00000004);
	    PCMD_RFS();
	}

	/*********************************************************************/
	/* PMU_PC_SUB_VDD_SPI */
	/*********************************************************************/
	pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_VDD_SPI);

/* 1F00 */	PCMD_SUBROUTINE_START(PMU_PC_SUB_SPI1);		/* to 0x1940 */
/* 1F04 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_TX_DATA, 0x00005898);
/* 1F0C */	PCMD_SP0_WRITE(SIO_CMD_SP0_CONTROL, 0x00000009);
/* 1F14 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
/* 1F1C */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_TX_DATA, 0x00005CCA);
/* 1F24 */	PCMD_SP0_WRITE(SIO_CMD_SP0_CONTROL, 0x00000009);
/* 1F2C */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
/* 1F34 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_TX_DATA, 0x00001E6D);
/* 1F3C */	PCMD_SP0_WRITE(SIO_CMD_SP0_CONTROL, 0x00000009);
/* 1F44 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
/* 1F4C */	PCMD_SUBROUTINE_START(PMU_PC_SUB_SPI2);		/* to 0x1980 */
/* 1F50 */	PCMD_AJUMP(vdd_back_addr);			/* to 0x112C */

	/****************************************************************/
	/* PMU_PC_SUB_VDD_LPW						*/
	/* Use mode: DeepSleep						*/
	/****************************************************************/
	if ((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_DEEPSLEEP) {
		pmu_cmd_adr = PMU_PC_TO_VIRADDR(PMU_PC_SUB_VDD_LPW);

/* 2400 */	PCMD_SUBROUTINE_START(PMU_PC_SUB_SPI1);		/* to 0x1940 */
/* 2404 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_TX_DATA, 0x00005898);
/* 240C	*/	PCMD_SP0_WRITE(SIO_CMD_SP0_CONTROL, 0x00000009);
/* 2414 */	PCMD_REG_WRITE(SIO0_MACRO, SIO_CMD_SP0_FFCLR, 0x000000FF);
/* 241C	*/	PCMD_SUBROUTINE_START(PMU_PC_SUB_SPI2);		/* to 0x1980 */
/* 2420 */	PCMD_AJUMP(vdd_back_addr);			/* to 0x112C */

	}


	return;
}





static void idle_seq(int lowpower_flag)
{
	if (lowpower_flag) {
#ifdef PM_USE_TIMER
		writel(0x00000000, SMU_TI2GCLKCTRL);  /* stop  clk */
		writel(0x00000000, SMU_TWI2TIN_SEL);  /* select PLL3 */
		writel(0x00000001, SMU_TI2GCLKCTRL);  /* suply clk */
		writel(0x00000002, TI2_CLR);
		writel(0x00000000, TI2_OP);
		writel(0x00000000, SMU_TI2GCLKCTRL);  /* stop  clk */
		writel(0x00000002, SMU_TWI2TIN_SEL);  /* select 32k */
		writel(0x00000001, SMU_TI2GCLKCTRL);  /* suply clk */
#endif
		/* INT set(sec) */
		writel(0x00000001, PMU_INTFFCLR_M);
		writel(0x00000003, PMU_INTFFCLR_A);
		writel(0x00000001, PMU_INTENSET_M);
		writel(0x00000003, PMU_INTENSET_A);
	}
	writel(0x00040B04, SMU_P1_RFF_PARA1);

	outl(PMU_PC_MAIN, PMU_PC);		/* 1000 */
	outl(PMU_PC_ON2, PMU_POWER_ON_PC);	/* 12C0 */
	outl(PMU_PC_ON2, PMU_INT_HANDLER_PC);

	outl(PMU_WDT_ENABLE, PMU_WDT_COUNT_EN);
	outl(PMU_WDT_MAX_COUNT, PMU_WDT_COUNT_LMT);

	return;
}


static void pw_ic_lowpower(void)
{
	pwc_reg_write(DA9052_GPIO0809_REG, 0x08);	/* 25 */
	pwc_reg_write(DA9052_ID01_REG, 0x90);		/* 29 */
	pwc_reg_write(DA9052_BUCKCORE_REG, 0xCA);	/* 46 */
	pwc_reg_write(DA9052_BUCKMEM_REG, 0xE3);	/* 48 */
	pwc_reg_write(DA9052_BUCKPERI_REG, 0xDB);	/* 49 */
	pwc_reg_write(DA9052_LDO2_REG, 0xD4);		/* 51 */
	pwc_reg_write(DA9052_LDO3_REG, 0xFF);		/* 52 */
	pwc_reg_write(DA9052_LDO4_REG, 0xED);		/* 53 */
	pwc_reg_write(DA9052_LDO6_REG, 0xC6);		/* 55 */
	pwc_reg_write(DA9052_LFO7_REG, 0xE1);		/* 56 */
	pwc_reg_write(DA9052_LDO8_REG, 0xE1);		/* 57 */
	pwc_reg_write(DA9052_LDO9_REG, 0xD9);		/* 58 */
	pwc_reg_write(DA9052_LDO10_REG, 0xCC);		/* 59 */
	pwc_reg_write(DA9052_BUCKB_REG, 0x88);		/* 45 */
	pwc_reg_write(DA9052_PDDIS_REG, 0x00);		/* 18 */
	pwc_reg_write(DA9052_SEQTIMER_REG, 0x11);	/* 43 */

	pwc_reg_write(DA9052_CONTROLC_REG, 0x60);	/* 16 */


	/* SMU VDD Wait Setting */
	writel(0x147, SMU_PLLVDDWAIT);
}


static void pw_ic_spi(void)
{
	/* setup for deepsleep */
	pwc_reg_write(DA9052_ID01_REG, 0x90);		/* 29 */
	pwc_reg_write(DA9052_BUCKCORE_REG, 0xCA);	/* 46 */
	pwc_reg_write(DA9052_BUCKB_REG, 0x88);		/* 45 */
	pwc_reg_write(DA9052_PDDIS_REG, 0x40);		/* 18 */
	pwc_reg_write(DA9052_SEQTIMER_REG, 0xC1);
	/* for DA9052 auto wake. */
	pwc_reg_write(DA9052_GPIO0809_REG, 0x11);	/* 25 */
}


/* alarm_delay */
/* only set seconds. max is 59 */
/* alarm event will happen after set seconds */
/* if modify control then can more long time */
#ifdef PM_USE_TIMER
static void rtc_sec(unsigned int alarm_delay)
{
	/*--------------------------------------------------------------*/
	/* warning : DA9052's default is all unmasks.			*/
	/*	     if anyone High raw then nIRQ=LOW			*/

	/* DA9052 all masks */
	pwc_reg_write(DA9052_IRQMASKA_REG, 0xff);	/* 10 */
	pwc_reg_write(DA9052_IRQMASKB_REG, 0xff);	/* 11 */
	pwc_reg_write(DA9052_IRQMASKC_REG, 0xff);	/* 12 */
	pwc_reg_write(DA9052_IRQMASKD_REG, 0xff);	/* 13 */

	/* clear irq */
	pwc_reg_write(DA9052_EVENTA_REG, 0xff);		/* 5 */
	pwc_reg_write(DA9052_EVENTB_REG, 0xff);		/* 6 */
	pwc_reg_write(DA9052_EVENTC_REG, 0xff);		/* 7 */
	pwc_reg_write(DA9052_EVENTD_REG, 0xff);		/* 8 */

	/* need wait clear irq. */
	udelay(1000);					/* 1ms wait */

	/*DA9052 only can set minute. therefore rtc value set '60-value' */
	pwc_reg_write(DA9052_COUNTS_REG, 60 - alarm_delay);
	pwc_reg_write(DA9052_COUNTMI_REG, 0x00);
	pwc_reg_write(DA9052_COUNTH_REG, 0x00);
	pwc_reg_write(DA9052_COUNTD_REG, 0x01);
	pwc_reg_write(DA9052_COUNTMO_REG, 0x01);
	pwc_reg_write(DA9052_COUNTY_REG, 0x00);

	/* b6 ALARM_TYPE=1 alarm event caused by timer alarm */
	pwc_reg_write(DA9052_ALARMMI_REG, 0x01 | 0x40);		/* 117 */
	pwc_reg_write(DA9052_ALARMH_REG, 0x00);			/* 118 */
	pwc_reg_write(DA9052_ALARMD_REG, 0x01);			/* 119 */
	pwc_reg_write(DA9052_ALARMMO_REG, 0x01);		/* 120 */
	/* b7 TICK_ON=0  tick function is disabled */
	/* b6 ALARM_ON=1 alarm enabled             */
	pwc_reg_write(DA9052_ALARMY_REG, 0x00 | 0x40);		/* 121 */

	/* GIO in unmask */
	writel((readl(CHG_GIOMASK000) | 0x00000001), CHG_GIOMASK000);

	/* GPIO0 set in */
	writel(0x00000001, GIO_000_E0);
	/* GPIO0 irq mode setting  downedge */
	/*  -- DA9052 is Active Low */
	writel(0x00000009, GIO_000_IDT0);
	/* GPIO0 clear raw - clear is write '1' */
	writel(0x00000001, GIO_000_IIR);
	/* GPIO0 inport set irq mode */
	writel(0x00000001, GIO_000_IIA);
	/* GPIO0 inport irq enable */
	writel(0x00000001, GIO_000_IEN);

}
#endif

static void pw_ic_mask(int sleep_flag, int lowpower_flag)
{
	switch (sleep_flag) {
	case EMXX_PMU_CLK_SLEEP:
	case EMXX_PMU_CLK_DEEPSLEEP:
		/* case: enable-key */
		/* key -> io_exp -> DA9052:GPIO0 */
		if (lowpower_flag) {
			/* lowpwr */
			pwc_reg_write(DA9052_GPIO0001_REG, 0x81);	/* 21 */
		} else {
			/* spi */
			pwc_reg_write(DA9052_GPIO0001_REG, 0x89);	/* 21 */
		}

		/* DA9052 irq unmask */
		/* IO expander0 lines to GPIO0 of DA9052 */
		pwc_write(DA9052_IRQMASKC_REG, 0x00, MASK_KEY_INT);	/* 12 */
		/* enable pen down(LCD panel) */
		pwc_write(DA9052_IRQMASKB_REG, 0x00, MASK_PEN_DOWN_INT);/* 11 */
		/* enable usb detect(only insert) */
		pwc_write(DA9052_IRQMASKA_REG, 0x00,
		 MASK_ALARM_INT | MASK_VBUS_DET | MASK_DCIN_DET);	/* 10 */

		pwc_write(DA9052_IRQMASKD_REG, 0x00, 0x01);

		break;
	case EMXX_PMU_CLK_POWEROFF:
		pwc_reg_write(DA9052_GPIO0001_REG, 0x89);	/* 21 */
		pwc_write(DA9052_IRQMASKA_REG, 0x00,
		 MASK_CHARGER_INT|MASK_ALARM_INT);
		pwc_write(DA9052_IRQMASKC_REG, 0x00, MASK_KEY_INT);
		break;
	default:
		break;
	}

}



/*
 * pmu_set_regs(unsigned int sleep_flag)
 *
 */
static void pmu_set_regs(unsigned int sleep_flag, int lowpower_flag)
{
	unsigned int regval;
#ifdef PM_USE_TIMER
	struct irq_chip *chip;

	if (lowpower_flag)
		emxx_unreset_device(EMXX_RST_TI2);
#endif

	/* pmu command sequence set */
	pmu_set_command_sequence(sleep_flag, lowpower_flag);

	/* if P0_ON ? */
	writel(0x00111011, SMU_P0_SWENA);	/* RAM Disable */

	/* backup to pmu ram */
	writel(0x00000000, PMU_RUNCHECK);
	pwc_reg_read(DA9052_ISET_REG, (unsigned char *)&regval);
	writel(regval, PMU_PWIC_ISET);	/* RAM */
	pwc_reg_read(DA9052_CHGBUCK_REG, (unsigned char *)&regval);
	writel(regval, PMU_PWIC_CHGBUCK);
	pwc_reg_read(DA9052_BUCKCORE_REG, (unsigned char *)&regval);/* 46 */
	writel(regval, PMU_PWIC_BUCKCORE);

	if (lowpower_flag) {
#ifdef PM_USE_TIMER
		/* set enable TI2 */
		chip = get_irq_chip(INT_TIMER2);
		chip->unmask(INT_TIMER2);
		writel((PM_RESUME_SEC*0x8000)-1, TI2_SET);  /* Deep Sleep */
#endif

		outl(0x03, SMU_QR_WFI); /* PMU BOOT */
		if ((sleep_flag & EMXX_PMU_CLK_MASK)
		 == EMXX_PMU_CLK_DEEPSLEEP) {
			/* deepsleep setting */
			pw_ic_lowpower();
		}
	} else {
		/*** case SPI ***/
#ifdef PM_USE_TIMER
		rtc_sec(PM_RESUME_SEC);
#endif
		outl(0x03, SMU_QR_WFI); /* PMU BOOT */
		if ((sleep_flag & EMXX_PMU_CLK_MASK)
		 == EMXX_PMU_CLK_DEEPSLEEP) {
			/* deepsleep setting */
			pw_ic_spi();
		}
	}

	/* Set IRQ of PowerIC */
	pw_ic_mask(sleep_flag & EMXX_PMU_CLK_MASK, lowpower_flag);

	idle_seq(lowpower_flag);

	/* pmu start */
	outl(PMU_START_SET, PMU_START);
	do {
		regval = inl(PMU_START);
	} while ((regval & PMU_START_SET) != PMU_START_SET);

	DPRINTK("PMU_PC           =0x%08x \n", inl(PMU_PC));
	DPRINTK("PMU_POWER_ON_PC  =0x%08x \n", inl(PMU_POWER_ON_PC));
	DPRINTK("PMU_WDT_COUNT_EN =0x%08x \n", inl(PMU_WDT_COUNT_EN));
	DPRINTK("PMU_WDT_COUNT_LMT=0x%08x \n", inl(PMU_WDT_COUNT_LMT));
	DPRINTK("PMU_START        =0x%08x \n", inl(PMU_START));
}


static void pmu_save_state(void)
{
	/* maybe no need */
	reg_state.smu.ckrqmode_mask0 = readl(SMU_CKRQMODE_MASK0);
	reg_state.smu.ckrqmode_mask1 = readl(SMU_CKRQMODE_MASK1);

	/* modify register save */
	reg_state.smu.ckrq_mode = readl(SMU_CKRQ_MODE);
	/* save only. not restore */
	reg_state.smu.clk_mode_sel = readl(SMU_CLK_MODE_SEL);
}

static void pmu_restore_state(void)
{
	/* maybe no need */
	writel(reg_state.smu.ckrqmode_mask0, SMU_CKRQMODE_MASK0);
	writel(reg_state.smu.ckrqmode_mask1, SMU_CKRQMODE_MASK1);

	/* modified register restore */
	writel(reg_state.smu.ckrq_mode, SMU_CKRQ_MODE);
}


/*
 * Wait for Interrupt
 *
 */
void emxx_cpu_do_idle(unsigned int pmu_boot)
{
	/* WFI */
	cpu_do_idle();

	/* Clear PMU boot bit */
	if (inl(PMU_START))
		outl(0x00000000, PMU_START);

	return;
}

static void save_spi_state(void)
{
	struct spi_state *state = &reg_state.spi;

	state->enset = readl(SIO0_SPI_ENSET);
}

static void restore_spi_state(void)
{
	struct spi_state *state = &reg_state.spi;

	writel(0xFF, SIO0_SPI_ENCLR);
	writel(0x07, SIO0_SPI_FFCLR);
	writel(state->enset, SIO0_SPI_ENSET);
}

/*
 * set retention mode.
 */
static void pmu_set_p0_mode(void)
{
	/* set mode: retention */
	writel(readl(SMU_PV_SWON) & 0xFFFFFEFF, SMU_PV_SWON);
	writel(readl(SMU_PR_SWON) & 0xFFFFFEFF, SMU_PR_SWON);
	writel(readl(SMU_PG_SWON) & 0xFFFFFEFF, SMU_PG_SWON);
	writel(readl(SMU_P2_SWON) & 0xFFFFFEFF, SMU_P2_SWON);
	writel(readl(SMU_PU_SWON) & 0xFFFFFEFF, SMU_PU_SWON);
#if 0
	writel(readl(SMU_PD_SWON) | 0x00000100, SMU_PD_SWON);
#else
	writel(readl(SMU_PD_SWON) & 0xFFFFFEFF, SMU_PD_SWON);
#endif
	writel(readl(SMU_P1_SWON) & 0xFFFFFEFF, SMU_P1_SWON);
	writel(readl(SMU_PL_SWON) & 0xFFFFFEFF, SMU_PL_SWON);
	writel(readl(SMU_PM_SWON) & 0xFFFFFEFF, SMU_PM_SWON);
	writel(readl(SMU_PS_SWON) & 0xFFFFFEFF, SMU_PS_SWON);
	writel(readl(SMU_P0_SWON) & 0xFFFFFEFF, SMU_P0_SWON);

	return;
}



/*
 * pmu_do_suspend()
 *
 */
static void pmu_do_suspend(unsigned int sleep_flag)
{
	int lowpower_flag = iLowPowerFlag;	/* 1: lowpower, 0: SPI */

	save_spi_state();
	pmu_set_p0_mode();		/* set to retention mode */
	pmu_int_mask(PMU_INT_MASK_SAVE_AND_MASK);

	timer_set_clock(TIMER_SUSPEND);
	if (!emxx_sleep_while_idle) {
		/* Disable GPIO Interrupt & Set PWC Resume Interrupt */
		pmu_gpio_mask(sleep_flag & EMXX_PMU_CLK_MASK);
	}

	/* save registers */
	pmu_save_state();

	/* PMU registers setting and boot */
	pmu_set_regs(sleep_flag, lowpower_flag);

	/* WDT stop */
	wdt_op_reg = inl(WDT_OP);
	if (wdt_op_reg & 0x1) { /* TM_EN */
		DPRINTK("disable WDT\n");
		emxx_wdt_disable();
	}
	/* Auto Frq Change Disable */

	outl(inl(SMU_CKRQ_MODE) & ~0x00000001, SMU_CKRQ_MODE);

#ifdef IDLE_DEBUG_TW1_WAKEUP
	tw1_test_wakeup();
#endif

	/* Auto Self Reflesh enable by PM */
	outl((inl(MEMC_DDR_CONFIGR2) & ~0x000000FC) | 0x0000001E,
	 MEMC_DDR_CONFIGR2);

	/* TIMER START , lowpower */
#ifdef PM_USE_TIMER
	if (lowpower_flag)
		writel(0x07, TI2_OP);
#endif

#ifdef CONFIG_CACHE_L2X0
	if ((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_DEEPSLEEP)
		l2x0_suspend();
#endif
	emxx_cpu_do_idle(EMXX_PMU_BOOT);

	if (((reg_state.smu.clk_mode_sel & 0x00000F00) >> 8) == NORMAL_B) {
		/* NORMALB mode */
		pm_change_normalB();
	} else {
		/* other to  Normal A mode */
		pm_change_normalA();
	}

	return;
}


/*
 * pmu_do_resume()
 *
 */
static void pmu_do_resume(int sleep_flag)
{
#ifndef CONFIG_EMXX_ANDROID
	unsigned char udata;
	int count;
#endif
	unsigned int regval;
#ifdef PM_USE_TIMER
	int lowpower_flag = iLowPowerFlag;	/* 1: lowpower, 0: SPI */
#endif


	DPRINTK("resume start... \n");

#ifdef CONFIG_CACHE_L2X0
	if ((sleep_flag & EMXX_PMU_CLK_MASK) == EMXX_PMU_CLK_DEEPSLEEP)
		l2x0_resume();
#endif

	restore_spi_state();
	pmu_restore_state();

	if (readl(PMU_RUNCHECK) == 0) {
		/* not run pmu_code. */
		regval = readl(PMU_PWIC_BUCKCORE);
		/* 46 */
		pwc_reg_write(DA9052_BUCKCORE_REG, (unsigned char)regval);
	}
#ifdef PM_DEBUG
	else
		pmu_count++;

	pm_try_count++;
	printk(KERN_INFO "(pm_try,pmu)=(%d, %d)\n", pm_try_count, pmu_count);
#endif

#ifdef PM_USE_TIMER
	if (lowpower_flag) {
		struct irq_chip *chip;

		writel(0x00, TI2_OP);
		writel(0x02, TI2_CLR);

		/* mask & clear */
		chip = get_irq_chip(INT_TIMER2);
		chip->mask(INT_TIMER2);

		/* check pending */
		regval = readl(GIC_064_PEN);
		if (regval & TIMER2_INT_BIT) {
			/* TI2 clear */
			writel(TIMER2_INT_BIT, GIC_064_PDS);
		}
	}
#endif


#ifndef CONFIG_EMXX_ANDROID
	/* if use rtc-mode then need clear */
	/* but it's no good at Android. */
	pwc_reg_read(DA9052_EVENTA_REG, &udata);	/* 5 */
	if (udata & MASK_ALARM_INT) {
		pwc_write(DA9052_EVENTA_REG, 0xff, MASK_ALARM_INT);
		count = 0;
		do {
			udelay(100);
			pwc_reg_read(DA9052_EVENTA_REG, &udata);	/* 5 */
			count++;
		} while ((udata & MASK_ALARM_INT) && (count < 100));
	}
#ifndef CONFIG_WAKELOCK
	/* if enable setting for rtc then need this clear. */
	writel(0x00000001, GIO_000_IIR);
#endif
#endif
	if (!emxx_sleep_while_idle) {
		/* Restore GPIO/PWC Interrupt */
		pmu_gpio_mask(EMXX_PMU_CLK_FULLSPEED);
	}

	/* INT restore */
	pmu_int_mask(PMU_INT_MASK_RESTORE);

	timer_set_clock(TIMER_RESUME);

	/* WDT start */
	if (wdt_op_reg & 0x1)
		emxx_wdt_enable();

}


/*
 * emxx_pmu_sleep(unsigned int flag)
 */
int emxx_pmu_sleep(unsigned int sleep_flag)
{
#ifdef	DEBUG_LED
	unsigned int data;
#endif

	DPRINTK("emxx_pmu_sleep.. sleep_flag=0x%x \n", sleep_flag);

#ifdef	DEBUG_LED
	pwc_read(DA9052_GPIO1415_REG, &data);
#endif

/* debug */
	pwc_write(DA9052_GPIO1415_REG, 0x22, 0xFF);	/* off */

	/* suspend */
	pmu_do_suspend(sleep_flag);
	pmu_do_resume(sleep_flag);

/* debug */
	pwc_write(DA9052_GPIO1415_REG, 0xaa, 0xFF);	/* on */


#ifdef	DEBUG_LED
	pwc_write(DA9052_GPIO1415_REG, data, 0xFF);
#endif

	return 0;
}

int emxx_pm_do_poweroff(void)
{
#ifdef	CONFIG_FB_EMXX
	struct pm_message message = { .event = PM_EVENT_SUSPEND, };
#endif

#ifdef	CONFIG_FB_EMXX
	emxx_lcd_suspend((struct platform_device *)NULL, message);
#endif

#ifdef CONFIG_MACH_EMEV
	gpio_set_value(GPIO_AUDIO_RST, 0);	/* PDN-pin @ AK4648 */
#endif

	outl(0x03, SMU_QR_WFI); /* PMU BOOT */
	/* setup for power down */
	pwc_write(DA9052_BUCKCORE_REG, 0x18, 0x3F);	/* 46 */
	pwc_reg_write(DA9052_RESET_REG, 0x41);		/* 20 */
	pwc_reg_write(DA9052_ID01_REG, 0x95);		/* 29 */
	pwc_reg_write(DA9052_BUCKB_REG, 0x88);		/* 45 */
	pwc_reg_write(DA9052_SEQTIMER_REG, 0xC1);
	/* for DA9052 auto wake. */
	pwc_reg_write(DA9052_GPIO0809_REG, 0x11);		/* 18 */

	/* GPIO Disable */
	pmu_gpio_mask(EMXX_PMU_CLK_POWEROFF);

	/* INT Disable */
	pmu_int_mask(PMU_INT_ALLMASK);
	/* Set IRQ of PowerIC */
	pw_ic_mask(EMXX_PMU_CLK_POWEROFF, iLowPowerFlag);

	/* power down */
	pwc_reg_write(DA9052_CONTROLB_REG, 0x6D);

	/* WFI */
	cpu_do_idle();

	return 0;
}

/*
 * init
 *
 */
int __init emxx_pmu_init(void)
{
	wdt_op_reg = 0;

	printk(KERN_INFO "Starting pmu... \n");

	iLowPowerFlag = PM_CONTROL_MODE;
#ifdef PM_DEBUG
	pm_try_count = 0;
	pmu_count = 0;
#endif

	return 0;
}

device_initcall(emxx_pmu_init);
