/*
 *  arch/arm/mach-emxx/switch/switch_vup_test.c
 *
 *  Copyright 2011 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <sys/ioctl.h>
#include <linux/kdev_t.h>
#include "../include/mach/switch-vup.h"

/**
 * @brief  get file size
 * @param[OUT] none
 * @param[IN] none
 * @return file size
 * @pre none
 * @post none
 * @attention none
 */
 
 static gstatus = 0;
unsigned long get_file_size(const char *filename)
{
	struct stat buf;
	if(stat(filename, &buf)<0)
	{
		return 0;
	}
	return (unsigned long)buf.st_size;
}

void callback(int status)
{
//	printf("callback status in switch_lib_driver:%d .\n",status);
	gstatus = status;
}

int main(int argc, char *argv[])
{
  int fd = 0;
  int switchfd = 0;
  int filesize = 0;
  unsigned char * buff = NULL;
  char cNameBuf[256] = {0};
  int iRet = 0;
  int i;

  int type = atoi(argv[1]); //type
  //printf("the type is :%d .\n",type);
  if( 3 != argc )
  {
      printf("Usage: <./Vine_Up> <type> <FileName> \n");
      return 0;
  }
  filesize = get_file_size(argv[2]);
  buff = (unsigned char *)malloc(sizeof(unsigned char) * filesize);
  if(NULL == buff)
  {
      printf("malloc buff failed.\n");
      return 0;
  }
  memcpy(cNameBuf,argv[2],strlen(argv[2]));
 // printf("The file name is:%s\n",cNameBuf);
  //fd = open(argv[2],O_);
  fd = open(cNameBuf,O_RDONLY);
  //printf("fd is:%d\n",fd);
  iRet = read(fd,buff,filesize);
 // printf("iRet is:%d\n",iRet);
  
  //printf("The first 32 byte is:\n");
  //for(i=0; i<32; i++)
  //{
    // printf("%x  ",buff[i]);
 // }
  
  //printf("\n");

  //ioctl(switchfd,VINE_LIB_CHR_INIT,0);
  printf("Start download,please wait about 3 minutes....\n");
  if_switch_ver_up(buff,filesize,type,&callback);
  

  close(fd);
  free(buff);
  //system("PAUSE");	
   
  printf("update end.\n");
  return 0;
}
