/*
 *  File Name	    : arch/arm/mach-emxx/time.h
 *  Function	    : time
 *  Release Version : Ver 1.00
 *  Release Date    : 2010/02/05
 *
 *  Copyright (C) NEC Electronics Corporation 2010
 *
 *  This program is free software;you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by Free
 *  Softwere Foundation; either version 2 of License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warrnty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; If not, write to the Free Software Foundation, Inc., 59
 *
 */

#ifndef __ARCH_ARM_MACH_EMXX_TIME_H
#define __ARCH_ARM_MACH_EMXX_TIME_H

/*
 * General Timer
 */
#define TM_EN			0x00000001
#define TSTART			0x00000002
#define TO_EN			0x00000004
#define TCR_CLR			0x00000002
#define TSTOP			0x00000000

/*
 * Timer clock condition
 */
#define TIMER_SUSPEND		0
#define TIMER_RESUME		1
#define TIMER_FULLSPEED		2
#define TIMER_ECONOMY		3
#define TIMER_INIT		4
#define TIMER_SUSPEND_PDMA	5
#define TIMER_RESUME_PDMA	6


#define TIMER_WDT		TIMER_TW0

#define TIMER_MIN		TIMER_TG0
#define TIMER_MAX		TIMER_TG5

#define TIMER_SYSTEM	TIMER_TI0
#define TIMER_DSP		TIMER_TI3

#ifdef CONFIG_EMXX_USE_TG_TIMER_FOR_CLOCKSOURCE
#define TIMER_CLOCKSOURCE       CONFIG_EMXX_CLOCKSOURCE_TG_TIMER
#endif /* CONFIG_EMXX_USE_TG_TIMER_FOR_CLOCKSOURCE */

#ifdef CONFIG_EMXX_PLL3_238MHZ
#define TIMER_INTERVAL_PLL3     (59392 - 1)
#else
#define TIMER_INTERVAL_PLL3     (57344 - 1)
#endif

#define TIMER_INTERVAL_32K      (320 - 1)
#define TIMER_INTERVAL_DSP      (32 - 1)

#define COUNTER_MAXVAL          TIMER_INTERVAL_PLL3

/* x:clock source value	*/
#define TIMER_DELAY(x)		((40000000 / x)/10 + 1)

struct tm_param_t {
	unsigned int usecs;
	unsigned int tm_op;
};

struct timer_reg_t {
	volatile unsigned int tm_op;
	volatile unsigned int tm_clr;
	volatile unsigned int tm_set;
	volatile unsigned int tm_rcr;
	volatile unsigned int reserved1;
	volatile unsigned int tm_sclr;
	volatile unsigned int tm_one;
	volatile unsigned int tm_int;
};

struct tm_reg_t {
	unsigned int irq;
	volatile struct timer_reg_t *reg;
	unsigned int clkdev;
	unsigned int rstdev;
	unsigned int tin_sel;
};

struct sti_reg_t {
	volatile unsigned int control;		/* 0x00 */
	volatile unsigned int rfu1[3];		/* 0x04-0x0c */
	volatile unsigned int compa_h;		/* 0x10 */
	volatile unsigned int compa_l;		/* 0x14 */
	volatile unsigned int compb_h;		/* 0x18 */
	volatile unsigned int compb_l;		/* 0x1c */
	volatile unsigned int count_h;		/* 0x20 */
	volatile unsigned int count_l;		/* 0x24 */
	volatile unsigned int count_raw_h;	/* 0x28 */
	volatile unsigned int count_raw_l;	/* 0x2c */
	volatile unsigned int set_h;		/* 0x30 */
	volatile unsigned int set_l;		/* 0x34 */
	volatile unsigned int rfu2[2];		/* 0x38-0x3c */
	volatile unsigned int intstatus;	/* 0x40 */
	volatile unsigned int intrawstatus;	/* 0x44 */
	volatile unsigned int intenset;		/* 0x48 */
	volatile unsigned int intenclr;		/* 0x4c */
	volatile unsigned int intffclr;		/* 0x50 */
};

extern struct sys_timer emxx_timer;

extern void timer_set_clock_parm(unsigned int mode);
extern void timer_set_clock(unsigned int mode);

#ifdef CONFIG_EMXX_SSBOOT_ADJUST_SCHED_CLOCK
void emxx_sched_clock_suspend(void);
void emxx_sched_clock_resume(void);
#endif
#ifdef CONFIG_EMXX_USE_TIMER_TI1_FOR_SCHED_CLOCK
unsigned long long emxx_timer_get_nsec(void);
#endif
#ifdef CONFIG_LOCAL_TIMERS
extern void __iomem *twd_base;
#endif

#endif
