/*
 *  Copyright (C) 2000 Deep Blue Solutions Ltd
 *  Copyright (C) 2002 Shane Nay (shane@minirl.com)
 *  Copyright 2005-2006 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/types.h>
#include <linux/init.h>
#include <linux/clk.h>
#include <linux/serial_8250.h>
#include <linux/irq.h>
#if defined(CONFIG_SMSC911X) || defined(CONFIG_SMSC911X_MODULE)
#include <linux/smsc911x.h>
#else
#include <linux/smc911x.h>
#endif

#include <asm/gpio.h>
#include <mach/hardware.h>
#include <mach/common.h>
#include <mach/board-mx31kz.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/time.h>
#include <asm/setup.h>
#include <asm/memory.h>
#include <asm/mach/map.h>
#include <mach/imx-uart.h>
#include <mach/iomux-mx3.h>
#include <asm/hardware/cache-l2x0.h>

#include "devices.h"

extern void __init mx3kz_gpio_init(void);

/*!
 * @file mx31kz.c
 *
 * @brief This file contains the board specific initialization routines.
 *
 * @ingroup System
 */

#if defined(CONFIG_SERIAL_8250) || defined(CONFIG_SERIAL_8250_MODULE)
/*!
 * The serial port definition structure. The fields contain:
 * {UART, CLK, PORT, IRQ, FLAGS}
 */
static struct plat_serial8250_port serial_platform_data[] = {
	{
	 .membase = (void __iomem *)(KZCTL_BASE_ADDRESS + PBC_SC16550_A),
	 .mapbase = (unsigned long)(CS4_BASE_ADDR + PBC_SC16550_A),
	 .irq = IOMUX_TO_IRQ(MX31_PIN_GPIO1_1) /*65*/,
	 .uartclk = 14745600,
	 .regshift = 0,
	 .iotype = UPIO_MEM,
	 .flags = UPF_BOOT_AUTOCONF | UPF_SKIP_TEST | UPF_BUGGY_UART,
	 },
#if 0
	{
	 .membase = (void __iomem *)(KZCTL_BASE_ADDRESS + PBC_SC16550_B),
	 .mapbase = (unsigned long)(CS4_BASE_ADDR + PBC_SC16550_B),
	 .irq = IOMUX_TO_IRQ(MX31_PIN_GPIO1_1),
	 .uartclk = 14745600,
	 .regshift = 0,
	 .iotype = UPIO_MEM,
	 .flags = UPF_BOOT_AUTOCONF | UPF_SKIP_TEST | UPF_BUGGY_UART,
	 },
#endif
	{},
};

/*!
 * REVISIT: document me
 */
static struct platform_device serial_device = {
	.name = "serial8250",
	.id = 0,
	.dev = {
		.platform_data = serial_platform_data,
		},
};

/*!
 * REVISIT: document me
 */
static int __init mxc_init_extuart(void)
{
        __raw_writeb(__raw_readb(0xf4001000) | 2,0xf4001000);           /* UART INT UNMASK */
	return platform_device_register(&serial_device);
}
#else
static inline int mxc_init_extuart(void)
{
	return 0;
}
#endif

#if defined(CONFIG_SERIAL_IMX) || defined(CONFIG_SERIAL_IMX_MODULE)
static struct imxuart_platform_data uart_pdata = {
	.flags = IMXUART_HAVE_RTSCTS,
};

static inline void mxc_init_imx_uart(void)
{
	mxc_iomux_mode(MX31_PIN_CTS1__CTS1);
	mxc_iomux_mode(MX31_PIN_RTS1__RTS1);
	mxc_iomux_mode(MX31_PIN_TXD1__TXD1);
	mxc_iomux_mode(MX31_PIN_RXD1__RXD1);

	mxc_register_device(&mxc_uart_device0, &uart_pdata);
}
#else /* !SERIAL_IMX */
static inline void mxc_init_imx_uart(void)
{
}
#endif /* !SERIAL_IMX */

/*!
 * This structure defines static mappings for the i.MX31KZM board.
 */
static struct map_desc mx31kzm_io_desc[] __initdata = {
	{
		.virtual	= AIPS1_BASE_ADDR_VIRT,
		.pfn		= __phys_to_pfn(AIPS1_BASE_ADDR),
		.length		= AIPS1_SIZE,
		.type		= MT_DEVICE_NONSHARED
	}, {
		.virtual	= SPBA0_BASE_ADDR_VIRT,
		.pfn		= __phys_to_pfn(SPBA0_BASE_ADDR),
		.length		= SPBA0_SIZE,
		.type		= MT_DEVICE_NONSHARED
	}, {
		.virtual	= AIPS2_BASE_ADDR_VIRT,
		.pfn		= __phys_to_pfn(AIPS2_BASE_ADDR),
		.length		= AIPS2_SIZE,
		.type		= MT_DEVICE_NONSHARED
	}, {
		.virtual	= CS4_BASE_ADDR_VIRT,
		.pfn		= __phys_to_pfn(CS4_BASE_ADDR),
		.length		= CS4_SIZE,
		.type		= MT_DEVICE
	},
	{
		.virtual	= CS5_BASE_ADDR_VIRT,
		.pfn		= __phys_to_pfn(CS5_BASE_ADDR),
		.length		= CS5_SIZE,
		.type		= MT_DEVICE
	},
};

#if defined(CONFIG_SMSC911X) || defined(CONFIG_SMSC911X_MODULE)
static struct smsc911x_platform_config mx3kz_smc911x_config = {
	.flags		= SMSC911X_USE_32BIT,
	.irq_type	= SMSC911X_IRQ_TYPE_PUSH_PULL,
	.irq_polarity	= SMSC911X_IRQ_POLARITY_ACTIVE_HIGH,
	.phy_interface	= PHY_INTERFACE_MODE_MII,
};
#else
static struct smc911x_platdata mx3kz_smc911x_config = {
	.flags          = SMC911X_USE_32BIT,
	.irq_polarity	= 1,
	.irq_flags	= IRQF_SHARED | IRQF_TRIGGER_RISING,
};
#endif

static struct resource mx3kz_smc911x_resources[] = {
	[0] = {
		.start	= CS5_BASE_ADDR,
		.end	= CS5_BASE_ADDR + SZ_64K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= IOMUX_TO_IRQ(MX31_PIN_GPIO1_2),
		.end	= IOMUX_TO_IRQ(MX31_PIN_GPIO1_2),
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device mx3kz_smc911x_device = {
#if defined(CONFIG_SMSC911X) || defined(CONFIG_SMSC911X_MODULE)
	.name		= "smsc911x",
#else
	.name		= "smc911x",
#endif
	.id		= 0,
	.num_resources	= ARRAY_SIZE(mx3kz_smc911x_resources),
	.resource	= mx3kz_smc911x_resources,
	.dev = {
		.platform_data = &mx3kz_smc911x_config,
	},
};

static void mx3kz_init_smc911x(void)
{
	/*
	 * Configure INT line as GPIO input
	 */
	mxc_iomux_mode(IOMUX_MODE(MX31_PIN_GPIO1_2, IOMUX_CONFIG_GPIO));
	gpio_direction_input(IOMUX_TO_GPIO(MX31_PIN_GPIO1_2));  /* input */
	set_irq_type(IOMUX_TO_IRQ(MX31_PIN_GPIO1_2), IRQ_TYPE_EDGE_RISING);

	(void)platform_device_register(&mx3kz_smc911x_device);
}

static struct resource mx3kz_ide_resources[] = {
	[0] = {
		.start	= ATA_BASE_ADDR,
		.end	= ATA_BASE_ADDR + SZ_16K - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= MXC_INT_ATA,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device mx3kz_ide_device = {
	.name		= "mxc-ide",
	.id		= 0,
	.num_resources	= ARRAY_SIZE(mx3kz_ide_resources),
	.resource	= mx3kz_ide_resources,
};

static void mx3kz_init_ide(void)
{
	(void)platform_device_register(&mx3kz_ide_device);
}


/*!
 * Set up static virtual mappings.
 */
void __init mx31kzm_map_io(void)
{
	mxc_map_io();
	iotable_init(mx31kzm_io_desc, ARRAY_SIZE(mx31kzm_io_desc));
}

/*!
 * Initialize L2x0 cache controller
 */
void __init mx3kz_l2x0_init(void)
{
	void __iomem *l2_base;

	/* Initialize L2 cache */
	l2_base = ioremap(L2CC_BASE_ADDR, SZ_4K);
	if (l2_base) {
		l2x0_init(l2_base, 0x00030024, 0x00000000);
	}
}

/*!
 * Board specific initialization.
 */
static void __init mxc_board_init(void)
{
	mx3kz_l2x0_init();

	mx3kz_gpio_init();
	mxc_init_extuart();
	mxc_init_imx_uart();

	mx3kz_init_smc911x();
	mx3kz_init_ide();
}

static void __init mx31kzm_timer_init(void)
{
	mxc_clocks_init(26000000);
	mxc_timer_init("ipg_clk.0");
}

struct sys_timer mx31kzm_timer = {
	.init	= mx31kzm_timer_init,
};

/*
 * The following uses standard kernel macros define in arch.h in order to
 * initialize __mach_desc_MX31KZM data structure.
 */
/* *INDENT-OFF* */
MACHINE_START(MX3KZ, "KMC KZM-ARM11-01")
	/* Maintainer: Kyoto Microcomputer Co.,Ltd. */
	.phys_io        = AIPS1_BASE_ADDR,
	.io_pg_offst    = ((AIPS1_BASE_ADDR_VIRT) >> 18) & 0xfffc,
	.boot_params    = PHYS_OFFSET + 0x100,
	.map_io         = mx31kzm_map_io,
	.init_irq       = mxc_init_irq,
	.init_machine   = mxc_board_init,
	.timer          = &mx31kzm_timer,
MACHINE_END
