/*
 * Copyright 2005-2006 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#include <linux/errno.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/irq.h>
#include <asm/io.h>
#include <mach/hardware.h>
#include <mach/clock.h>
#include <mach/gpio.h>
#include <mach/board-mx31kz.h>
#include <mach/iomux-mx3.h>

/*!
 * @file mx3kz_gpio.c
 *
 * @brief This file contains all the GPIO setup functions for the board.
 *
 * @ingroup GPIO
 */

/*!
 * This system-wise GPIO function initializes the pins during system startup.
 * All the statically linked device drivers should put the proper GPIO initialization
 * code inside this function. It is called by \b fixup_mx31ads() during
 * system startup. This function is board specific.
 */
void __init mx3kz_gpio_init(void)
{
	/* config CS4 */
	mxc_iomux_mode(MX31_PIN_CS4__CS4);
}

/*!
 * Setup GPIO for ATA interface
 *
 */
void gpio_ata_active(void)
{
#if defined(CONFIG_DEBUG_KZM_ETM_USE)
	/*
	 * ATA_SEL LOW
	 */
	mxc_iomux_set_gpr(MUX_PGP_ATA_8 | MUX_PGP_ATA_5 | MUX_PGP_ATA_1, true);

	mxc_iomux_mode(MX31_PIN_CSI_D6__CSI_D6);	 // ATA_D0
	mxc_iomux_mode(MX31_PIN_CSI_D7__CSI_D7);	 // ATA_D1
	mxc_iomux_mode(MX31_PIN_CSI_D8__CSI_D8);	 // ATA_D2
	mxc_iomux_mode(MX31_PIN_CSI_D9__CSI_D9);	 // ATA_D3
	mxc_iomux_mode(MX31_PIN_CSI_D10__CSI_D10);	 // ATA_D4
	mxc_iomux_mode(MX31_PIN_CSI_D11__CSI_D11);	 // ATA_D5
	mxc_iomux_mode(MX31_PIN_CSI_D12__CSI_D12);	 // ATA_D6
	mxc_iomux_mode(MX31_PIN_CSI_D13__CSI_D13);	 // ATA_D7
	mxc_iomux_mode(MX31_PIN_CSI_D14__CSI_D14);	 // ATA_D8
	mxc_iomux_mode(MX31_PIN_CSI_D15__CSI_D15);	 // ATA_D9
	mxc_iomux_mode(MX31_PIN_CSI_MCLK__CSI_MCLK);     // ATA_D10
	mxc_iomux_mode(MX31_PIN_CSI_VSYNC__CSI_VSYNC);	 // ATA_D11
	mxc_iomux_mode(MX31_PIN_CSI_HSYNC__CSI_HSYNC);	 // ATA_D12
	mxc_iomux_mode(MX31_PIN_CSI_PIXCLK__CSI_PIXCLK); // ATA_D13
	mxc_iomux_mode(MX31_PIN_I2C_CLK__I2C_CLK);	 // ATA_D14
	mxc_iomux_mode(MX31_PIN_I2C_DAT__I2C_DAT);	 // ATA_D15

	mxc_iomux_mode(MX31_PIN_CSPI1_SS0__SS0);    	 // ATA_DMARQ_B
	mxc_iomux_mode(MX31_PIN_CSPI1_MOSI__MOSI);  	 // ATA_INTRQ_B
	mxc_iomux_mode(MX31_PIN_CSPI1_SS1__SS1);    	 // ATA_DA0
	mxc_iomux_mode(MX31_PIN_CSPI1_SS2__SS2);    	 // ATA_DA1
	mxc_iomux_mode(MX31_PIN_CSPI1_SCLK__SCLK);  	 // ATA_DA2
	mxc_iomux_mode(MX31_PIN_CSPI1_MISO__MISO);  	 // ATA_BUFFER_DIR

	/* These ATA pins are common to Group A and Group B */

	mxc_iomux_mode(MX31_PIN_ATA_CS0__ATA_CS0);
	mxc_iomux_mode(MX31_PIN_ATA_CS1__ATA_CS1);
	mxc_iomux_mode(MX31_PIN_ATA_DIOR__ATA_DIOR);
	mxc_iomux_mode(MX31_PIN_ATA_DIOW__ATA_DIOW);
	mxc_iomux_mode(MX31_PIN_ATA_DMACK__ATA_DMACK);
	mxc_iomux_mode(MX31_PIN_ATA_RESET_B__ATA_RESET_B);

	/* Need fast slew rate for UDMA mode */

	mxc_iomux_set_pad(MX31_PIN_CSI_D6, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 0
	mxc_iomux_set_pad(MX31_PIN_CSI_D7, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 1
	mxc_iomux_set_pad(MX31_PIN_CSI_D8, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 2
	mxc_iomux_set_pad(MX31_PIN_CSI_D9, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 3
	mxc_iomux_set_pad(MX31_PIN_CSI_D10, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 4
	mxc_iomux_set_pad(MX31_PIN_CSI_D11, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 5
	mxc_iomux_set_pad(MX31_PIN_CSI_D12, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 6
	mxc_iomux_set_pad(MX31_PIN_CSI_D13, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 7
	mxc_iomux_set_pad(MX31_PIN_CSI_D14, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 8
	mxc_iomux_set_pad(MX31_PIN_CSI_D15, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 9
	mxc_iomux_set_pad(MX31_PIN_CSI_MCLK, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 10
	mxc_iomux_set_pad(MX31_PIN_CSI_VSYNC, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 11
	mxc_iomux_set_pad(MX31_PIN_CSI_HSYNC, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 12
	mxc_iomux_set_pad(MX31_PIN_CSI_PIXCLK, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 13
	mxc_iomux_set_pad(MX31_PIN_I2C_CLK, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 14
	mxc_iomux_set_pad(MX31_PIN_I2C_DAT, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 15

#else
	/*
	 * Configure the GPR for ATA group B signals
	 */
	mxc_iomux_set_gpr(MUX_PGP_ATA_7 | MUX_PGP_ATA_6 | MUX_PGP_ATA_2 |
			  MUX_PGP_ATA_1, true);

	/*
	 * Configure the IOMUX for ATA group B signals
	 */
	mxc_iomux_mode(MX31_PIN_CSPI1_MOSI__MOSI);
	mxc_iomux_mode(MX31_PIN_CSPI1_MISO__MISO);
	mxc_iomux_mode(MX31_PIN_CSPI1_SS0__SS0);
	mxc_iomux_mode(MX31_PIN_CSPI1_SS1__SS1);
	mxc_iomux_mode(MX31_PIN_CSPI1_SS2__SS2);
	mxc_iomux_mode(MX31_PIN_CSPI1_SCLK__SCLK);
	mxc_iomux_mode(MX31_PIN_CSPI1_SPI_RDY__SPI_RDY);
	mxc_iomux_mode(MX31_PIN_STXD3__STXD3);
	mxc_iomux_mode(MX31_PIN_SRXD3__SRXD3);
	mxc_iomux_mode(MX31_PIN_SCK3__SCK3);
	mxc_iomux_mode(MX31_PIN_SFS3__SFS3);
	mxc_iomux_mode(MX31_PIN_STXD6__STXD6);
	mxc_iomux_mode(MX31_PIN_SRXD6__SRXD6);
	mxc_iomux_mode(MX31_PIN_SCK6__SCK6);
	mxc_iomux_mode(MX31_PIN_CAPTURE__CAPTURE);
	mxc_iomux_mode(MX31_PIN_COMPARE__COMPARE);
	mxc_iomux_mode(MX31_PIN_USBH2_STP__USB2_STP);
	mxc_iomux_mode(MX31_PIN_USBH2_CLK__USB2_CLK);
	mxc_iomux_mode(MX31_PIN_USBH2_NXT__USB2_NXT);
	mxc_iomux_mode(MX31_PIN_USBH2_DATA0__USB2_DATA0);
	mxc_iomux_mode(MX31_PIN_USBH2_DATA1__USB2_DATA1);
	mxc_iomux_mode(MX31_PIN_USBH2_DIR__USB2_DIR);

	/* These ATA pins are common to Group A and Group B */
	mxc_iomux_mode(MX31_PIN_ATA_CS0__ATA_CS0);
	mxc_iomux_mode(MX31_PIN_ATA_CS1__ATA_CS1);
	mxc_iomux_mode(MX31_PIN_ATA_DIOR__ATA_DIOR);
	mxc_iomux_mode(MX31_PIN_ATA_DIOW__ATA_DIOW);
	mxc_iomux_mode(MX31_PIN_ATA_DMACK__ATA_DMACK);
	mxc_iomux_mode(MX31_PIN_ATA_RESET_B__ATA_RESET_B);
	mxc_iomux_mode(MX31_PIN_PWMO__PWMO);

	/* Need fast slew rate for UDMA mode */

	mxc_iomux_set_pad(MX31_PIN_CSPI1_MISO, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 0
	mxc_iomux_set_pad(MX31_PIN_CSPI1_MOSI, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 1
	mxc_iomux_set_pad(MX31_PIN_CSPI1_SS0, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 2
	mxc_iomux_set_pad(MX31_PIN_CSPI1_SS1, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 3
	mxc_iomux_set_pad(MX31_PIN_CSPI1_SS2, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 4
	mxc_iomux_set_pad(MX31_PIN_CSPI1_SCLK, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 5
	mxc_iomux_set_pad(MX31_PIN_CSPI1_SPI_RDY, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 6
	mxc_iomux_set_pad(MX31_PIN_STXD3, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 7
	mxc_iomux_set_pad(MX31_PIN_SRXD3, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 8
	mxc_iomux_set_pad(MX31_PIN_SCK3, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 9
	mxc_iomux_set_pad(MX31_PIN_SFS3, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 10
	mxc_iomux_set_pad(MX31_PIN_STXD6, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 11
	mxc_iomux_set_pad(MX31_PIN_SRXD6, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 12
	mxc_iomux_set_pad(MX31_PIN_SCK6, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 13
	mxc_iomux_set_pad(MX31_PIN_CAPTURE, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 14
	mxc_iomux_set_pad(MX31_PIN_COMPARE, PAD_CTL_SRE_FAST | PAD_CTL_PKE_NONE);	// data 12

	/*
	 * Turn off default pullups on high asserted control signals.
	 * These are pulled down externally, so it will just waste
	 * power and create voltage divider action to pull them up
	 * on chip.
	 */
	mxc_iomux_set_pad(MX31_PIN_USBH2_STP, PAD_CTL_PKE_NONE); // ATA_DMARQ
	mxc_iomux_set_pad(MX31_PIN_USBH2_CLK, PAD_CTL_PKE_NONE); // ATA_INTRQ
#endif
}
EXPORT_SYMBOL(gpio_ata_active);

/*
  KZM get gpio status
 0:ATA ON	CAMERA OFF	UART1 CN5
 1:ATA OFF	CAMERA ON	UART1 CN5
 2:ATA ON	CAMERA OFF	UART1 CN7
 3:ATA OFF	CAMERA ON	UART1 CN7
*/
int gpio_get_pinconfig(void)
{
    return (int)readb(0xf4001002);
}
