
/*
 * Copyright 2004 Freescale Semiconductor, Inc. All Rights Reserved.  */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */

/*!
 * @file sdma_script_code.h
 * @brief This file contains functions of SDMA scripts code initialization
 *
 * The file was generated automatically. Based on sdma scripts library.
 *
 * @ingroup SDMA
 */
/************************************************************************************

			SDMA RELEASE LABEL: 	"SS14-SONY"

*************************************************************************************/

#ifndef __SDMA_SCRIPT_CODE_PASS2_H__
#define __SDMA_SCRIPT_CODE_PASS2_H__

/*!
* SDMA ROM scripts start addresses and sizes
*/

/*!
* Following define start address of signature script
*/
#define signature_ADDR_2	1023
/*!
* Following define size of signature script
*/
#define signature_SIZE_2	1

/*!
* Following define start address of start script
*/
#define start_ADDR_2	0
/*!
* Following define size of start script
*/
#define start_SIZE_2	20

/*!
* Following define start address of core script
*/
#define core_ADDR_2	80
/*!
* Following define size of core script
*/
#define core_SIZE_2	152

/*!
* Following define start address of common script
*/
#define common_ADDR_2	232
/*!
* Following define size of common script
*/
#define common_SIZE_2	191

/*!
* Following define start address of ap_2_ap script
*/
#define ap_2_ap_ADDR_2	423
/*!
* Following define size of ap_2_ap script
*/
#define ap_2_ap_SIZE_2	294

/*!
* Following define start address of bp_2_bp script
*/
#define bp_2_bp_ADDR_2	717
/*!
* Following define size of bp_2_bp script
*/
#define bp_2_bp_SIZE_2	112

/*!
* Following define start address of ap_2_bp script
*/
#define ap_2_bp_ADDR_2	829
/*!
* Following define size of ap_2_bp script
*/
#define ap_2_bp_SIZE_2	200

/*!
* Following define start address of bp_2_ap script
*/
#define bp_2_ap_ADDR_2	1029
/*!
* Following define size of bp_2_ap script
*/
#define bp_2_ap_SIZE_2	223

/*!
* Following define start address of app_2_mcu script
*/
#define app_2_mcu_ADDR_2	1252
/*!
* Following define size of app_2_mcu script
*/
#define app_2_mcu_SIZE_2	101

/*!
* Following define start address of mcu_2_app script
*/
#define mcu_2_app_ADDR_2	1353
/*!
* Following define size of mcu_2_app script
*/
#define mcu_2_app_SIZE_2	127

/*!
* Following define start address of uart_2_mcu script
*/
#define uart_2_mcu_ADDR_2	1480
/*!
* Following define size of uart_2_mcu script
*/
#define uart_2_mcu_SIZE_2	105

/*!
* Following define start address of uartsh_2_mcu script
*/
#define uartsh_2_mcu_ADDR_2	1585
/*!
* Following define size of uartsh_2_mcu script
*/
#define uartsh_2_mcu_SIZE_2	98

/*!
* Following define start address of mcu_2_shp script
*/
#define mcu_2_shp_ADDR_2	1683
/*!
* Following define size of mcu_2_shp script
*/
#define mcu_2_shp_SIZE_2	123

/*!
* Following define start address of shp_2_mcu script
*/
#define shp_2_mcu_ADDR_2	1806
/*!
* Following define size of shp_2_mcu script
*/
#define shp_2_mcu_SIZE_2	101

/*!
* Following define start address of error script
*/
#define error_ADDR_2	1907
/*!
* Following define size of error script
*/
#define error_SIZE_2	73

/*!
* Following define start address of test script
*/
#define test_ADDR_2	1980
/*!
* Following define size of test script
*/
#define test_SIZE_2	63


/*!
* SDMA RAM scripts start addresses and sizes
*/

/*!
* Following define start address of ap_2_ap_fixed_addr script
*/
#define ap_2_ap_fixed_addr_ADDR_2	6144
/*!
* Following define size of ap_2_ap_fixed_addr script
*/
#define ap_2_ap_fixed_addr_SIZE_2	68

/*!
* Following define start address of app_2_mcu_patched script
*/
#define app_2_mcu_patched_ADDR_2	6212
/*!
* Following define size of app_2_mcu_patched script
*/
#define app_2_mcu_patched_SIZE_2	104

/*!
* Following define start address of app_2_per script
*/
#define app_2_per_ADDR_2	6316
/*!
* Following define size of app_2_per script
*/
#define app_2_per_SIZE_2	105

/*!
* Following define start address of ata_2_mcu script
*/
#define ata_2_mcu_ADDR_2	6421
/*!
* Following define size of ata_2_mcu script
*/
#define ata_2_mcu_SIZE_2	110

/*!
* Following define start address of firi_2_mcu script
*/
#define firi_2_mcu_ADDR_2	6531
/*!
* Following define size of firi_2_mcu script
*/
#define firi_2_mcu_SIZE_2	114

/*!
* Following define start address of loop_DMAs_fixed_addr script
*/
#define loop_DMAs_fixed_addr_ADDR_2	6645
/*!
* Following define size of loop_DMAs_fixed_addr script
*/
#define loop_DMAs_fixed_addr_SIZE_2	90

/*!
* Following define start address of mcu_2_app_patched script
*/
#define mcu_2_app_patched_ADDR_2	6735
/*!
* Following define size of mcu_2_app_patched script
*/
#define mcu_2_app_patched_SIZE_2	129

/*!
* Following define start address of mcu_2_ata script
*/
#define mcu_2_ata_ADDR_2	6864
/*!
* Following define size of mcu_2_ata script
*/
#define mcu_2_ata_SIZE_2	87

/*!
* Following define start address of mcu_2_firi script
*/
#define mcu_2_firi_ADDR_2	6951
/*!
* Following define size of mcu_2_firi script
*/
#define mcu_2_firi_SIZE_2	77

#define mcu_2_mshc_ADDR_2	7028
#define mcu_2_mshc_SIZE_2	48

/*!
* Following define start address of mcu_2_shp_patched script
*/
#define mcu_2_shp_patched_ADDR_2	7076/*!
* Following define size of mcu_2_shp_patched script
*/
#define mcu_2_shp_patched_SIZE_2	125

#define mshc_2_mcu_ADDR_2	7201
#define mshc_2_mcu_SIZE_2	60

#define mshc_2_per_ADDR_2	7261
#define mshc_2_per_SIZE_2	52

#define per_2_app_ADDR_2	7313
#define per_2_app_SIZE_2	131

#define per_2_mshc_ADDR_2	7444
#define per_2_mshc_SIZE_2	48

#define per_2_shp_ADDR_2	7492
#define per_2_shp_SIZE_2	131

/*!
* Following define start address of shp_2_mcu_patched script
*/
#define shp_2_mcu_patched_ADDR_2	7623
/*!
* Following define size of shp_2_mcu_patched script
*/
#define shp_2_mcu_patched_SIZE_2	104

 /*!
* Following define start address of shp_2_per script
*/
#define shp_2_per_ADDR_2	7727
/*!
* Following define size of shp_2_per script
*/
#define shp_2_per_SIZE_2	109

/*!
* Following define start address of uart_2_mcu_patched script
*/
#define uart_2_mcu_patched_ADDR_2	7836/*!
* Following define size of uart_2_mcu_patched script
*/
#define uart_2_mcu_patched_SIZE_2	106

/*!
* Following define start address of uartsh_2_mcu_patched script
*/
#define uartsh_2_mcu_patched_ADDR_2	7942
/*!
* Following define size of uartsh_2_mcu_patched script
*/
#define uartsh_2_mcu_patched_SIZE_2	99

/*!
* SDMA RAM image start address and size
*/

/*!
* Following define the start address of sdma ram
*/
#define RAM_CODE_START_ADDR_2		6144
/*!
* Following define the size of sdma ram
*/
#define RAM_CODE_SIZE_2			1897

/*!
* Buffer that holds the SDMA RAM image
*/
/*!
* This function returns buffer that holds the image of SDMA RAM.
* This is required to start on a 4-byte aligned boundary on some platforms
* for SDMA to work properly.
*
* @return pointer to buffer that holds the image of SDMA RAM
*/
__attribute__ ((__aligned__(4)))
#ifndef CONFIG_XIP_KERNEL
const
#endif
static const short sdma_code_2[] =
{
0x0970, 0x0111, 0x5111, 0x5ef9, 0xc0ec, 0x7d23, 0x5ad1, 0x5bd9,
0xc0fe, 0x7c1f, 0x5ce1, 0x5de9, 0x5ef1, 0x08ff, 0x0011, 0x28ff,
0x00bc, 0x048e, 0x56f9, 0x0660, 0x7d05, 0x0661, 0x7c2b, 0x6c07,
0x6d13, 0x9821, 0x0661, 0x7d26, 0x6c17, 0x6d03, 0x028d, 0x058c,
0x048a, 0xd9f5, 0x7e08, 0x7f07, 0x54e1, 0x52d1, 0x53d9, 0xc10d,
0x7dde, 0x0200, 0x9804, 0x0660, 0x7d03, 0x6007, 0x52f1, 0x9832,
0x6003, 0x52e9, 0x00a2, 0x0007, 0x6a0c, 0x6a0c, 0x6207, 0x6a07,
0x6a2b, 0x6a28, 0x0007, 0x6a0c, 0x54e1, 0xc795, 0x048b, 0x0498,
0x0454, 0x9825, 0x0800, 0x983c, 0x0870, 0x0011, 0x5010, 0xc0ec,
0x7d61, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200,
0x984a, 0x6ec3, 0x6d07, 0x5df0, 0x0dff, 0x0511, 0x1dff, 0x05bc,
0x4d00, 0x7d45, 0x0b70, 0x0311, 0x522b, 0x5313, 0x02b9, 0x4a00,
0x7c04, 0x6a28, 0x7f3b, 0x0400, 0x985a, 0x008f, 0x00d5, 0x7d01,
0x008d, 0x05a0, 0x0a03, 0x0212, 0x02bc, 0x0210, 0x4a00, 0x7d1c,
0x4a02, 0x7d20, 0x4a01, 0x7d23, 0x0b70, 0x0311, 0x53eb, 0x62c8,
0x7e25, 0x0360, 0x7d02, 0x0210, 0x0212, 0x6a09, 0x7f1f, 0x0212,
0x6a09, 0x7f1c, 0x0212, 0x6a09, 0x7f19, 0x2003, 0x4800, 0x7cef,
0x0b70, 0x0311, 0x5313, 0x989b, 0x0015, 0x0015, 0x7802, 0x62c8,
0x6a0b, 0x989a, 0x0015, 0x7802, 0x62c8, 0x6a0a, 0x989a, 0x7802,
0x62c8, 0x6a09, 0x7c03, 0x6a28, 0x0000, 0x9858, 0xc77b, 0x6a28,
0x7ffd, 0x0870, 0x0011, 0x5010, 0x52c0, 0x53c8, 0xc10d, 0x7da2,
0x0200, 0x984a, 0x0200, 0x9847, 0x0870, 0x0011, 0x5010, 0xc0ec,
0x7d62, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200,
0x98b2, 0x6ec3, 0x6dd7, 0x5df0, 0x0dff, 0x0511, 0x1dff, 0x05bc,
0x4d00, 0x7d46, 0x0b70, 0x0311, 0x522b, 0x5313, 0x02b9, 0x4a00,
0x7c04, 0x62ff, 0x7e3c, 0x0400, 0x98c2, 0x008f, 0x00d5, 0x7d01,
0x008d, 0x05a0, 0x0a03, 0x0212, 0x02bc, 0x0210, 0x4a00, 0x7d28,
0x4a02, 0x7d20, 0x4a01, 0x7d19, 0x6ddd, 0x0b70, 0x0311, 0x53eb,
0x62c8, 0x7e25, 0x0360, 0x7d02, 0x0210, 0x0212, 0x6ac8, 0x7f1f,
0x0212, 0x6ac8, 0x7f1c, 0x0212, 0x6ac8, 0x7f19, 0x2003, 0x4800,
0x7cef, 0x0b70, 0x0311, 0x5313, 0x9905, 0x6ddd, 0x7802, 0x62c8,
0x6ac8, 0x9904, 0x6dde, 0x0015, 0x7802, 0x62c8, 0x6ac8, 0x9904,
0x0015, 0x0015, 0x7801, 0x62d8, 0x7c02, 0x0000, 0x98c0, 0xc777,
0x62ff, 0x7efd, 0x0870, 0x0011, 0x5010, 0x52c0, 0x53c8, 0xc10d,
0x7da1, 0x0200, 0x98b2, 0x0200, 0x98af, 0xc19d, 0xc0ec, 0x7d69,
0x0c70, 0x0411, 0x5414, 0x5ac4, 0x028c, 0x58da, 0x5efa, 0xc0fe,
0x56fa, 0x7d02, 0x0200, 0x991e, 0x6d07, 0x5bca, 0x5cd2, 0x0bff,
0x0311, 0x1bff, 0x04bb, 0x0415, 0x53da, 0x4c00, 0x7d47, 0x0a70,
0x0211, 0x552a, 0x5212, 0x008d, 0x00bb, 0x4800, 0x7c07, 0x05b9,
0x4d00, 0x7c13, 0x6928, 0x7f2d, 0x0400, 0x992f, 0x008f, 0x0015,
0x04d8, 0x7d01, 0x008c, 0x04a0, 0x0015, 0x7802, 0x55c6, 0x6d0b,
0x7e29, 0x6d28, 0x7f1e, 0x0000, 0x992d, 0x1e20, 0x5506, 0x2620,
0x008d, 0x0560, 0x7c08, 0x065f, 0x55c6, 0x063f, 0x7e1b, 0x6d0a,
0x7f10, 0x4c00, 0x7d1b, 0x04d8, 0x7d02, 0x008c, 0x0020, 0x04a0,
0x0015, 0x7802, 0x55c6, 0x6d0b, 0x7e0d, 0x6d28, 0x7f02, 0x0000,
0x9976, 0x0007, 0x680c, 0x6d0c, 0x6507, 0x6d07, 0x6d2b, 0x6d28,
0x0007, 0x680c, 0x0007, 0x54d2, 0x0454, 0x9979, 0x6928, 0x7ff1,
0x54d2, 0x008a, 0x52c0, 0x53c8, 0xc10d, 0x0288, 0x7d9f, 0x0200,
0x991e, 0x0200, 0x9916, 0x1e10, 0x0870, 0x0011, 0x5010, 0xc0ec,
0x7d39, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200,
0x998a, 0x6d07, 0x5df0, 0x0dff, 0x0511, 0x1dff, 0x05bc, 0x4d00,
0x7d17, 0x6ec3, 0x62c8, 0x7e28, 0x0264, 0x7d08, 0x0b70, 0x0311,
0x522b, 0x02b9, 0x4a00, 0x7c18, 0x0400, 0x9999, 0x0212, 0x3aff,
0x008a, 0x05d8, 0x7d01, 0x008d, 0x0a10, 0x6ed3, 0x6ac8, 0xd9d4,
0x6a28, 0x7f17, 0x0b70, 0x0311, 0x5013, 0xd9ec, 0x52c0, 0x53c8,
0xc10d, 0x7dd0, 0x0200, 0x998a, 0x008f, 0x00d5, 0x7d01, 0x008d,
0xd9d4, 0x9997, 0x0200, 0x9987, 0x0007, 0x68cc, 0x6a28, 0x7f01,
0x99d2, 0x0007, 0x6a0c, 0x6a0c, 0x6207, 0x6a07, 0x6a2b, 0x6a28,
0x0007, 0x680c, 0x0454, 0x99b0, 0x05a0, 0x1e08, 0x6ec3, 0x0388,
0x3b03, 0x0015, 0x0015, 0x7802, 0x62c8, 0x6a0b, 0x7ee5, 0x6a28,
0x7fe8, 0x0000, 0x6ec1, 0x008b, 0x7802, 0x62c8, 0x6a09, 0x7edc,
0x6a28, 0x7fdf, 0x2608, 0x0006, 0x55f0, 0x6207, 0x02a5, 0x0dff,
0x0511, 0x1dff, 0x04b5, 0x049a, 0x0006, 0x0388, 0x028d, 0x3a03,
0x4a00, 0x7c33, 0x028c, 0x3a03, 0x4a00, 0x7d0c, 0x0804, 0x00a2,
0x00db, 0x7d24, 0x03a0, 0x0498, 0x7802, 0x6209, 0x6a29, 0x7e24,
0x620c, 0x7e22, 0x0804, 0x03d0, 0x7d19, 0x0820, 0x028c, 0x3a1f,
0x00a2, 0x03d0, 0x7c02, 0x008b, 0x3003, 0x03a0, 0x0015, 0x0015,
0x6818, 0x7e12, 0x6828, 0x7f10, 0x0000, 0x0820, 0x03d8, 0x7df5,
0x0804, 0x03d0, 0x7d03, 0x008b, 0x3003, 0x9a15, 0x008b, 0x7802,
0x6209, 0x6a29, 0x7e01, 0x620c, 0x0006, 0x0804, 0x03d0, 0x7df6,
0x048b, 0x3403, 0x03a4, 0x0415, 0x0415, 0x0d0f, 0x0511, 0x1df0,
0x0808, 0x04d0, 0x7c01, 0x008c, 0x58c1, 0x04a0, 0x7803, 0x620b,
0x5a05, 0x1d01, 0x7ee9, 0x50c1, 0x05a0, 0x7803, 0x5205, 0x6a0b,
0x1d01, 0x6a28, 0x7fe1, 0x0000, 0x4c00, 0x7ce7, 0x9a26, 0x0870,
0x0011, 0x5010, 0xc0ec, 0x7d7a, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe,
0x56f8, 0x7d02, 0x0200, 0x9a55, 0x6d03, 0x6ed3, 0x0dff, 0x0511,
0x1dff, 0x05bc, 0x5df8, 0x4d00, 0x7d5e, 0x0b70, 0x0311, 0x522b,
0x5313, 0x02b9, 0x4a00, 0x7c04, 0x62ff, 0x7e3f, 0x0400, 0x9a65,
0x008f, 0x00d5, 0x7d01, 0x008d, 0x05a0, 0x5ddb, 0x0d03, 0x0512,
0x05bc, 0x0510, 0x5dd3, 0x4d00, 0x7d27, 0x4d02, 0x7d20, 0x4d01,
0x7d1a, 0x0b70, 0x0311, 0x53eb, 0x0360, 0x7d05, 0x6509, 0x7e25,
0x620a, 0x7e23, 0x9a8f, 0x620a, 0x7e20, 0x6509, 0x7e1e, 0x0512,
0x0512, 0x02ad, 0x6ac8, 0x7f19, 0x2003, 0x4800, 0x7ced, 0x0b70,
0x0311, 0x5313, 0x9aaa, 0x7802, 0x6209, 0x6ac8, 0x9aa9, 0x0015,
0x7802, 0x620a, 0x6ac8, 0x9aa9, 0x0015, 0x0015, 0x7802, 0x620b,
0x6ac8, 0x7c03, 0x0000, 0x55db, 0x9a63, 0x0007, 0x68cc, 0x680c,
0x55d3, 0x4d00, 0x7d03, 0x4d02, 0x7d02, 0x9ab8, 0x0017, 0x0017,
0x55db, 0x009d, 0x55fb, 0x05a0, 0x08ff, 0x0011, 0x18ff, 0x0010,
0x04b8, 0x04ad, 0x0454, 0x62ff, 0x7ee8, 0x0870, 0x0011, 0x5010,
0x52c0, 0x53c8, 0xc10d, 0x7d89, 0x0200, 0x9a55, 0x0200, 0x9a52,
0xc19d, 0xc0ec, 0x7d52, 0x0c70, 0x0411, 0x5414, 0x5ac4, 0x028c,
0x58da, 0x5efa, 0xc0fe, 0x56fa, 0x7d02, 0x0200, 0x9ad9, 0x6d03,
0x5bca, 0x5cd2, 0x0bff, 0x0311, 0x1bff, 0x04bb, 0x0415, 0x53da,
0x0a70, 0x0211, 0x4c00, 0x7d28, 0x552a, 0x05bb, 0x4d00, 0x7c02,
0x0400, 0x9aec, 0x4c01, 0x7d0f, 0x008f, 0x0015, 0x04d8, 0x7d01,
0x008c, 0x0020, 0x04a0, 0x0015, 0x7802, 0x650b, 0x5d06, 0x0000,
0x7e0c, 0x7f0d, 0x9aea, 0x650a, 0x7e08, 0x008d, 0x0011, 0x0010,
0x05a8, 0x065f, 0x5d06, 0x063f, 0x7f02, 0x0007, 0x680c, 0x0007,
0x5012, 0x54d0, 0x0454, 0x9b16, 0x5012, 0x54d0, 0x0473, 0x7c06,
0x552a, 0x05b9, 0x4d00, 0x7c02, 0x0400, 0x9b18, 0x52c0, 0x53c8,
0xc10d, 0x0288, 0x7db6, 0x0200, 0x9ad9, 0x0200, 0x9ad1, 0x0870,
0x0011, 0x5010, 0xc0ec, 0x7d46, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe,
0x56f8, 0x7d02, 0x0200, 0x9b2d, 0x0b70, 0x0311, 0x6ed3, 0x6d03,
0x0dff, 0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d2b, 0x522b, 0x02b9,
0x4a00, 0x7c04, 0x62c8, 0x7e1f, 0x0400, 0x9b3e, 0x008f, 0x00d5,
0x7d01, 0x008d, 0x05a0, 0x0060, 0x7c05, 0x6edd, 0x6209, 0x7e16,
0x6ac8, 0x7f11, 0x0015, 0x0060, 0x7c05, 0x6ede, 0x620a, 0x7e0e,
0x6ac8, 0x7f09, 0x6edf, 0x0015, 0x7802, 0x620b, 0x6ac8, 0x0000,
0x7e05, 0x7f01, 0x9b3c, 0x0007, 0x68cc, 0x9b68, 0x0007, 0x6a0c,
0x0454, 0x62c8, 0x7ef8, 0x5013, 0x52c0, 0x53c8, 0xc10d, 0x7dbd,
0x0200, 0x9b2d, 0x0200, 0x9b2a, 0xc19d, 0x0870, 0x0011, 0xc0ec,
0x7d29, 0x5010, 0x5ac0, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200,
0x9b7b, 0x0870, 0x0011, 0x6d03, 0x0dff, 0x0511, 0x1dff, 0x05bc,
0x4d00, 0x7d12, 0x5228, 0x02b9, 0x4a00, 0x7c02, 0x0400, 0x9b8a,
0x620b, 0x7e06, 0x5a06, 0x7f06, 0x0000, 0x2504, 0x7d05, 0x9b8a,
0x0007, 0x680c, 0x0007, 0x0454, 0x5010, 0x52c0, 0xc10d, 0x7ddb,
0x0200, 0x9b7b, 0x0200, 0x9b77, 0xc19d, 0x0870, 0x0011, 0xc0ec,
0x7d76, 0x5010, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02,
0x0200, 0x9bab, 0x6d03, 0x0d03, 0x0512, 0x05bc, 0x0510, 0x5dd0,
0x0dff, 0x0511, 0x1dff, 0x05bc, 0x5df8, 0x4d00, 0x7d57, 0x0a70,
0x0211, 0x532a, 0x5212, 0x03b9, 0x4b00, 0x7c02, 0x0400, 0x9bbf,
0x008f, 0x05d8, 0x7d01, 0x008d, 0x05a0, 0x5dda, 0x55d2, 0x4d00,
0x7d27, 0x4d02, 0x7d20, 0x4d01, 0x7d1a, 0x0a70, 0x0211, 0x52ea,
0x0260, 0x7d05, 0x6509, 0x7e25, 0x630a, 0x7e23, 0x9be3, 0x630a,
0x7e20, 0x6509, 0x7e1e, 0x0512, 0x0512, 0x03ad, 0x5b06, 0x7f19,
0x2003, 0x4800, 0x7ced, 0x0a70, 0x0211, 0x5212, 0x9bfe, 0x7802,
0x6309, 0x5b06, 0x9bfd, 0x0015, 0x7802, 0x630a, 0x5b06, 0x9bfd,
0x0015, 0x0015, 0x7802, 0x630b, 0x5b06, 0x7c03, 0x55da, 0x0000,
0x9bbd, 0x0007, 0x680c, 0x55d2, 0x4d00, 0x7d03, 0x4d02, 0x7d02,
0x9c0b, 0x0017, 0x0017, 0x55da, 0x009d, 0x55fa, 0x05a0, 0x08ff,
0x0011, 0x18ff, 0x0010, 0x04b8, 0x04ad, 0x0454, 0x0870, 0x0011,
0x5010, 0x52c0, 0x53c8, 0xc10d, 0x7d8e, 0x0200, 0x9bab, 0x0200,
0x9ba7, 0xc19d, 0x0870, 0x0011, 0xc0ec, 0x7d35, 0x5010, 0x5ac0,
0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200, 0x9c28, 0x0870, 0x0011,
0x6d07, 0x0dff, 0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d1c, 0x5228,
0x02b9, 0x4a00, 0x7c04, 0x6928, 0x7f0b, 0x0400, 0x9c37, 0x5206,
0x7e10, 0x6a0b, 0x6928, 0x7f04, 0x0000, 0x2504, 0x7d0c, 0x9c37,
0x0007, 0x680c, 0x680c, 0x6207, 0x6a07, 0x6a2b, 0x6a28, 0x0007,
0x680c, 0x0007, 0x0454, 0x6928, 0x7ff3, 0x5010, 0x52c0, 0xc10d,
0x7dcf, 0x0200, 0x9c28, 0x0200, 0x9c24, 0xc19d, 0x0870, 0x0011,
0xc0ec, 0x7d2d, 0x5010, 0x5ac0, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02,
0x0200, 0x9c64, 0x0870, 0x0011, 0x6dd7, 0x0dff, 0x0511, 0x1dff,
0x05bc, 0x4d00, 0x7d14, 0x5228, 0x02b9, 0x4b00, 0x7c04, 0x62c8,
0x7e0a, 0x0400, 0x9c73, 0x5206, 0x7e08, 0x6ac8, 0x7f04, 0x0000,
0x2504, 0x7d05, 0x9c73, 0x0007, 0x68ff, 0x0007, 0x0454, 0x62c8,
0x7efa, 0x5010, 0x52c0, 0xc10d, 0x7dd7, 0x0200, 0x9c64, 0x0200,
0x9c60, 0x0870, 0x0011, 0x5010, 0xc0ec, 0x7d7c, 0x5ac0, 0x5bc8,
0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200, 0x9c97, 0x6ed3, 0x6dc5,
0x0dff, 0x0511, 0x1dff, 0x05bc, 0x5df8, 0x4d00, 0x7d60, 0x0b70,
0x0311, 0x522b, 0x5313, 0x02b9, 0x4a00, 0x7c02, 0x0400, 0x9ca7,
0x008f, 0x00d5, 0x7d01, 0x008d, 0x05a0, 0x5ddb, 0x0d03, 0x0512,
0x05bc, 0x0510, 0x5dd3, 0x4d00, 0x7d2c, 0x4d02, 0x7d24, 0x4d01,
0x7d1e, 0x59e3, 0x0b70, 0x0311, 0x53eb, 0x61c8, 0x7e2b, 0x62c8,
0x7e29, 0x65c8, 0x7e27, 0x0360, 0x7d03, 0x0112, 0x0112, 0x9cd2,
0x0512, 0x0512, 0x0211, 0x02a9, 0x02ad, 0x6ac8, 0x7f1b, 0x2003,
0x4800, 0x7ceb, 0x0b70, 0x0311, 0x5313, 0x51e3, 0x9cef, 0x7802,
0x62c8, 0x6ac8, 0x9cee, 0x6dce, 0x0015, 0x7802, 0x62c8, 0x6ac8,
0x9cee, 0x6dcf, 0x0015, 0x0015, 0x7801, 0x62d8, 0x7c03, 0x0000,
0x55db, 0x9ca5, 0x0007, 0x68ff, 0x55d3, 0x4d00, 0x7d03, 0x4d02,
0x7d02, 0x9cfc, 0x0017, 0x0017, 0x55db, 0x009d, 0x55fb, 0x05a0,
0x08ff, 0x0011, 0x18ff, 0x0010, 0x04b8, 0x04ad, 0x0454, 0x62c8,
0x7ee9, 0x0870, 0x0011, 0x5010, 0x52c0, 0x53c8, 0xc10d, 0x7d87,
0x0200, 0x9c97, 0x0200, 0x9c94, 0xc19d, 0x0870, 0x0011, 0xc0ec,
0x7d29, 0x5010, 0x5ac0, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200,
0x9d1b, 0x0870, 0x0011, 0x6dc7, 0x0dff, 0x0511, 0x1dff, 0x05bc,
0x4d00, 0x7d12, 0x5228, 0x02b9, 0x4a00, 0x7c02, 0x0400, 0x9d2a,
0x62c8, 0x7e06, 0x5a06, 0x7f06, 0x0000, 0x2504, 0x7d05, 0x9d2a,
0x0007, 0x68ff, 0x0007, 0x0454, 0x5010, 0x52c0, 0xc10d, 0x7ddb,
0x0200, 0x9d1b, 0x0200, 0x9d17, 0xc19d, 0x0870, 0x0011, 0xc0ec,
0x7d7c, 0x5010, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02,
0x0200, 0x9d4b, 0x6dc5, 0x0d03, 0x0512, 0x05bc, 0x0510, 0x5dd0,
0x0dff, 0x0511, 0x1dff, 0x05bc, 0x5df8, 0x4d00, 0x7d5d, 0x0a70,
0x0211, 0x532a, 0x5212, 0x03b9, 0x4b00, 0x7c02, 0x0400, 0x9d5f,
0x008f, 0x05d8, 0x7d01, 0x008d, 0x05a0, 0x5dda, 0x55d2, 0x4d00,
0x7d2c, 0x4d02, 0x7d24, 0x4d01, 0x7d1e, 0x59e2, 0x0a70, 0x0211,
0x52ea, 0x61c8, 0x7e2c, 0x63c8, 0x7e2a, 0x65c8, 0x7e28, 0x0260,
0x7d03, 0x0112, 0x0112, 0x9d86, 0x0512, 0x0512, 0x0311, 0x03a9,
0x03ad, 0x5b06, 0x7f1c, 0x2003, 0x4800, 0x7ceb, 0x0a70, 0x0211,
0x5212, 0x51e2, 0x9da4, 0x7802, 0x63c8, 0x5b06, 0x9da3, 0x6dce,
0x0015, 0x7802, 0x63c8, 0x5b06, 0x9da3, 0x6dcf, 0x0015, 0x0015,
0x7802, 0x63c8, 0x5b06, 0x7c03, 0x55da, 0x0000, 0x9d5d, 0x0007,
0x68ff, 0x55d2, 0x4d00, 0x7d03, 0x4d02, 0x7d02, 0x9db1, 0x0017,
0x0017, 0x55da, 0x009d, 0x55fa, 0x05a0, 0x08ff, 0x0011, 0x18ff,
0x0010, 0x04b8, 0x04ad, 0x0454, 0x0870, 0x0011, 0x5010, 0x52c0,
0x53c8, 0xc10d, 0x7d88, 0x0200, 0x9d4b, 0x0200, 0x9d47, 0xc19d,
0x0870, 0x0011, 0xc0ec, 0x7d61, 0x5010, 0x5ac0, 0x5bc8, 0x5ef8,
0xc0fe, 0x56f8, 0x7d02, 0x0200, 0x9dce, 0x6d07, 0x5df0, 0x0dff,
0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d45, 0x0a70, 0x0211, 0x532a,
0x5212, 0x03b9, 0x4b00, 0x7c04, 0x6a28, 0x7f3b, 0x0400, 0x9ddd,
0x008f, 0x05d8, 0x7d01, 0x008d, 0x05a0, 0x0b03, 0x0312, 0x03bc,
0x0310, 0x4b00, 0x7d1c, 0x4b02, 0x7d20, 0x4b01, 0x7d23, 0x0a70,
0x0211, 0x52ea, 0x5306, 0x7e25, 0x0260, 0x7d02, 0x0310, 0x0312,
0x6b09, 0x7f1f, 0x0312, 0x6b09, 0x7f1c, 0x0312, 0x6b09, 0x7f19,
0x2003, 0x4800, 0x7cef, 0x0a70, 0x0211, 0x5212, 0x9e1e, 0x0015,
0x0015, 0x7802, 0x5306, 0x6b0b, 0x9e1d, 0x0015, 0x7802, 0x5306,
0x6b0a, 0x9e1d, 0x7802, 0x5306, 0x6b09, 0x7c03, 0x6b28, 0x0000,
0x9ddb, 0xc77b, 0x6928, 0x7ffd, 0x0870, 0x0011, 0x5010, 0x52c0,
0x53c8, 0xc10d, 0x7da3, 0x0200, 0x9dce, 0x0200, 0x9dca, 0xc19d,
0x0870, 0x0011, 0xc0ec, 0x7d60, 0x5010, 0x5ac0, 0x5bc8, 0x5ef8,
0xc0fe, 0x56f8, 0x7d02, 0x0200, 0x9e36, 0x6dd7, 0x5df0, 0x0dff,
0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d46, 0x0a70, 0x0211, 0x532a,
0x5212, 0x03b9, 0x4b00, 0x7c02, 0x0400, 0x9e45, 0x008f, 0x05d8,
0x7d01, 0x008d, 0x05a0, 0x0b03, 0x0312, 0x03bc, 0x0310, 0x4b00,
0x7d28, 0x4b02, 0x7d20, 0x4b01, 0x7d19, 0x6ddd, 0x0a70, 0x0211,
0x52ea, 0x5306, 0x7e27, 0x0260, 0x7d02, 0x0310, 0x0312, 0x6bc8,
0x7f21, 0x0312, 0x6bc8, 0x7f1e, 0x0312, 0x6bc8, 0x7f1b, 0x2003,
0x4800, 0x7cef, 0x0a70, 0x0211, 0x5212, 0x9e87, 0x6ddd, 0x7802,
0x5306, 0x6bc8, 0x9e86, 0x6dde, 0x0015, 0x7802, 0x5306, 0x6bc8,
0x9e86, 0x0015, 0x0015, 0x7802, 0x5306, 0x6bc8, 0x7c03, 0x0000,
0xde96, 0x9e43, 0xc777, 0x0870, 0x0011, 0x5010, 0x52c0, 0x53c8,
0xc10d, 0x7da4, 0x0200, 0x9e36, 0x0200, 0x9e32, 0x63ff, 0x0368,
0x7d02, 0x0369, 0x7def, 0x0006, 0x0870, 0x0011, 0x5010, 0xc0ec,
0x7d5c, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe, 0x56f8, 0x7d02, 0x0200,
0x9ea2, 0x0b70, 0x0311, 0x6ec3, 0x6d07, 0x5df0, 0x0dff, 0x0511,
0x1dff, 0x05bc, 0x4d00, 0x7d3e, 0x522b, 0x02b9, 0x4a00, 0x7c04,
0x6a28, 0x7f34, 0x0400, 0x9eb4, 0x028e, 0x1a94, 0x6ac3, 0x62c8,
0x0269, 0x7d1b, 0x1e94, 0x6ec3, 0x6ed3, 0x62c8, 0x0248, 0x6ac8,
0x2694, 0x6ec3, 0x62c8, 0x026e, 0x7d32, 0x6a09, 0x7f1f, 0x2501,
0x4d00, 0x7d20, 0x028e, 0x1a98, 0x6ac3, 0x62c8, 0x6ec3, 0x0260,
0x7df1, 0x6a28, 0x7f13, 0xc7af, 0x9ef4, 0x6ee3, 0x008f, 0x2001,
0x00d5, 0x7d01, 0x008d, 0x05a0, 0x62c8, 0x026e, 0x7d18, 0x6a09,
0x7f05, 0x2001, 0x7cf9, 0x6a28, 0x0000, 0x9eb2, 0x0289, 0xc77b,
0x018a, 0x9f03, 0x6a28, 0x7ffa, 0x0b70, 0x0311, 0x5013, 0x52c0,
0x53c8, 0xc10d, 0x7da7, 0x0200, 0x9ea2, 0x0200, 0x9e9f, 0x6a28,
0x7fed, 0xc7af, 0x9f03, 0x0458, 0x0454, 0x9ef4, 0xc19d, 0x0870,
0x0011, 0xc0ec, 0x7d55, 0x5010, 0x5ac0, 0x5bc8, 0x5ef8, 0xc0fe,
0x56f8, 0x7d02, 0x0200, 0x9f0d, 0x0b70, 0x0311, 0x6d07, 0x5df0,
0x0dff, 0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d37, 0x522b, 0x02b9,
0x4a00, 0x7c04, 0x6928, 0x7f2d, 0x0400, 0x9f1e, 0x028e, 0x1a94,
0x5202, 0x0269, 0x7d16, 0x1e94, 0x5206, 0x0248, 0x5a06, 0x2694,
0x5206, 0x026e, 0x7d2f, 0x6a09, 0x7f1c, 0x2501, 0x4d00, 0x7d1d,
0x028e, 0x1a98, 0x5202, 0x0260, 0x7df3, 0x6a28, 0x7f12, 0xc7af,
0x9f57, 0x008f, 0x2001, 0x00d5, 0x7d01, 0x008d, 0x05a0, 0x5206,
0x026e, 0x7d18, 0x6a09, 0x7f05, 0x2001, 0x7cf9, 0x6a28, 0x0000,
0x9f1c, 0x0289, 0xc77b, 0x018a, 0x9f66, 0x6928, 0x7ffa, 0x0b70,
0x0311, 0x5013, 0x52c0, 0x53c8, 0xc10d, 0x7daf, 0x0200, 0x9f0d,
0x0200, 0x9f09, 0x6a28, 0x7fed, 0xc7af, 0x9f66, 0x0458, 0x0454,
0x9f57
};
#endif
