/*
 *  arch/arm/mach-realview/include/mach/io.h
 *
 *  Copyright (C) 2003 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARM_ARCH_IO_H
#define __ASM_ARM_ARCH_IO_H

#include <asm/mach-types.h>
#include <mach/hardware.h>
#include <mach/board-eb.h>
#include <mach/board-pb11mp.h>

#define IO_SPACE_LIMIT 0xffffffff

#ifdef CONFIG_PCI
static inline void __iomem *__pci_io(unsigned long addr)
{
	switch(machine_arch_type){
#ifdef CONFIG_PCI_HOST_REALVIEW_PB11MP
	case MACH_TYPE_REALVIEW_PB11MP:
		return (void __iomem *)(addr + __pci_io_pb11mp);
#endif
#ifdef CONFIG_PCI_HOST_REALVIEW_EB
	case MACH_TYPE_REALVIEW_EB:
		return (void __iomem *)(addr + __pci_io_eb);
#endif
	default:
		return __typesafe_io(addr);
	}
}
#define __io(a)		__pci_io(a)
#else
#define __io(a)		__typesafe_io(a)
#endif
#define __mem_pci(a)	(a)

#endif
