/*
 *  arch/arm/mach-realview/include/mach/timex.h
 *
 *  RealView architecture timex specifications
 *
 *  Copyright (C) 2003 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define CLOCK_TICK_RATE		(50000000 / 16)

extern unsigned long long sched_clock(void);
#define mach_read_cycles sched_clock

#define mach_cycles_to_usecs(d) (do_div(d, NSEC_PER_USEC), d)
#define mach_usecs_to_cycles(d) (d * NSEC_PER_USEC)
