/*
 * Copyright 2005-2006 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

/*
 * @file op_model_arm11_l2em.h
 *
 * @brief ARM1136 L2 Cache EVTMON Register definitions
 *
 * @ingroup MXC_Oprofile
 */
#ifndef __EVTMON_REGS_H__
#define __EVTMON_REGS_H__

#define ECT_CTI_BASE		(IO_ADDRESS(ECT_CTIO_BASE_ADDR))
#define CLKCTR_BASE_ADDR	(IO_ADDRESS(CLKCTL_BASE_ADDR))
#define L2EM_BASE_ADDRESS       (IO_ADDRESS(EVTMON_BASE_ADDR))

/* L2 INT settings */
#define L2EM_ENABLE_OVERFLOWINT	0x1
#define L2EM_ENABLE_CNTINCRINT	0x3
#define L2EM_ENABLE_MASK	0x1
#define L2EM_INT_EDGE		0x2
#define L2EM_INT_HIGH		0x4
#define L2EM_INT_CLK_CYCLES	(0x0 << 3)

/* Set L2 EVTMON counter interrupt type and enable it */
#define EM_SET_INT		L2EM_ENABLE_CNTINCRINT

/* Reg definitions for EVTMON */
#define L2EM_CTRL           (L2EM_BASE_ADDRESS + 0x0)
#define L2EM_STAT           (L2EM_BASE_ADDRESS + 0x4)
#define L2EM_CC(nr)         (L2EM_BASE_ADDRESS + 0x8 +(4*nr))
#define L2EM_CNT(nr)        (L2EM_BASE_ADDRESS + 0x20 +(4*nr))


/* Reg definitions for CLK_CTL */
#define CLKCTL_SET_CTRL    (CLKCTR_BASE_ADDR + 0x04)

/* Reg definitions for ECT */
#define ECT_CTI_CONTROL   (ECT_CTI_BASE + 0x0)
#define ECT_CTI_LOCK      (ECT_CTI_BASE + 0x8)
#define ECT_CTI_INEN(nr)  (ECT_CTI_BASE + 0x20 + (4*nr))
#define ECT_CTI_OUTEN(nr) (ECT_CTI_BASE + 0xA0 + (4*nr))
#define ECT_CTI_INTACK    (ECT_CTI_BASE + 0x10)
#define ECT_CTI_TRIGOUTSTATUS    (ECT_CTI_BASE + 0x134)

#define EVTMON_ENABLE		0x001	/* Enable EVTMON */


#ifdef CONFIG_SNSC_OPROFILE_ARM11_EVTMON_ECT_WORKAROUND
#define ENABLE_CTI_CLOCK	0x00000020
#define UNLOCK_ECT_CODE 	0x0ACCE550
#define ECT_CTI_CHAN_2		0x4
#define ECT_CTI_CHAN_3		0x8
#define ECT_CTI_TRIGIN_1	1	/* pmu_irq, iMX31 RM, P6-20, Table6-7 */
#define ECT_CTI_TRIGIN_7	7	/* evtmon_interrupt */
#define ECT_CTI_TRIGOUT_2	2	/* ect_irq[0] -> INT_ECT, P6-20, Table 6-8*/
#define ECT_CTI_TRIGOUT_6	6	/* ect_arm_etmextout[0] -> PMU */
#define ENABLE_ECT		0x1
#define ACK_TRIG_OUT_2		0x4
#define ARM11_EVTMON_INT	MXC_INT_ECT	/* irq = 48 */
#else
#define ARM11_EVTMON_INT	ARM11_PMU_IRQ	/* INT_EVTMON, irq = 23 */
#endif


#ifdef CONFIG_SNSC_OPROFILE_ARM11_EVTMON
#define NUM_EVTMON_COUNTERS		4
int arm11_evtmon_setup_ctrs(void);
void arm11_evtmon_stop(void);
int arm11_evtmon_start(void);
#else
#define NUM_EVTMON_COUNTERS		0
#define arm11_evtmon_setup_ctrs() 	do {} while(0)
#define arm11_evtmon_stop() 		do {} while(0)
#define arm11_evtmon_start() 		do {} while(0)
#endif


#endif /* __EVTMON_REGS_H__ */

